package jp.ac.do_johodai.j314.sw.lms;

import jp.ac.do_johodai.j314.sw.je.*;

import com.hp.hpl.jena.query.*;
import com.hp.hpl.jena.rdf.model.*;
import com.hp.hpl.jena.util.FileManager;
import java.io.*;
import java.net.URL;
import java.util.*;
import java.text.SimpleDateFormat;

import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;

import org.apache.axis2.engine.ServiceLifeCycle;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.description.AxisService;

public class JenaLMS implements ServiceLifeCycle {
    static JenaEngine engine;
    static String confNS = "http://x314.do-johodai.ac.jp/JenaLMS/conf#";
    static Model config;
    static boolean use_rdb = false;
    static boolean timer_enable = false;
    static long timer_interval = 60000l;
    static String ruleFile;
    static String ontFile;
    static String dataFile;
    static String rdb_driver;
    static String rdb_url;
    static String rdb_user;
    static String rdb_passwd;
    static String rdb_type;
    static String rdb_model_name;

    public void startUp(ConfigurationContext configctx,AxisService service) {
        //おれおれ証明書のような証明書でも通信できるようにする。
        try {
            SSLContext ssl = SSLContext.getInstance("SSL");
            TrustManager[] tm = { new LazyTrustManager() };
            ssl.init(null, tm, null);
            HttpsURLConnection.setDefaultSSLSocketFactory(
                ssl.getSocketFactory()
            );
            HttpsURLConnection.setDefaultHostnameVerifier(
                new LazyHostnameVerifier()
            );
        } catch(Exception e) {
            e.printStackTrace();
        }
        
        String confFile = findConfFile();
        //System.out.println("configfile=" + confFile );
        if (confFile!=null) {
            config = FileManager.get().loadModel(confFile);
            String s = sGET(config,"use_rdb");
            if (s!=null)
                use_rdb = Boolean.parseBoolean(s);
            else
                use_rdb = false;
            ruleFile = sGET(config,"ruleFile");
            ontFile = sGET(config,"ontFile");
            dataFile = sGET(config,"dataFile");
            rdb_driver     = sGET(config,"rdb_driver");
            rdb_url        = sGET(config,"rdb_url");
            rdb_user       = sGET(config,"rdb_user");
            rdb_passwd     = sGET(config,"rdb_passwd");
            rdb_type       = sGET(config,"rdb_type");
            rdb_model_name = sGET(config,"rdb_model_name");

            s = sGET(config,"timer_enable");
            if (s!=null)
                timer_enable = Boolean.parseBoolean(s);
            else
                timer_enable = false;
            s = sGET(config,"timer_interval");
            if (s!=null)
                timer_interval = Long.parseLong(s);
            else
                timer_interval = 60000l;
        }
        if (use_rdb==false)
            engine = new JenaEngine();
        else
            try {
                engine = new JenaEngine(rdb_driver,rdb_url,rdb_user,
                                        rdb_passwd,rdb_type,rdb_model_name);
            } catch(Exception e) {
                e.printStackTrace();
                engine = new JenaEngine();
            }
        engine.setEnableOWLDL(true);
        // 有効にしたいビルトインを追加していきます。
        // 代入と標準入力ビルトイン
        engine.registerBuiltin(new BindBuiltin());
        //engine.registerBuiltin(new ReadBuiltin());
        engine.registerBuiltin(new RandIntBuiltin());
        engine.registerBuiltin(new String2IntBuiltin());
        engine.registerBuiltin(new ListBuiltin());
        engine.registerBuiltin(new ConsBuiltin());
        engine.registerBuiltin(new List2StringBuiltin());
        engine.registerBuiltin(new ListAppendBuiltin());
        engine.registerBuiltin(new PrintListBuiltin());
        engine.registerBuiltin(new StartsWithBuiltin());
        engine.registerBuiltin(new EndsWithBuiltin());
        engine.registerBuiltin(new NotStartsWithBuiltin());
        engine.registerBuiltin(new NotEndsWithBuiltin());
        engine.registerBuiltin(new StringConcatBuiltin());
        engine.registerBuiltin(new StringFormatBuiltin());
        engine.registerBuiltin(new Int2StringBuiltin());
        engine.registerBuiltin(new StateSetBuiltin());
        engine.registerBuiltin(new StateGetBuiltin());
        engine.registerBuiltin(new StatePrintBuiltin());
        engine.registerBuiltin(new SMailBuiltin());
        engine.registerBuiltin(new Long2DateTimeBuiltin());
        engine.registerBuiltin(new DateTime2LongBuiltin());
        // Axis2に依存するビルトイン
        engine.registerBuiltin(new SendN3Builtin());

        if (ruleFile!=null) {
            System.out.println("rulefile=" + ruleFile);
            engine.loadRules(ruleFile);
        }
        if (ontFile!=null) {
            System.out.println("ontfile=" + ontFile);
            engine.loadRDF(ontFile);
        }
        if ((use_rdb==false)&&(dataFile!=null)) {
            System.out.println("datafile=" + dataFile);
            engine.appendRDF(dataFile);
        }
        if (timer_enable==true) {
            System.out.println("timer_enable=true;timer_interval=" + timer_interval);
            engine.setTimerInterval(timer_interval);
            engine.setTimer(true);
        }
        System.out.println("JenaLMS.startUp()");
    }

    public void shutDown(ConfigurationContext configctx, AxisService service) {
        System.out.println("JenaLMS.shutDown()");
        engine.destroy();
    }

    static {
    }
    static String sGET(Model m,String p) {
        String ret = null;
        Property pro = m.getProperty(confNS+p);
        NodeIterator i = m.listObjectsOfProperty(pro);
        RDFNode n = null;
        if (i.hasNext()) {
            n = i.nextNode();
            ret = n.toString();
        }
        return ret;
    }
    static String findConfFile() {
        String ret = "/etc/jenalms.ttl";
        File f = new File(ret);
        if (f.exists())
            return ret;
        ret = "C:\\WINDOWS\\jenalms.ttl";
        f = new File(ret);
        if (f.exists())
            return f.toURI().toString();
        ret = System.getProperty("user.home")+".jenalms.ttl";
        if (f.exists())
            return ret;
        return null;
    }

    public JenaLMS() {
    }

    /**
     * Notation3を追加する時に使用するオペレーション．
     * 主にエージェントどうしが通信する時に使用する．
     */
    public boolean n3_insert(String n3) {
        JEAdapter a = new JEAdapter() {
            public void performResultMessage(JEMessage m) {
                System.out.println("JenaLMS.n3_insert(). called!");
            }
        };
        JEMessage m = new JEMessage(JEMessage.Type.INSERT_N3, a, n3);
        engine.recieveRequest(m);
        return true;
    }


    /**
     * SPARQLの検索のためのオペレーション．
     * 同期呼出しとなるので，デッドロックに気を付けるべし．
     */
    public String sparql(String query) {
        System.out.println("JenaLMS.sparql(). called!");
        return engine.execSPARQL(query);
    }

    /**
     * SPARQLを使ってRDFデータの中の三つ組を削除するための
     * オペレーション．
     * 同期呼出しとなるので，デッドロックに気を付けるべし．
     */
    public String deleteSPARQL(String query) {
        System.out.println("JenaLMS.deleteSPARQL(). called!");
        return engine.deleteSPARQL(query);
    }

    /**
     * SPARQLを使ってRDFデータの中の三つ組を追加するための
     * オペレーション．
     * 同期呼出しとなるので，デッドロックに気を付けるべし．
     */
    public String insertSPARQL(String query) {
        System.out.println("JenaLMS.insertSPARQL(). called!");
        return engine.insertSPARQL(query);
    }

    /**
     * SPARQLを使ってRDFデータの中の三つ組を更新するための
     * オペレーション．
     * 同期呼出しとなるので，デッドロックに気を付けるべし．
     */
    public boolean delAndInsSPARQL(String delQuery,String insQuery) {
        System.out.println("JenaLMS.delAndInsSPARQL(). called!");
        return engine.deleteAndInsertSPARQL(delQuery,insQuery);
    }

    /**
     * SPARQLのSELECTを実行して，結果を文字列の2次元配列で
     * 返すオペレーション．同期呼出しなのでデッドロックに気をつけるべし．
     */
    public String[][] sparql_select(String query) {
        System.out.println("JenaLMS.sparql_select(). called!");
        return engine.execSelectArray(query);
    }

    /**
     * SPARQLのCONSTRUCTを実行して，結果を文字列の2次元配列で
     * 返すオペレーション．同期呼出しなのでデッドロックに気をつけるべし．
     */
    public String[][] sparql_construct(String query) {
        System.out.println("JenaLMS.sparql_construct(). called!");
        return engine.execConstructArray(query);
    }

    /**
     * SPARQLのDESCRIBEを実行して，結果を文字列の2次元配列で
     * 返すオペレーション．同期呼出しなのでデッドロックに気をつけるべし．
     */
    public String[][] sparql_describe(String query) {
        System.out.println("JenaLMS.sparql_describe(). called!");
        return engine.execDescribeArray(query);
    }
    
    /**
     * JenaLMS起動時にJenaEngineが読み込んだはずのルール
     * ファイルの中身を返すオペレーション。(本当はJenaEngine
     * から取り出せば良いのだけれど、確か汚なくなってしまったと思った)
     */
    public String getRules(String dummy) {
        System.out.println("JenaLMS.getRules(). called!");
        if (ruleFile==null)
            return null;
        try {
            URL url = new URL(ruleFile);
            InputStreamReader isr = new InputStreamReader(url.openStream(),"UTF-8");
            BufferedReader br = new BufferedReader(isr);
            String retStr = "";
            String sTmp;
            while ((sTmp = br.readLine())!=null) {
                retStr = retStr + sTmp + "\n";
            }
            return retStr;
        } catch(Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /**
     * JenaEngineのルールをリセットして新しいルールを
     * 設定すると同時に、ルールファイルにも、その内容を
     * 保存する。
     */
    public String setRules(String rules) {
        System.out.println("JenaLMS.setRules(). called!");
        try {
            engine.setRules(rules);
            URL url = new URL(ruleFile);
            OutputStream os = new FileOutputStream(url.getFile());
            Writer w = new OutputStreamWriter(os,"UTF-8");
            w.write(rules);
            w.flush();
            w.close();
            return "ok";
        }catch(Exception e) {
            e.printStackTrace();
            return "fail";
        }
    }

    abstract class JEAdapter implements JEListener {
        public abstract void performResultMessage(JEMessage m);
    }
    public String[][] test(String s) {
        System.out.println("JenaLMS.test(). called!");
        String ret[][] = new String[2][2];
        ret[0][0] = s+":00";
        ret[0][1] = s+":01";
        ret[1][0] = s+":10";
        ret[1][1] = s+":11";
        return ret;
    }

    /**
     * 教材が開かれた時に呼ばれるオペレーション
     * userID : ユーザID
     * tmURL  : 教材のURL
     */
    public String lmsInitialize(String userID,String tmURL) {
        System.out.println("JenaLMS.lmsInitialize(). called!");
        System.out.println("    userID: "+userID);
        System.out.println("    tmURL : "+tmURL);

        String time = date2string(new Date());
        String req = "PREFIX : <http://x314.do-johodai.ac.jp/JenaLMS/>\n";
         req = req + "PREFIX dc: <http://purl.org/dc/elements/1.1/>\n";
         req = req + "PREFIX foaf: <http://xmlns.com/foaf/0.1/>\n";
         req = req + "CONSTRUCT {\n";
         req = req + "  [] a :tm_open_event ;\n";
         req = req + "     :user ?user ;\n";
         req = req + "     :content ?content ;\n";
         req = req + "     dc:date '"+time+"'^^<http://www.w3.org/2001/XMLSchema#dateTime> .\n";
         req = req + "}\n";
         req = req + "WHERE {\n";
         req = req + "  ?user a foaf:Person ;\n";
         req = req + "      :userID '"+userID+"' .\n";
         req = req + "  ?content a :edu_material ;\n";
         req = req + "      :url '"+tmURL+"' .\n";
         req = req + "}\n";
        engine.insertSPARQL(req);

        return "dummy";
    }

    /**
     * 教材が閉じられた時に呼ばれるオペレーション
     * userID : ユーザID
     * tmURL  : 教材のURL
     */
    public String lmsFinish(String userID,String tmURL) {
        System.out.println("JenaLMS.lmsFinish(). called!");
        System.out.println("    userID: "+userID);
        System.out.println("    tmURL : "+tmURL);

        String time = date2string(new Date());
        String req = "PREFIX : <http://x314.do-johodai.ac.jp/JenaLMS/>\n";
         req = req + "PREFIX dc: <http://purl.org/dc/elements/1.1/>\n";
         req = req + "PREFIX foaf: <http://xmlns.com/foaf/0.1/>\n";
         req = req + "CONSTRUCT {\n";
         req = req + "  [] a :tm_close_event ;\n";
         req = req + "     :user ?user ;\n";
         req = req + "     :content ?content ;\n";
         req = req + "     dc:date '"+time+"'^^<http://www.w3.org/2001/XMLSchema#dateTime> .\n";
         req = req + "}\n";
         req = req + "WHERE {\n";
         req = req + "  ?user a foaf:Person ;\n";
         req = req + "      :userID '"+userID+"' .\n";
         req = req + "  ?content a :edu_material ;\n";
         req = req + "      :url '"+tmURL+"' .\n";
         req = req + "}\n";
        engine.insertSPARQL(req);

        return "dummy";
    }

    /**
     * LMSのデータを読み出すためのオペレーション
     * userID : ユーザID
     * tmURL  : 教材のURL
     * dataName : dataName
     */
    public String[] lmsGetValue(String userID,String tmURL,String dataName) {
        System.out.println("JenaLMS.lmsGetValue(). called!");
        System.out.println("    userID  : "+userID);
        System.out.println("    tmURL   : "+tmURL);
        System.out.println("    dataName: "+dataName);
        //dataNameがcmi.core.student_nameの場合はユーザIDを返す．
        if (dataName.equals("cmi.core.student_name")) {
            String[] ret = new String[1];
            ret[0] = userID;
            return ret;
        }
        String req = "PREFIX : <http://x314.do-johodai.ac.jp/JenaLMS/>\n";
         req = req + "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\n";
         req = req + "PREFIX foaf: <http://xmlns.com/foaf/0.1/>\n";
         req = req + "PREFIX owl: <http://www.w3.org/2002/07/owl#>\n";
         req = req + "SELECT ?x\n";
         req = req + "WHERE {\n";
         req = req + "   ?user a foaf:Person ;\n";
         req = req + "       :userID '"+userID+"' .\n";
         req = req + "   ?content a :edu_material ;\n";
         req = req + "       :url '"+tmURL+"' .\n";
         req = req + "   ?s a :SCORMDATA ;\n";
         req = req + "       :user ?user ;\n";
         req = req + "       :content ?content ;\n";
         req = req + "       :dataName '"+dataName+"' ;\n";
         req = req + "       :data     ?b .\n";
         req = req + "   ?b rdf:first ?x .\n";
         req = req + "}\n";
        ResultSet rs = engine.execSelect(req);
        if (rs.hasNext()) {
            QuerySolution qs = rs.nextSolution();
            String ret[] = new String[1];
            ret[0] = qs.get("x").toString();
            return ret;
        } else {
            String ret[] = new String[1];
            ret[0] = "";
            return ret;
        }
    }

    /**
     * LMSにデータを保存するためのオペレーション
     * userID : ユーザID
     * tmURL  : 教材のURL
     * dataSet : dataNameとdataのペア
     *           このペアは複数あってもよい．
     *           なのでこの配列の長さは偶数．
     */
    public String lmsSetValue(String userID,String tmURL,String dataSet[]) {
        if ((dataSet.length%2)!=0) {
            System.out.println("JenaLMS.lmsSetValue(). Bad dataSet!!");
        } else {
            System.out.println("JenaLMS.lmsSetValue(). called!");
            System.out.println("    userID  : "+userID);
            System.out.println("    tmURL   : "+tmURL);
            System.out.println("    dataSet: ");
            for (int i=0;i<(dataSet.length/2);i++) {
                System.out.println("        "+dataSet[2*i]+":"+dataSet[2*i+1]);
            }
            for (int i=0;i<(dataSet.length/2);i++) {
                //もし事前に設定されているものがあれば削除
                String req = "PREFIX : <http://x314.do-johodai.ac.jp/JenaLMS/>\n";
                 req = req + "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\n";
                 req = req + "PREFIX foaf: <http://xmlns.com/foaf/0.1/>\n";
                 req = req + "PREFIX owl: <http://www.w3.org/2002/07/owl#>\n";
                 req = req + "CONSTRUCT {\n";
                 req = req + "  ?s a :edu_material ;\n";
                 req = req + "      :user ?user ;\n";
                 req = req + "      :content ?content ;\n";
                 req = req + "      :dataName '"+dataSet[2*i]+"' ;\n";
                 req = req + "      :content ?b .\n";
                 req = req + "  ?b rdf:first ?data ;\n";
                 req = req + "      rdf:rest ?rest .\n";
                 req = req + "}\n";
                 req = req + "WHERE {\n";
                 req = req + "  ?user a foaf:Person ;\n";
                 req = req + "      :userID '"+userID+"' .\n";
                 req = req + "  ?content a :edu_material ;\n";
                 req = req + "      :url '"+tmURL+"' .\n";
                 req = req + "  ?s a :SCORMDATA ;\n";
                 req = req + "      :user ?user ;\n";
                 req = req + "      :content ?content ;\n";
                 req = req + "      :dataName '"+dataSet[2*i]+"' ;\n";
                 req = req + "      :data ?b .\n";
                 req = req + "  ?b rdf:first ?data ;\n";
                 req = req + "      rdf:rest ?rest .\n";
                 req = req + "}\n";
                engine.deleteSPARQL(req);
                //実際に追加
                req        = "PREFIX : <http://x314.do-johodai.ac.jp/JenaLMS/>\n";
                 req = req + "PREFIX foaf: <http://xmlns.com/foaf/0.1/>\n";
                 req = req + "CONSTRUCT {\n";
                 req = req + "  _:s a :SCORMDATA ;\n";
                 req = req + "      :user ?user ;\n";
                 req = req + "      :content ?content ;\n";
                 req = req + "      :dataName '"+dataSet[2*i]+"' ;\n";
                 req = req + "      :data ('"+dataSet[2*i+1]+"') .\n";
                 req = req + "}\n";
                 req = req + "WHERE {\n";
                 req = req + "  ?user a foaf:Person ;\n";
                 req = req + "      :userID '"+userID+"' .\n";
                 req = req + "  ?content a :edu_material ;\n";
                 req = req + "      :url '"+tmURL+"' .\n";
                 req = req + "}\n";
                engine.insertSPARQL(req);
            }
        }
        return "dummy";
    }

    /**
     * LMSのデータを削除するためのオペレーション
     * userID : ユーザID
     * tmURL  : 教材のURL
     * dataName : dataName
     */
    public String lmsDelValue(String userID,String tmURL,String dataName) {
        System.out.println("JenaLMS.lmsDelValue(). called!");
        System.out.println("    userID  : "+userID);
        System.out.println("    tmURL   : "+tmURL);
        System.out.println("    dataName: "+dataName);
        String req ="PREFIX : <http://x314.do-johodai.ac.jp/JenaLMS/>\n";
        req = req + "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\n";
        req = req + "PREFIX foaf: <http://xmlns.com/foaf/0.1/>\n";
        req = req + "PREFIX owl: <http://www.w3.org/2002/07/owl#>\n";
        req = req + "CONSTRUCT {\n";
        req = req + "  ?s a :SCORMDATA ;\n";
        req = req + "      :user ?user ;\n";
        req = req + "      :content ?content ;\n";
        req = req + "      :dataName '"+dataName+"' ;\n";
        req = req + "      :data ?b . \n";
        req = req + "  ?b rdf:first ?data  ;\n";
        req = req + "      rdf:rest ?rest .\n";
        req = req + "}\n";
        req = req + "WHERE {\n";
        req = req + "  ?user a foaf:Person ;\n";
        req = req + "      :userID '"+userID+"' .\n";
        req = req + "  ?content a :edu_material ;\n";
        req = req + "      :url '"+tmURL+"' .\n";
        req = req + "  ?s a :SCORMDATA ;\n";
        req = req + "      :user ?user ;\n";
        req = req + "      :content ?content ;\n";
        req = req + "      :dataName '"+dataName+"' ;\n";
        req = req + "      :data ?b .\n";
        req = req + "  ?b rdf:first ?data ;\n";
        req = req + "      rdf:rest ?rest .\n";
        req = req + "}\n";
        engine.deleteSPARQL(req);
        return "dummy";
    }

    /**
     * LMSから全てのデータを読み出すためのオペレーション
     * userID : ユーザID
     * tmURL  : 教材のURL
     */
    public String[] lmsGetAllValue(String userID,String tmURL) {
        System.out.println("JenaLMS.lmsGetAllValue(). called!");
        System.out.println("    userID  : "+userID);
        System.out.println("    tmURL   : "+tmURL);
        String req = "PREFIX : <http://x314.do-johodai.ac.jp/JenaLMS/>\n";
         req = req + "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\n";
         req = req + "PREFIX foaf: <http://xmlns.com/foaf/0.1/>\n";
         req = req + "PREFIX owl: <http://www.w3.org/2002/07/owl#>\n";
         req = req + "SELECT ?dataName ?data\n";
         req = req + "WHERE {\n";
         req = req + "  ?user a foaf:Person ;\n";
         req = req + "      :userID '"+userID+"' .\n";
         req = req + "  ?content a :edu_material ;\n";
         req = req + "      :url '"+tmURL+"' .\n";
         req = req + "  ?s a :SCORMDATA ;\n";
         req = req + "      :user ?user ;\n";
         req = req + "      :content ?content ;\n";
         req = req + "      :dataName ?dataName ;\n";
         req = req + "      :data ?b .\n";
         req = req + "  ?b rdf:first ?data .\n";
         req = req + "}\n";
        ResultSet rs = engine.execSelect(req);
        ArrayList<String> al = new ArrayList<String>();
        while (rs.hasNext()) {
            QuerySolution qs = rs.nextSolution();
            al.add(qs.get("dataName").toString());
            al.add(qs.get("data").toString());
        }
        return al.toArray(new String[0]);
    }
    /**
     * 設定ファイルに指定してあるdataFileに
     * RDFモデルを保存する。
     */
    public String saveData(String userID) {
        System.out.println("JenaLMS.saveData(). called!");
        System.out.println("    userID  : "+userID);
        if (dataFile!=null) {
            engine.saveRDFAsN3(dataFile);
        } else {
            System.out.println("ERROR: dataFile is not specified.");
        }
        return "dummy";
    }

    //SCORMのパッケージを教材として登録するオペレーション
    //非同期ではないので少し注意．
    //教材のタイプの部分，未実装
    public String registSCORM(String manifest_url) {
        System.out.println("JenaLMS.registSCORM(). called!");
        System.out.println("    manifest_url : "+manifest_url);

        MetaData md[] = ProcessManifest.process(manifest_url);
        if (md!=null) {
            String req;
            for (int i=0;i<md.length;i++) {
                req       = "@prefix : <http://x314.do-johodai.ac.jp/JenaLMS/> .\n";
                req = req + "@prefix l: <http://x314.do-johodai.ac.jp/JenaLMS/learnings/> .\n";
                req = req + "@prefix dc: <http://purl.org/dc/elements/1.1/> .\n";
                req = req + "@prefix dct: <http://purl.org/dc/terms/> .\n";
                req = req + "[] a :"+md[i].type+" ;\n";
                req = req + "    :url '"+md[i].url+"' ;\n";
                req = req + "    dc:title '"+md[i].title+"' ;\n";
                req = req + "    dc:description '"+md[i].description+"' ;\n";
                req = req + "    dc:creator '"+md[i].creator+"' ;\n";
                req = req + "    dct:created '"+md[i].created+"' ;\n";
                req = req + "    dct:modified '"+md[i].modified+"' ;\n";
                for (int j=0;j<md[i].requires.length;j++) {
                    req = req + "    dct:requires l:"+md[i].requires[j]+" ;\n";
                }
                for (int j=0;j<md[i].hasPart.length;j++) {
                    req = req + "    dct:hasPart l:"+md[i].hasPart[j]+" ;\n";
                }
                req = req + "    :difficulty :"+md[i].difficulty+" ;\n";
                req = req + "    :learningtime '"+md[i].learningtime+"' .\n";
                engine.addNotation3(req);
            }
            for (int i=0;i<md.length;i++) {
                System.out.println("        md["+i+"]"+md[i].url);
            }
        }

        return md!=null?"OK":"fail";
    }
    //SCORMのSCO一個一個を教材として登録するオペレーション
    //非同期ではないので少し注意．
    //教材のタイプの部分，未実装
    public String registSCO(String url,String title,String description,
                            String creator,String created,String modified,
                            String requires,String hasPart,String difficulty,
                            String learningtime) {
        try {
            String requiresA[] = requires.split(":");
            String hasPartA[] = hasPart.split(":");
            String req = "@prefix : <http://x314.do-johodai.ac.jp/JenaLMS/> .\n";
             req = req + "PREFIX l: <http://x314.do-johodai.ac.jp/JenaLMS/learnings/>\n";
             req = req + "@prefix dc: <http://purl.org/dc/elements/1.1/> .\n";
             req = req + "@prefix dct: <http://purl.org/dc/terms/> .\n";
             req = req + "PREFIX owl: <http://www.w3.org/2002/07/owl#>\n";
             req = req + "[] a :edu_material ;\n";
             req = req + "    :url '"+url+"' ;\n";
             req = req + "    dc:title '"+title+"' ;\n";
             req = req + "    dc:description '"+description+"' ;\n";
             req = req + "    dc:creator '"+creator+"' ;\n";
             req = req + "    dct:created '"+created+"' ;\n";
             req = req + "    dct:modified '"+modified+"' ;\n";
             for (int i=0;i<requiresA.length;i++)
                 req = req + "    dct:requires l:"+requiresA[i]+" ;\n";
             for (int i=0;i<hasPartA.length;i++)
                 req = req + "    dct:hasPart l:"+hasPartA[i]+" ;\n";
             req = req + "    :difficulty :"+difficulty+" ;\n";
             req = req + "    :learningtime '"+learningtime+"' .\n";
             engine.addNotation3(req);
            return "OK";
        } catch(Exception e) {
            e.printStackTrace();
            return "BAD";
        }
    }

    //スレッド自体がフォーラムに追加された時イベント情報の追加と
    //教材の登録をするメソッド
    public String event_add_thread0(String userID,String tmURL,String title) {
        System.out.println("JenaLMS.event_add_thread0(). called!");
        System.out.println("    userID  : "+userID);
        System.out.println("    tmURL   : "+tmURL);
        System.out.println("    title   : "+title);

        //registSCOメソッドを使って教材登録．
        registSCO(tmURL,title,"",userID,"2007-06-20T10:30:06+09:00",
                  "2007-06-20T10:30:06+09:00","","","medium","00:10:00");

        String time = date2string(new Date());
        String req = "PREFIX : <http://x314.do-johodai.ac.jp/JenaLMS/>\n";
         req = req + "PREFIX dc: <http://purl.org/dc/elements/1.1/>\n";
         req = req + "PREFIX foaf: <http://xmlns.com/foaf/0.1/>\n";
         req = req + "PREFIX owl: <http://www.w3.org/2002/07/owl#>\n";
         req = req + "CONSTRUCT {\n";
         req = req + "  [] a :書き込み ;\n";
         req = req + "      :user ?user ;\n";
         req = req + "      :content ?content ;\n";
         req = req + "      dc:date '"+time+"'^^<http://www.w3.org/2001/XMLSchema#dateTime> .\n";
         req = req + "}\n";
         req = req + "WHERE {\n";
         req = req + "  ?user a foaf:Person ;\n";
         req = req + "      :userID '"+userID+"' .\n";
         req = req + "  ?content a :edu_material ;\n";
         req = req + "      :url '"+tmURL+"' .\n";
         req = req + "}\n";
        engine.insertSPARQL(req);
        return "dummy";
    }
    //スレッドの書き込みイベントを記録するメソッド
    public String event_add_thread(String userID,String tmURL) {
        System.out.println("JenaLMS.event_add_thread(). called!");
        System.out.println("    userID  : "+userID);
        System.out.println("    tmURL   : "+tmURL);
        String time = date2string(new Date());
        String req = "PREFIX : <http://x314.do-johodai.ac.jp/JenaLMS/>\n";
         req = req + "PREFIX dc: <http://purl.org/dc/elements/1.1/>\n";
         req = req + "PREFIX foaf: <http://xmlns.com/foaf/0.1/>\n";
         req = req + "PREFIX owl: <http://www.w3.org/2002/07/owl#>\n";
         req = req + "CONSTRUCT {\n";
         req = req + "  [] a :書き込み ;\n";
         req = req + "      :user ?user ;\n";
         req = req + "      :content ?content ;\n";
         req = req + "      dc:date '"+time+"'^^<http://www.w3.org/2001/XMLSchema#dateTime> .\n";
         req = req + "}\n";
         req = req + "WHERE {\n";
         req = req + "  ?user a foaf:Person ;\n";
         req = req + "      :userID '"+userID+"' .\n";
         req = req + "  ?content a :edu_material ;\n";
         req = req + "      :url '"+tmURL+"' .\n";
         req = req + "}\n";
        engine.insertSPARQL(req);
        return "dummy";
    }

    //イベントを新しい順に取り出してテキストにして返すメソッド
    public String[][] get_recent_events(String dummy) {
        System.out.println("JenaLMS.get_recent_event(). called!");
        String req = "PREFIX : <http://x314.do-johodai.ac.jp/JenaLMS/>\n";
         req = req + "PREFIX dc: <http://purl.org/dc/elements/1.1/> \n";
         req = req + "PREFIX foaf: <http://xmlns.com/foaf/0.1/> \n";
         req = req + "PREFIX owl: <http://www.w3.org/2002/07/owl#>\n";
         req = req + "SELECT DISTINCT ?title ?username ?url \n";
         req = req + "WHERE {\n";
         req = req + "  ?event a :event ;\n";
         req = req + "      :user ?user ;\n";
         req = req + "      :content ?content ;\n";
         req = req + "      dc:date ?date .\n";
         req = req + "  ?user a foaf:Person ;\n";
         req = req + "      foaf:name ?username .\n";
         req = req + "  ?content a :edu_material ;\n";
         req = req + "      dc:title ?title .\n";
         req = req + "  ?content a :edu_material ;\n";
         req = req + "      :url ?url .\n";
         req = req + "}\n";
         req = req + "ORDER BY DESC(?date) LIMIT 10\n";
         req = req + "\n";
        ResultSet rs = engine.execSelect(req);
        ArrayList<String[]> al = new ArrayList<String[]>();
        while (rs.hasNext()) {
            String s[] = new String[3];
            QuerySolution qs = rs.nextSolution();
            s[0] = qs.get("title").toString();
            s[1] = qs.get("username").toString();
            s[2] = qs.get("url").toString();
            al.add(s);
        }
        if (al.size()==0) {
            String s[] = new String[3];
            s[0] = "no event available.";
            s[1] = "dummy";
            s[2] = "http://dummy.org/";
            al.add(s);
        }
        return (String[][])al.toArray(new String[0][0]);
    } 
    private String date2string(Date d) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        return sdf.format(d);
    }

    //ユーザIDを引数として，その学生が受講している
    //講義をリストアップする．戻り値は講義IDと講義のタイトル
    //からなるリストのリスト
    public String[][] search_courses(String userID) {
        System.out.println("JenaLMS.search_courses(). called!");
        String req = "PREFIX : <http://x314.do-johodai.ac.jp/JenaLMS/>\n";
         req = req + "PREFIX foaf: <http://xmlns.com/foaf/0.1/> \n";
         req = req + "PREFIX owl: <http://www.w3.org/2002/07/owl#>\n";
         req = req + "SELECT DISTINCT ?id ?title \n";
         req = req + "WHERE {\n";
         req = req + "  ?user a foaf:Person ;\n";
         req = req + "      :userID '"+userID+"' .\n";
         req = req + "  ?course a :course ;\n";
         req = req + "      :id ?id ;\n";
         req = req + "      :title ?title ;\n";
         req = req + "      :student ?user .\n";
         req = req + "}\n";
         req = req + "\n";
        ResultSet rs = engine.execSelect(req);
        ArrayList<String[]> al = new ArrayList<String[]>();
        while (rs.hasNext()) {
            String s[] = new String[2];
            QuerySolution qs = rs.nextSolution();
            s[0] = qs.get("id").toString();
            s[1] = qs.get("title").toString();
            al.add(s);
        }
        return (String[][])al.toArray(new String[0][0]);
    }

    //講義IDを引数として，その講義に登録されている授業を
    //リストアップする．戻り値は授業IDと授業のタイトル
    //からなるリストのリスト
    public String[][] get_lessons(String cID) {
        System.out.println("JenaLMS.get_lessons(). called!");
        String req = "PREFIX : <http://x314.do-johodai.ac.jp/JenaLMS/>\n";
         req = req + "PREFIX list: <http://jena.hpl.hp.com/ARQ/list#>\n";
         req = req + "PREFIX owl: <http://www.w3.org/2002/07/owl#>\n";
         req = req + "SELECT DISTINCT ?id ?title \n";
         req = req + "WHERE {\n";
         req = req + "  ?course a :course ;\n";
         req = req + "      :id '"+cID+"' ;\n";
         req = req + "      :lessons ?list .\n";
         req = req + "  ?list list:member ?lessonData .\n";
         req = req + "  ?lessonData :lesson ?lesson .\n";
         req = req + "  ?lesson :id ?id ;\n";
         req = req + "      :title ?title .\n";
         req = req + "}\n";
        ResultSet rs = engine.execSelect(req);
        ArrayList<String[]> al = new ArrayList<String[]>();
        while (rs.hasNext()) {
            String s[] = new String[2];
            QuerySolution qs = rs.nextSolution();
            s[0] = qs.get("id").toString();
            s[1] = qs.get("title").toString();
            al.add(s);
        }
        return (String[][])al.toArray(new String[0][0]);
    }

    //授業IDを引数として，その授業に登録されている教材の情報を
    //リストアップする．戻り値は授業IDと授業のタイトル
    //からなるリストのリスト．けれど最初のリストの要素は
    //授業のイントロのタイトルとかURLの情報
    //返り値の例
    // {{"イントロ","http://localhost/test/intro.html","dummy"},
    //  {"教材その1","http://localhost/test/k1.html","http://localhost/test/note1.html"},
    //  {"教材その2","http://localhost/test/k2.html","http://localhost/test/note2.html"}}
    public String[][] get_materials(String lID) {
        System.out.println("JenaLMS.get_materials(). called!");
        String req = "PREFIX : <http://x314.do-johodai.ac.jp/JenaLMS/>\n";
         req = req + "PREFIX list: <http://jena.hpl.hp.com/ARQ/list#>\n";
         req = req + "PREFIX owl: <http://www.w3.org/2002/07/owl#>\n";
         req = req + "SELECT DISTINCT ?introURL\n";
         req = req + "WHERE {\n";
         req = req + "  ?lesson a :lesson ;\n";
         req = req + "      :id '"+lID+"' ;\n";
         req = req + "      :introduction ?introURL .\n";
         req = req + "}\n";
        ResultSet rs = engine.execSelect(req);
        ArrayList<String[]> al = new ArrayList<String[]>();
        while (rs.hasNext()) {
            String s[] = new String[3];
            QuerySolution qs = rs.nextSolution();
            s[0] = "はじめに";
            s[1] = qs.get("introURL").toString();
            s[2] = "dummy";
            al.add(s);
        }
               req = "PREFIX : <http://x314.do-johodai.ac.jp/JenaLMS/>\n";
         req = req + "PREFIX dc: <http://purl.org/dc/elements/1.1/> \n";
         req = req + "PREFIX list: <http://jena.hpl.hp.com/ARQ/list#>\n";
         req = req + "PREFIX owl: <http://www.w3.org/2002/07/owl#>\n";
         req = req + "SELECT DISTINCT ?title ?url ?note \n";//なんでDISTINCTが必要？？？
         req = req + "WHERE {\n";
         req = req + "  ?lesson a :lesson ;\n";
         req = req + "      :id '"+lID+"' ;\n";
         req = req + "      :contents ?list .\n";
         req = req + "  ?list list:member ?content .\n";
         req = req + "  ?content :em ?em ;\n";
         req = req + "      :note ?note .\n";
         req = req + "  ?em dc:title ?title ;\n";
         req = req + "      :url ?url .\n";
         req = req + "}\n";
        rs = engine.execSelect(req);
        while (rs.hasNext()) {
            String s[] = new String[3];
            QuerySolution qs = rs.nextSolution();
            s[0] = qs.get("title").toString();
            s[1] = qs.get("url").toString();
            s[2] = qs.get("note").toString();
            al.add(s);
        }
        return (String[][])al.toArray(new String[0][0]);
    }

    //学習項目を引数として受け取り，その学習項目を理解するのに
    //必要な教材のリストを生成する．
    public String get_tm_list1(String gk) {
        System.out.println("JenaLMS.get_tm_list1(). called!");
        gk = gk.trim();
        if (gk.equals(""))
            return "no\n";
        String gks[] = gk.split(",");
        for (int i=0;i<gks.length;i++)
            gks[i] = gks[i].trim();
        HashSet<String> al = new HashSet<String>();
        for (int i=0;i<gks.length;i++) {
            String req = "PREFIX : <http://x314.do-johodai.ac.jp/JenaLMS/>\n";
             req = req + "PREFIX l: <http://x314.do-johodai.ac.jp/JenaLMS/learnings/>\n";
             req = req + "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\n";
             req = req + "PREFIX dc: <http://purl.org/dc/elements/1.1/> \n";
             req = req + "PREFIX dct: <http://purl.org/dc/terms/>\n";
             req = req + "PREFIX owl: <http://www.w3.org/2002/07/owl#>\n";
             req = req + "SELECT DISTINCT ?url ?title ?description\n";
             req = req + "WHERE {\n";
             req = req + "  ?x a :edu_material ;\n";
             req = req + "     :url ?url ;\n";
             req = req + "     dc:title ?title ;\n";
             req = req + "     dc:description ?description .\n";
             req = req + "  {\n";
             req = req + "    { ?x dct:hasPart l:"+gks[i]+" . }\n";
             req = req + "    UNION\n";
             req = req + "    { ?x dct:hasPart ?a . l:"+gks[i]+" :requires ?a . }\n";
             req = req + "    UNION\n";
             req = req + "    { ?x dct:hasPart ?a . l:"+gks[i]+" owl:equivalentClass ?a . }\n";
             req = req + "  }\n";
             req = req + "}\n";
             req = req + "ORDER BY ?title \n";
        ResultSet rs = engine.execSelect(req);
            while (rs.hasNext()) {
                QuerySolution qs = rs.nextSolution();
                al.add(qs.get("url").toString() + "\n    " + qs.get("title").toString()
                                                + "\n    " + qs.get("description").toString());
            }
        }
        String retStr = "";
        for (String s : al) {
            retStr = retStr + s + "\n";
        }
        if (retStr.equals(""))
            return "no\n";
        else
            return retStr;
    }
    
    //授業管理・分析の情報を書き込むメソッド
    public String lesson_add(String title,String description, 
                              String difficulty, 
                              String goal, String learningtime,
                              String contents, String introduction) {
        String[] tmpString = null;//subgoal用
        tmpString = goal.split(":");
        String[] tmpContents1 = null;//contents用
        String[] tmpContents2 = null;//教材とnote 
        String[][] insertContents = null;
        if (contents == null) {
            contents = "";
        } else if (contents != "") {
            tmpContents1 = contents.split(";");
            insertContents = new String[tmpContents1.length][2];
            for(int cCount = 0; cCount < tmpContents1.length; cCount++) {
                tmpContents2 = tmpContents1[cCount].split("&");
                insertContents[cCount][0] = tmpContents2[0];
                if(tmpContents2.length == 1) {
                    insertContents[cCount][1] = "";
                } else {
                    insertContents[cCount][1] = tmpContents2[1];
                }
                
            }
        }
        
        
        System.out.println("JenaLMS.lesson_add. called!");
        System.out.println("    title: "+title);
        System.out.println("    description: "+description);
        System.out.println("    level: "+difficulty);
        System.out.println("    goal: "+goal);
        System.out.println("    learningtime: "+learningtime);
        System.out.println("    contents: "+contents);
        System.out.println("    introduction: "+introduction);
        String req = "PREFIX : <http://x314.do-johodai.ac.jp/JenaLMS/>\n";
         req = req + "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\n";
         req = req + "PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\n";
         req = req + "PREFIX xsd: <http://www.w3.org/2001/XMLSchema#>\n";
         req = req + "PREFIX dct: <http://purl.org/dc/terms/>\n"; 
         req = req + "PREFIX l: <http://x314.do-johodai.ac.jp/JenaLMS/learnings/>\n";
         req = req + "PREFIX dc: <http://purl.org/dc/elements/1.1/> \n";
         req = req + "PREFIX foaf: <http://xmlns.com/foaf/0.1/> \n";
         req = req + "PREFIX owl: <http://www.w3.org/2002/07/owl#>\n";
         req = req + "CONSTRUCT {\n";
         req = req + "  [] a :lesson ;\n";
         req = req + "     :title '" + title + "' ;\n";
         req = req + "     :description '" + description + "' ;\n";
         req = req + "     :difficulty :" + difficulty + " ;\n";
         for(int i = 0; i < tmpString.length; i++){
             req = req + "     :goal l:" + tmpString[i]+" ;\n";
         }
         req = req + "     :learningtime '" + learningtime + "' ;\n"; 
         req = req + "     :introduction '" + introduction + "' ;\n";
         if (contents != "") {
             req = req + "     :contents (";
             for (int j = 0; j < insertContents.length; j++) {
                 req = req + " [ :em ?b"+j+ " ; ";
                 req = req + ":note '" + insertContents[j][1] + "' ]\n";
             }
             req = req + ") ;\n";
         } else {
             req = req + "     :contents '"+contents+"' ;\n";
         }
         req = req + "     :dummy ?x .\n";
         req = req + "}\n";
         req = req + "WHERE {\n";
         if (contents != "") {
             for (int j = 0; j < insertContents.length; j++) {
                 req = req + "  ?b"+j+" a :edu_material ;\n";
                 req = req + "      dc:title '"+insertContents[j][0]+"' .\n";
             }
         }
         req = req + "}\n";
        engine.insertSPARQL(req);
        return "dummy";
    }
    public String[] lesson_object_load(String og) {
        System.out.println("JenaLMS.lesson_object_load(). called!");
        String req = "PREFIX : <http://x314.do-johodai.ac.jp/JenaLMS/>\n";
         req = req + "PREFIX l: <http://x314.do-johodai.ac.jp/JenaLMS/learnings/>\n";
         req = req + "PREFIX dc: <http://purl.org/dc/elements/1.1/> \n";
         req = req + "PREFIX foaf: <http://xmlns.com/foaf/0.1/> \n";
         req = req + "PREFIX owl: <http://www.w3.org/2002/07/owl#>\n";
         req = req + "SELECT DISTINCT ?goal \n";
         req = req + "WHERE {\n";
         req = req + "  ?x :title ?title .\n";
         req = req + "  ?x :goal ?goal .\n";
         req = req + "      FILTER ( ?title = '"+og+"' ) \n";
         req = req + "}\n";
        ResultSet rs = engine.execSelect(req);
        ArrayList<String> al = new ArrayList<String>();
        while (rs.hasNext()) {
            QuerySolution qs = rs.nextSolution();
            al.add(qs.get("goal").toString());
        }
        return (String[])al.toArray(new String[0]);
    }
    
    //授業管理・設計画面で分析の情報を取り出して返すメソッド
    public String[][] lesson_object_fullLoad(String og) {
        System.out.println("JenaLMS.lesson_object_fullLoad(). called!");
        String req = "PREFIX : <http://x314.do-johodai.ac.jp/JenaLMS/>\n";
         req = req + "PREFIX l: <http://x314.do-johodai.ac.jp/JenaLMS/learnings/>\n";
         req = req + "PREFIX dc: <http://purl.org/dc/elements/1.1/> \n";
         req = req + "PREFIX foaf: <http://xmlns.com/foaf/0.1/> \n";
         req = req + "PREFIX owl: <http://www.w3.org/2002/07/owl#>\n";
         req = req + "SELECT DISTINCT * \n";
         req = req + "WHERE {\n";
         req = req + "  ?x :title ?title .\n";
         req = req + "  ?x :description ?description .\n";
         req = req + "  ?x :learningtime ?learningtime .\n";
         req = req + "  ?x :difficulty ?difficulty .\n";
         req = req + "  ?x :goal ?goal .\n";
         req = req + "  ?x :contents ?contents .\n";
         req = req + "  ?x :introduction ?introduction .\n";
         req = req + "  ?x :id ?id .\n";
         req = req + "      FILTER ( ?title = '"+og+"' ) \n";
         req = req + "}\n";
        ResultSet rs = engine.execSelect(req);
        ArrayList<String[]> al = new ArrayList<String[]>();
        while (rs.hasNext()) {
            String s[] = new String[8];
            QuerySolution qs = rs.nextSolution();
            s[0] = qs.get("title").toString();
            s[1] = qs.get("description").toString();
            s[2] = qs.get("learningtime").toString();
System.out.println(qs.get("difficulty").toString());
            if (qs.get("difficulty").toString().equals("http://x314.do-johodai.ac.jp/JenaLMS/low")) {
                s[3] = "low";
            } else if (qs.get("difficulty").toString().equals("http://x314.do-johodai.ac.jp/JenaLMS/medium")) {
                s[3] = "medium";
            } else if (qs.get("difficulty").toString().equals("http://x314.do-johodai.ac.jp/JenaLMS/high")) {
                s[3] = "high";
            }
            s[4] = qs.get("goal").toString();
            s[5] = qs.get("contents").toString();
            s[6] = qs.get("introduction").toString();
            s[7] = qs.get("id").toString();
            al.add(s);
        }
        return (String[][])al.toArray(new String[0][0]);
    }
    
    //設計画面の保存(今は未使用)
    public String lObject_add(String lobject) {
        System.out.println("JenaLMS.lObject_add. called!");
         lobject = lobject.substring(0,lobject.length()-1);
         String[] tmp = lobject.split(";");
         String[] obj;
         for(int i = 0; i < tmp.length; i++) {
             obj = tmp[i].split(":");
             String req = "PREFIX : <http://x314.do-johodai.ac.jp/JenaLMS/>\n";
             req = req + "PREFIX dc: <http://purl.org/dc/elements/1.1/> \n";
             req = req + "PREFIX foaf: <http://xmlns.com/foaf/0.1/> \n";
             req = req + "PREFIX owl: <http://www.w3.org/2002/07/owl#>\n";
             req = req + "CONSTRUCT {\n";
             req = req + "  [] a :subgoal ;\n";
             req = req + "     :subgoalname '"+obj[0]+"' ;\n";
              for(int j =1; j < obj.length; j++) {
                  req = req + "     :title '"+obj[j]+"' ;\n";
              }
              req = req + "     :dummy ?x .\n";
              req = req + "}\n";
              req = req + "WHERE {\n";
              req = req + "}\n";
             System.out.println(req);
             engine.insertSPARQL(req);
         }
        return "dummy";
    }
    
    
    public String[] lObject_load(String sg) {
        System.out.println("lObject_load(). called!");
        String req = "PREFIX : <http://x314.do-johodai.ac.jp/JenaLMS/>\n";
         req = req + "PREFIX dc: <http://purl.org/dc/elements/1.1/> \n";
         req = req + "PREFIX foaf: <http://xmlns.com/foaf/0.1/> \n";
         req = req + "PREFIX owl: <http://www.w3.org/2002/07/owl#>\n";
         req = req + "SELECT DISTINCT ?contents \n";
         req = req + "WHERE {\n";
         req = req + "  ?x :title ?title .\n";
         req = req + "  ?x :contents ?contents .\n";
         req = req + "      FILTER ( ?title = '"+sg+"' ) \n";
         req = req + "}\n";
        ResultSet rs = engine.execSelect(req);
        System.out.println(req);
        ArrayList<String> al = new ArrayList<String>();
        while (rs.hasNext()) {
            QuerySolution qs = rs.nextSolution();
            al.add(qs.get("contents").toString());
        }
        return (String[])al.toArray(new String[0]);
    }
    
    //学習項目とURLとキーワードを取り出す
    public String[][] get_tm_list2(String dummy) {
        System.out.println("JenaLMS.get_tm_list2(). called!");
        ArrayList<String[]> al = new ArrayList<String[]>();
        String req = "PREFIX : <http://x314.do-johodai.ac.jp/JenaLMS/>\n";
         req = req + "PREFIX l: <http://x314.do-johodai.ac.jp/JenaLMS/learnings/>\n";
         req = req + "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\n";
         req = req + "PREFIX dc: <http://purl.org/dc/elements/1.1/> \n";
         req = req + "PREFIX dct: <http://purl.org/dc/terms/>\n";
         req = req + "PREFIX owl: <http://www.w3.org/2002/07/owl#>\n";
         req = req + "SELECT DISTINCT ?url ?title ?hasPart \n";
         req = req + "WHERE {\n";
         req = req + "  ?x a :edu_material ;\n";
         req = req + "     :url ?url ;\n";
         req = req + "     dc:title ?title ;\n";
         req = req + "     dct:hasPart ?hasPart .\n";
         req = req + "}\n";
         req = req + "ORDER BY ?hasPart \n";
        ResultSet rs = engine.execSelect(req);
        while (rs.hasNext()) {
            QuerySolution qs = rs.nextSolution();   
            String s[] = new String[3];
            s[0] = qs.get("title").toString();
            s[1] = qs.get("hasPart").toString();
            s[2] = qs.get("url").toString();
            al.add(s);
        }
        return (String[][])al.toArray(new String[0][0]);
    }
    
    //教材のURLとタイトルと説明を返す
    public String get_tm_list3(String gk) {//AND検索
        System.out.println("JenaLMS.get_tm_list3(). called!");
        gk = gk.trim();
        if (gk.equals(""))
            return "no\n";
        String gks[] = gk.split(",");
        if(gks.length == 0) {
            gks[0] = gk;
        }
        HashSet<String> al = new HashSet<String>();
        String req = "PREFIX : <http://x314.do-johodai.ac.jp/JenaLMS/>\n";
         req = req + "PREFIX l: <http://x314.do-johodai.ac.jp/JenaLMS/learnings/>\n";
         req = req + "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\n";
         req = req + "PREFIX dc: <http://purl.org/dc/elements/1.1/> \n";
         req = req + "PREFIX dct: <http://purl.org/dc/terms/>\n";
         req = req + "PREFIX owl: <http://www.w3.org/2002/07/owl#>\n";
         req = req + "SELECT DISTINCT ?url ?title ?description\n";
         req = req + "WHERE {\n";
         req = req + "  ?x a :edu_material ;\n";
         req = req + "     :url ?url ;\n";
         req = req + "     dc:title ?title ;\n";
         req = req + "     dc:description ?description .\n";
         req = req + "  {\n";
        for (int i=0;i<gks.length;i++) {
            gks[i] = gks[i].trim();
            req = req + "    { ?x dct:hasPart l:"+gks[i]+" . }\n";
            req = req + "    UNION\n";
            req = req + "    { ?x dct:hasPart ?a . l:"+gks[i]+" owl:equivalentClass ?a . }\n";
         }
        
         req = req + "  }\n";
         req = req + "}\n";
         req = req + "ORDER BY ?title \n";
        ResultSet rs = engine.execSelect(req);
        while (rs.hasNext()) {
            QuerySolution qs = rs.nextSolution();
            al.add(qs.get("url").toString() + "\n" + qs.get("title").toString()
                                            + "\n" + qs.get("description").toString());
        }
        String retStr = "";
        for (String s : al) {
            retStr = retStr + s + "\n";
        }
        if (retStr.equals(""))
            return "no\n";
        else
            return retStr;
    }
    
    //教材のメタデータ全部を返す
    public String[][] get_tm_list4(String t) {
        System.out.println("JenaLMS.get_tm_list4(). called!");
        t = t.trim();
        ArrayList<String[]> al = new ArrayList<String[]>();
        String req = "PREFIX : <http://x314.do-johodai.ac.jp/JenaLMS/>\n";
         req = req + "PREFIX l: <http://x314.do-johodai.ac.jp/JenaLMS/learnings/>\n";
         req = req + "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\n";
         req = req + "PREFIX dc: <http://purl.org/dc/elements/1.1/> \n";
         req = req + "PREFIX dct: <http://purl.org/dc/terms/>\n";
         req = req + "PREFIX owl: <http://www.w3.org/2002/07/owl#>\n";
         req = req + "SELECT DISTINCT ?description ?creator ?created ?difficulty ?learningtime ?hasPart ?requires \n";
         req = req + "WHERE {\n";
         req = req + "  ?x a :edu_material ;\n";
         req = req + "     dc:description ?description ;\n";
         req = req + "     dc:creator ?creator ;\n";
         req = req + "     dct:created ?created ;\n";
         req = req + "     dct:hasPart ?hasPart ;\n";
         req = req + "     dct:requires ?requires ;\n";
         req = req + "     :difficulty ?difficulty ;\n";
         req = req + "     :learningtime ?learningtime ;\n";
         req = req + "     { ?x dc:title '" + t + "' . }\n";
         req = req + "}\n";
        ResultSet rs = engine.execSelect(req);
        while (rs.hasNext()) {
            QuerySolution qs = rs.nextSolution();
            String s[] = new String[7];
            s[0] = qs.get("creator").toString();
            s[1] = qs.get("created").toString();
            s[2] = qs.get("difficulty").toString();
            s[3] = qs.get("learningtime").toString();
            s[4] = qs.get("hasPart").toString();
            s[5] = qs.get("requires").toString();
            s[6] = qs.get("description").toString();
            al.add(s);
        }
        return (String[][])al.toArray(new String[0][0]);
    }
    
    //requiresの再起検索
    public String get_tm_list5(String gk) {
        System.out.println("JenaLMS.get_tm_list5(). called!");
        gk = gk.trim();
        if (gk.equals(""))
            return "no\n";
        String retStr = "";
        String req = get_tm_list5_5(gk, retStr);
        if (req.equals(""))
            return "no\n";
        else
            return req;
    }
    
    //requiresの再起検索（LAMPIXキーワード検索用）
    public String get_requireMaterials(String gk) {
        System.out.println("JenaLMS.get_requireMaterials(). called!");
        gk = gk.trim();
        if (gk.equals(""))
            return "no\n";
        String retStr = "";
        //String req = "";
        String[] tmp;
        for(int i = 0; i < 3; i++) {
            retStr = get_tm_list5_5(gk, retStr);
            tmp = retStr.split("\n");
            if(tmp.length >= 3) {
                break;
            }
            gk = tmp[tmp.length - 1];
        }
        //if (req.equals(""))
        //    return "no\n";
        //else
        System.out.println(retStr);
        return retStr;
    }
    
    //教材の再起検索
    public String get_tm_list5_5(String title, String retStr) {
        String checkStr = "";
        int checkCount = 0;
        System.out.println(title);
        HashSet<String> al = new HashSet<String>();
        String req = "PREFIX : <http://x314.do-johodai.ac.jp/JenaLMS/>\n";
         req = req + "PREFIX l: <http://x314.do-johodai.ac.jp/JenaLMS/learnings/>\n";
         req = req + "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\n";
         req = req + "PREFIX dc: <http://purl.org/dc/elements/1.1/> \n";
         req = req + "PREFIX dct: <http://purl.org/dc/terms/>\n";
         req = req + "PREFIX owl: <http://www.w3.org/2002/07/owl#>\n";
         req = req + "SELECT DISTINCT ?requires\n";
         req = req + "WHERE {\n";
         req = req + "  ?x a :edu_material ;\n";
         req = req + "     dct:requires ?requires ;\n";
         req = req + "     { ?x dc:title '" + title + "' . }\n";
         req = req + "}\n";
        ResultSet rs = engine.execSelect(req);
        while (rs.hasNext()) {
        rs.hasNext();
            QuerySolution qs = rs.nextSolution();
            al.add(qs.get("requires").toString());
        }
        for (String s : al) {
            String tmp[] = s.split("/");
            retStr = retStr + tmp[tmp.length - 1].trim() + "\n";
            checkStr = tmp[tmp.length - 1].trim();
            checkCount++;
            //System.out.println(tmp[tmp.length - 1].trim());
        }
        return retStr;
        /*
        if(checkStr.equals("") || checkCount > 1) {
            return retStr;
        } else {
            //return get_tm_list5_5(checkStr, retStr);
            return retStr;
        }
        */
    }
    
    //Lessonのタイトルを返す
    public String[] search_lesson() {
        System.out.println("search_lesson. called!");
        String req = "PREFIX : <http://x314.do-johodai.ac.jp/JenaLMS/>\n";
         req = req + "PREFIX l: <http://x314.do-johodai.ac.jp/JenaLMS/learnings/>\n";
         req = req + "PREFIX dc: <http://purl.org/dc/elements/1.1/> \n";
         req = req + "PREFIX foaf: <http://xmlns.com/foaf/0.1/> \n";
         req = req + "PREFIX owl: <http://www.w3.org/2002/07/owl#>\n";
         req = req + "SELECT DISTINCT ?title \n";
         req = req + "WHERE {\n";
         req = req + "  ?x a :lesson .\n";
         req = req + "  ?x   :title ?title .\n";
         req = req + "}\n";
        ResultSet rs = engine.execSelect(req);
        ArrayList<String> al = new ArrayList<String>();
        while (rs.hasNext()) {
            QuerySolution qs = rs.nextSolution();
            al.add(qs.get("title").toString());
        }
        return (String[])al.toArray(new String[0]);
    }
    
    //教室の説明を返す
    public String[] search_location() {
        System.out.println("search_location. called!");
        String req = "PREFIX : <http://x314.do-johodai.ac.jp/JenaLMS/>\n";
         req = req + "PREFIX l: <http://x314.do-johodai.ac.jp/JenaLMS/learnings/>\n";
         req = req + "PREFIX dc: <http://purl.org/dc/elements/1.1/> \n";
         req = req + "PREFIX foaf: <http://xmlns.com/foaf/0.1/> \n";
         req = req + "PREFIX owl: <http://www.w3.org/2002/07/owl#>\n";
         req = req + "SELECT DISTINCT ?description \n";
         req = req + "WHERE {\n";
         req = req + "  ?x a :location .\n";
         req = req + "  ?x   :description ?description .\n";
         req = req + "}\n";
        ResultSet rs = engine.execSelect(req);
        ArrayList<String> al = new ArrayList<String>();
        while (rs.hasNext()) {
            QuerySolution qs = rs.nextSolution();
            al.add(qs.get("description").toString());
        }
        return (String[])al.toArray(new String[0]);
    }
    
    //登録ユーザのIDと名前を返す
    public String[] search_parson() {
        System.out.println("search_parson. called!");
        String req = "PREFIX : <http://x314.do-johodai.ac.jp/JenaLMS/>\n";
         req = req + "PREFIX l: <http://x314.do-johodai.ac.jp/JenaLMS/learnings/>\n";
         req = req + "PREFIX dc: <http://purl.org/dc/elements/1.1/> \n";
         req = req + "PREFIX foaf: <http://xmlns.com/foaf/0.1/> \n";
         req = req + "PREFIX owl: <http://www.w3.org/2002/07/owl#>\n";
         req = req + "SELECT DISTINCT ?name ?userID \n";
         req = req + "WHERE {\n";
         req = req + "  ?x a foaf:Person .\n";
         req = req + "  ?x   foaf:name ?name .\n";
         req = req + "  ?x   :userID ?userID .\n";
         req = req + "}\n";
        ResultSet rs = engine.execSelect(req);
        ArrayList<String> al = new ArrayList<String>();
        while (rs.hasNext()) {
            QuerySolution qs = rs.nextSolution();
            al.add(qs.get("userID").toString()+" " +qs.get("name").toString());
        }
        return (String[])al.toArray(new String[0]);
    }
    
    //講義管理・分析の情報を書き込むメソッド
    public String lecture_add(String title,String teacher, 
                              String TA, String lessonName,
                              String lessonDate, String lessonLocation,
                              String studentID) {
        String[] teacherArray        = teacher.split(",");//teacher用配列
        String[] TAarray             = TA.split(",");//TA用配列
        String[] lessonNameArray     = lessonName.split(",");//授業用配列
        String[] lessonDateArray     = lessonDate.split(",");//日付用配列
        String[] lessonLocationArray = lessonLocation.split(",");//教室用配列
        String[] studentIDarray      = studentID.split(",");//学生用配列 
        int count = 0;//検索用
        int searchCount = 0;//検索用
        
        System.out.println("JenaLMS.lecture_add. called!");
        System.out.println("    title: "+ title);
        System.out.println("    teacher: "+ teacher);
        System.out.println("    TA: "+ TA);
        System.out.println("    lessonName: "+ lessonName);
        System.out.println("    lessonDate: "+ lessonDate);
        System.out.println("    lessonLocation: "+ lessonLocation);
        System.out.println("    studentID: "+ studentID);
        String req = "PREFIX : <http://x314.do-johodai.ac.jp/JenaLMS/>\n";
         req = req + "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\n";
         req = req + "PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\n";
         req = req + "PREFIX xsd: <http://www.w3.org/2001/XMLSchema#>\n";
         req = req + "PREFIX dct: <http://purl.org/dc/terms/>\n"; 
         req = req + "PREFIX l: <http://x314.do-johodai.ac.jp/JenaLMS/learnings/>\n";
         req = req + "PREFIX dc: <http://purl.org/dc/elements/1.1/> \n";
         req = req + "PREFIX foaf: <http://xmlns.com/foaf/0.1/> \n";
         req = req + "PREFIX owl: <http://www.w3.org/2002/07/owl#>\n";
         req = req + "CONSTRUCT {\n";
         req = req + "  [] a :course ;\n";
         req = req + "     :title '" + title + "' ;\n";
         req = req + "     :main_teacher ?b" + count + " ;\n";
         count++;
         for(int i = 1; i < teacherArray.length; i++) {
             req = req + "     :teacher ?b" + count + " ;\n";
             count++;
         }
         for(int i = 0; i < TAarray.length; i++) {
             req = req + "     :TA ?b" + count + " ;\n";
             count++;
         }
         req = req + "     :lessons (";
         for (int i = 0; i < lessonNameArray.length; i++) {
              req = req + " [ :lesson ?b" + count +  " ; ";
              count++;
              req = req + "dc:date '" + lessonDateArray[i] + "'^^<http://www.w3.org/2001/XMLSchema#dateTime> ; ";
              req = req +  "dct:spatial ?b" + count + " ]\n";
              count++;
         }
         req = req + ") ;\n";
         for(int i = 0; i < studentIDarray.length; i++) {
             req = req + "     :student ?b" + count + " ; \n";
             count++;
         }
         req = req + "     :dummy ?x .\n";
         req = req + "}\n";
         req = req + "WHERE {\n";
         for (int j = 0; j < teacherArray.length; j++) {
             req = req + "  ?b"+searchCount+" a foaf:Person ;\n";
             req = req + "      :userID '" + teacherArray[j] + "' .\n";
             searchCount++;
         }
         for (int j = 0; j < TAarray.length; j++) {
             req = req + "  ?b"+searchCount+" a foaf:Person ;\n";
             req = req + "      :userID '" + TAarray[j] + "' .\n";
             searchCount++;
         }
         for (int j = 0; j < lessonNameArray.length; j++) {
             req = req + "  ?b"+searchCount+" a :lesson ;\n";
             req = req + "      :title '" + lessonNameArray[j] + "' .\n";
             searchCount++;
             req = req + "  ?b"+searchCount+" a :location ;\n";
             req = req + "      :description '" + lessonLocationArray[j] + "' .\n";
             searchCount++;
         }
         for (int j = 0; j < studentIDarray.length; j++) {
             req = req + "  ?b"+searchCount+" a foaf:Person ;\n";
             req = req + "      :userID '" + studentIDarray[j] + "' .\n";
             searchCount++;
         }
         
         req = req + "}\n";
         System.out.println(req);
        engine.insertSPARQL(req);
        return "dummy";
    }
    
    //教材のURLを返す
    public String get_materialURL( String title ) {
        System.out.println("JenaLMS.get_materialURL. called!");
        String retStr = "";
        
        String req = "PREFIX : <http://x314.do-johodai.ac.jp/JenaLMS/>\n";
        req = req + "PREFIX l: <http://x314.do-johodai.ac.jp/JenaLMS/learnings/>\n";
        req = req + "PREFIX dc: <http://purl.org/dc/elements/1.1/> \n";
        req = req + "PREFIX owl: <http://www.w3.org/2002/07/owl#>\n";
        req = req + "SELECT DISTINCT ?url \n";
        req = req + "WHERE {\n";
        req = req + "  ?x a :edu_material ;\n";
        req = req + "       :url ?url ;\n";
        req = req + "     dc:title '" + title + "' ;\n";
        req = req + "}\n";
       ResultSet rs = engine.execSelect(req);
       ArrayList<String> al = new ArrayList<String>();
       while (rs.hasNext()) {
           QuerySolution qs = rs.nextSolution();
           al.add(qs.get("url").toString());
       }
       for (String s : al) {
           retStr = s;
       }
       return retStr;
    }
    
    //教材のタイトルを返す
    public String get_materialTitle() {
        System.out.println("JenaLMS.get_materialTitle. called!");
        String retStr = "";
        
        String req = "PREFIX : <http://x314.do-johodai.ac.jp/JenaLMS/>\n";
        req = req + "PREFIX l: <http://x314.do-johodai.ac.jp/JenaLMS/learnings/>\n";
        req = req + "PREFIX dc: <http://purl.org/dc/elements/1.1/> \n";
        req = req + "PREFIX owl: <http://www.w3.org/2002/07/owl#>\n";
        req = req + "SELECT DISTINCT ?title \n";
        req = req + "WHERE {\n";
        req = req + "  ?x a :edu_material ;\n";
        req = req + "       dc:title ?title ;\n";
        req = req + "}\n";
       ResultSet rs = engine.execSelect(req);
       ArrayList<String> al = new ArrayList<String>();
       while (rs.hasNext()) {
           QuerySolution qs = rs.nextSolution();
           al.add(qs.get("title").toString());
       }
       for (String s : al) {
           retStr += s + "\n";
       }
       return retStr;
    }
    
    //アンケートの記述された教材名を返す
    public String get_questionnaire1() {
        System.out.println("JenaLMS.get_questionnaire1. called!");
        String req = "PREFIX : <http://x314.do-johodai.ac.jp/JenaLMS/>\n";
         req = req + "PREFIX owl: <http://www.w3.org/2002/07/owl#>\n";
         req = req + "SELECT DISTINCT ?contentTitle \n";
         req = req + "WHERE {\n";
         req = req + "  ?x a :questionnaire ;\n";
         req = req + "       :contentTitle ?contentTitle .\n";
         req = req + "}\n";
        ResultSet rs = engine.execSelect(req);
        ArrayList<String> al = new ArrayList<String>();
        while (rs.hasNext()) {
            QuerySolution qs = rs.nextSolution();
            al.add(qs.get("contentTitle").toString());
        }
        String retStr = "";
        for (String s : al) {
            retStr += s + "\n";
        }
        return retStr;
    }
    
    //アンケート結果すべてを返す
    public String get_questionnaire2(String title) {
        System.out.println("JenaLMS.get_questionnaire2. called!");
        String req = "PREFIX : <http://x314.do-johodai.ac.jp/JenaLMS/>\n";
        req = req + "PREFIX owl: <http://www.w3.org/2002/07/owl#>\n";
        req = req + "SELECT DISTINCT ?userID ?contentTitle ?q1 ?q2 ?q3 \n";
        req = req + "WHERE {\n";
        req = req + "  ?x a :questionnaire ;\n";
        req = req + "     :userID ?userID ;\n";
        req = req + "     :q1 ?q1 ;\n";
        req = req + "     :q2 ?q2 ;\n";
        req = req + "     :q3 ?q3 ;\n";
        req = req + "     :contentTitle '" + title + "' .\n";
        req = req + "}\n";
       ResultSet rs = engine.execSelect(req);
       ArrayList<String> al = new ArrayList<String>();
       while (rs.hasNext()) {
           QuerySolution qs = rs.nextSolution();
           al.add(qs.get("q1").toString() + "," +qs.get("q2").toString() 
                                          + "," +qs.get("q3").toString());
       }
       String retStr = "";
       for (String s : al) {
           retStr += s + "\n";
       }
       return retStr;
    }
    
    //自分をrequiresとして持っている教材を探す
    public String get_ReversRrequires(String title) {
        System.out.println("JenaLMS.get_ReversRrequires. called!");
        String req = "PREFIX : <http://x314.do-johodai.ac.jp/JenaLMS/>\n";
         req = req + "PREFIX l: <http://x314.do-johodai.ac.jp/JenaLMS/learnings/>\n";
         req = req + "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\n";
         req = req + "PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\n";
         req = req + "PREFIX dc: <http://purl.org/dc/elements/1.1/>\n";
         req = req + "PREFIX dct: <http://purl.org/dc/terms/>\n";
         req = req + "PREFIX owl: <http://www.w3.org/2002/07/owl#>\n";
         req = req + "SELECT DISTINCT ?title ?description \n";
         req = req + "WHERE {\n";
         req = req + "    ?x a :edu_material ;\n";
         req = req + "          dct:requires l:" + title + " ;\n";
         req = req + "          dc:title ?title ;\n";
         req = req + "          dc:description ?description .\n";         
         req = req + "}";
       ResultSet rs = engine.execSelect(req);
       ArrayList<String> al = new ArrayList<String>();
       while (rs.hasNext()) {
           QuerySolution qs = rs.nextSolution();
           al.add(qs.get("title").toString() + "," +qs.get("description").toString());
       }
       String retStr = "";
       for (String s : al) {
           retStr += s + "\n";
       }
       return retStr;
    }
    
    public String search_user(String userID) {
        System.out.println("JenaLMS.search_user(). called!");
        userID = userID.trim();
        if (userID.equals("")) {
            return "no\n";
        }
        HashSet<String> al = new HashSet<String>();
        String req = "PREFIX : <http://x314.do-johodai.ac.jp/JenaLMS/>\n";
         req = req + "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\n";
         req = req + "PREFIX foaf: <http://xmlns.com/foaf/0.1/> \n";
         req = req + "PREFIX owl: <http://www.w3.org/2002/07/owl#>\n";
         req = req + "SELECT DISTINCT ?userID\n";
         req = req + "WHERE {\n";
         req = req + "  ?x a foaf:Person ;\n";
         req = req + "     :userID '" + userID + "' ;\n";
         req = req + "     :userID ?userID .\n";
         req = req + "}\n";
        ResultSet rs = engine.execSelect(req);
        while (rs.hasNext()) {
            QuerySolution qs = rs.nextSolution();
            al.add(qs.get("userID").toString());
        }
        String retStr = "";
        for (String s : al) {
            retStr += s;
        }
        if (retStr.equals(""))
            return "no";
        else
            return "yes";
    }
    
    public String user_add(String uname, String name, String pass,
                            String email, String user_intrest) {
        System.out.println("JenaLMS.user_add. called!");
        String req = "PREFIX : <http://x314.do-johodai.ac.jp/JenaLMS/>\n";
         req = req + "PREFIX l: <http://x314.do-johodai.ac.jp/JenaLMS/learnings/>\n";
         req = req + "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\n";
         req = req + "PREFIX foaf: <http://xmlns.com/foaf/0.1/> \n";
         req = req + "PREFIX owl: <http://www.w3.org/2002/07/owl#>\n";
         req = req + "CONSTRUCT {\n";
         req = req + "  [] a foaf:Person ;\n";
         req = req + "     foaf:mbox <mailto:" + email + "> ;\n";
         req = req + "     foaf:name '" + name + "';\n";
         req = req + "     foaf:gender '" + "';\n";
         req = req + "     foaf:topic_interest l:" + user_intrest + ";\n";
         req = req + "     :userID '" + uname + "';\n";
         req = req + "     :password '" + pass + "'.\n";
         req = req + "}\n";
         req = req + "WHERE {\n";
         req = req + "}\n";
        System.out.println(req);
        engine.insertSPARQL(req);
        return "dummy";
    }
    
    public String search_completionUser(String title) {
        System.out.println("JenaLMS.search_completionUser(). called!");
        title = title.trim();
        if (title.equals("")) {
            return "no\n";
        }
        HashSet<String> al = new HashSet<String>();
        String req = "PREFIX : <http://x314.do-johodai.ac.jp/JenaLMS/>\n";
         req = req + "PREFIX dc: <http://purl.org/dc/elements/1.1/>\n";
         req = req + "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>\n";
         req = req + "PREFIX foaf: <http://xmlns.com/foaf/0.1/> \n";
         req = req + "PREFIX owl: <http://www.w3.org/2002/07/owl#>\n";
         req = req + "SELECT DISTINCT ?userID\n";
         req = req + "WHERE {\n";
         req = req + "  ?x a :edu_material ;\n";
         req = req + "     :completion ?completion ;\n";
         req = req + "     dc:title '" + title + "' .\n";
         req = req + "  ?completion :userID ?userID .\n";
         req = req + "}\n";
        ResultSet rs = engine.execSelect(req);
        while (rs.hasNext()) {
            QuerySolution qs = rs.nextSolution();
            al.add(qs.get("userID").toString());
        }
        String retStr = "";
        for (String s : al) {
            retStr += s + "\n";
        }
        if (retStr.equals(""))
            return "";
        else
            return retStr;
    }
    
    public String get_materialDescription(String title) {
        System.out.println("JenaLMS.get_materialTitle. called!");
        String retStr = "";
        
        String req = "PREFIX : <http://x314.do-johodai.ac.jp/JenaLMS/>\n";
         req = req + "PREFIX l: <http://x314.do-johodai.ac.jp/JenaLMS/learnings/>\n";
         req = req + "PREFIX dc: <http://purl.org/dc/elements/1.1/> \n";
         req = req + "PREFIX owl: <http://www.w3.org/2002/07/owl#>\n";
         req = req + "SELECT DISTINCT ?description \n";
         req = req + "WHERE {\n";
         req = req + "  ?x a :edu_material ;\n";
         req = req + "       dc:title '" + title + "' ;\n";
         req = req + "       dc:description ?description .";
         req = req + "}\n";
       ResultSet rs = engine.execSelect(req);
       ArrayList<String> al = new ArrayList<String>();
       while (rs.hasNext()) {
           QuerySolution qs = rs.nextSolution();
           al.add(qs.get("description").toString());
       }
       for (String s : al) {
           retStr += s + "\n";
       }
       return retStr;
    }
}
