title: Ontology

JenaLMSのOntology
========================================

多少オントロジーを考えておかないといけない状況に
なってきました．ただ，あまり詳しくないので，現状を
乗り切るためだけのオントロジーです．いちおう
ダブリンコアとかFOAFとかOWLも使ってみたいと思います．
ということで参考URL．

* <http://www.kanzaki.com/docs/sw/dublin-core.html>
* <http://www.kanzaki.com/docs/sw/foaf.html>
* <http://www.kanzaki.com/docs/sw/webont-owl.html>

名前空間接頭辞
----------------------------------------

まず，名前空間接頭辞は次を使うことにします．

    @prefix :     <http://x314.do-johodai.ac.jp/JenaLMS/> .
    @prefix l:    <http://x314.do-johodai.ac.jp/JenaLMS/learnings/> .
    @prefix rdf:  <http://www.w3.org/1999/02/22-rdf-syntax-ns#> .
    @prefix rdfs: <http://www.w3.org/2000/01/rdf-schema#> .
    @prefix xsd:  <http://www.w3.org/2001/XMLSchema#> .
    @prefix dc:   <http://purl.org/dc/elements/1.1/> .
    @prefix dct:  <http://purl.org/dc/terms/> .
    @prefix foaf: <http://xmlns.com/foaf/0.1/> .
    @prefix owl:  <http://www.w3.org/2002/07/owl#> .

`<http://x314.do-johodai.ac.jp/JenaLMS/>`が独自の名前空間で，
これをデフォルト名前空間にします．学習項目のオントロジは
名前空間がバッティングしないように「l:」を使って分離することに
しました．dct:はDCの精密化拡張語彙の接頭辞です(普通はdcterms:を
使うのかもしれませんが長いので．)．

人(ユーザ)
----------------------------------------

人(ユーザ)は次のような感じで表現することとします．
匿名ノードを一つ作り，これにメールアドレスのURI
(「mailto:」を付けたもの)をfoaf:mboxでつなげる
ことで，個人を一意に識別できるようにしている
ところがポイントです．Notation3で匿名ノードを
書く時は`[]`のような書き方が一般的ですが，この匿名ノードを
他の所でも使いたいので「_:s0712000」のような書き方
になってます．(実際に入力する時には，n3_insertでは`[]`で
良いです．)

    #一人の人物のデータ
    _:s0712000 a foaf:Person ;
        foaf:mbox <mailto:s0712000@rmme.do-johodai.ac.jp> ;
        foaf:name '情報 太郎' ;
        foaf:gender 'male' ;
        foaf:topic_interest l:数学全般 , l:マンガ ;
        :userID 's0712000' ;
        :password 'password' .

:userIDはJenaLMSでのユーザIDでfoaf:nickのサブプロパティに
しておきます．(foaf:OnlineAccountとかもあるけど，面倒
そうなのでパス)．FOAF的にはメールアドレスが識別子なんだけど，
JenaLMS内では，このユーザIDでも一意に識別できるということに
しておきましょう．まだ使いませんがパスワードも入れれる
ようにしておきます(本当はSHAとかで暗号化すべきでしょうけど)．
「l:数学全般」とか「l:マンガ」とかがありますが，
これは後述します．

* user_add
* user_update
* user_delete

グループ
----------------------------------------

次に，グループの書き方を示します．これはユーザの集合で，
クラスとか学科とか学年などを表すことができるものとします．
将来的には「管理者」とか「教材作成者」とか「TA」とかの
グループを作ってJenaLMSにおけるアクセス制御にも使う
ことになるかもしれません．

    _:システム情報学科  a  foaf:Group ;
        foaf:name 'システム情報学科' ;
        foaf:member _:s0712000 ;
        foaf:member _:s0712001 ;
        foaf:member _:s0712002 ;
        foaf:member _:s0712003 .

「_:システム情報学科」や「_:s0712000」は
匿名ノードです．特に「_:s0712000」は上の
例で出てきたものと同一の匿名ノードを表して
います．実際に入力する場合にはinsertSPARQL
を使って匿名ノードを検索して入れることになる
でしょう．

* group_add
* group_update
* group_delete
* add_user_to_group
* del_user_from_group
* add_users_to_group
* del_users_from_group

教材やコンテンツ
----------------------------------------

教材だけでなく，掲示板やWikiなども同じ方法で
書くことにします(使用する語彙は少し変ります)．
特に、フォーラムの場合はスレッドごとに教材として
登録されるようにしたい。

    _:実際の教材1 a :edu_material ;
        a :textbook ;
        a :made_by_teature ;
        :url 'http://c314.do-johodai.ac.jp/kyouzai1.html' ;
        dc:title 'コンピュータの基礎' ;
        dc:description 'コンピュータの基礎知識を学習する';
        dc:creator '情報太郎' ;
        dct:created '2007-06-20' ;
        dct:modified '2007-06-21T10:30:06+09:00' ;
        dct:requires l:PCの電源 ;
        dct:hasPart l:ファイル ;
        dct:hasPart l:フォルダ ;
        :difficulty :medium ;
        :learningtime '00:10:00' .

このデータの主語は「:edu_material」のインスタンスでないと
いけないこととします．dct:requiresと
dct:hasPartの目的語は後で示す「l:learnings」のインスタンス
でないといけません(DCの意味合いでは，本当は実際の
コンテンツを指定しないといけないのだろうか？)．
キーワードでなく，リソースで学習項目を記述するところが
今回のポイント．独自の語彙は後述します．他にも
必要な項目があるかもしれませんが，とりあえず．

* registSCORM
* updateSCORM
* content_addただし，SCORM教材はregistSCORM
  により追加する
* content_updateただし，SCORM教材はメタデータを
  書き変えてupdateSCORMで再登録することで実現
* content_delete

様々なイベント
----------------------------------------

学習者のログイン，教材の観覧，回答，書き込み，課題提出．
または教師の採点や評価の入力はイベントの一種として
記述することにします．教師の採点などは，成績の修正などの
作業も含まれますが，処理形態としては修正ではなく
新しいイベントの追加として処理することにします．
つまり，古いデータには古いという印を付けて
古い成績も残しておき，最終成績は古いという印が付いて
いないイベントを検索して利用することとします．
これを実現するために，Webサービスのオペレータとしては
update(修正)のインタフェースを用意しておき，内部では
新しいデータを付け加えると共に古いデータに古いという
印を付ける処理をするものとします．

    _:イベント1 a :thread_event ;
        :user _:s0712000 ;
        :content _:スレッド1 ;
        dc:date '2007-06-21T10:30:06+09:00'^^<http://www.w3.org/2001/XMLSchema#dateTime> .

    _:イベント2 a :rating_event ;
        :user _:s0712000 ;
        :content _:テスト1 ;
        :score 80 ;
        dc:date '2007-06-21T10:30:06+09:00'^^<http://www.w3.org/2001/XMLSchema#dateTime> .

他の種類のイベントは、また別の書き方になってくる。
全てのイベントは

* event_add
* event_update
* イベントの種類ごとにメソッドを作るべきかも
* イベントの削除はさせない

SCORMデータ
----------------------------------------

以下のようにしてSCORMのデータを保存しておくことに
します．

    _:SCORMデータ1 a :SCORMDATA ;
        :user _:s0712000 ;
        :content  _:実際の教材1 ;
        :dataName 'some.data' ;
        :data     ( 'data1' 'data2' 'data3')  .

つまり空白ノードを用いて，ユーザ，教材，
データモデルのデータネーム，実際のデータというぐあいに
記述してあります．SCORMのデータモデルには色々な種類がある
ので、この形だけでは上手くいかないものもあります。これは、
lmsGetValueオペレーションのメソッドの中でdataNameの文字列を
判定して、個別に対応してゆくしかないでしょう。(例えばユーザIDが
保存されているとされるデータモデルの場合には、ここで示すデータが
無くても検索できなければなりません。)実際のデータの所はリストとして
記述することにしていて、データモデルがリストを保存する場合を
想定していますが、まだこのへんは良く考える必要がありそうです。

* lmsInitialize
* lmsFinish
* lmsGetValue
* lmsSetValue
* lmsDelValue
* lmsGetAllValue

授業
----------------------------------------

90分とか，45分とかで行われる1回分の授業を記述するための
方法です．一回分の自主学習の内容などもこれで記述する
ことにします．基本的には教材のシーケンスで，教材には
読む教材，実習，確認テスト，課題，(宿題)などのタイプが
あるとします．授業で扱う学習項目もこの中に含めたい気が
しますが，教材から間接的に得られる情報なので入れない
こととします．今のところ学習者の学力に応じて複数の
シナリオがあるような授業には対応していません。

    _:実際の授業1 a :lesson ;
        :id  '100' ;
        :title '授業名など' ;
        :description '授業の説明' ;
        :difficulty :medium ;
        :goal l:学習目標1 ;
        :goal l:学習目標2 ;
        :learningtime '00:60:00' ;
        :introduction 'http://some.domain/some/path/intro.html' ;
        :contents ( [ :em _:実際の教材1 ; :note 'http://a.com/a.html' ]
                    [ :em _:実際の教材2 ; :note 'http://a.com/b.html' ]
                    [ :em _:実際の教材3 ; :note 'http://a.com/c.html' ] ) .

教材には順番があるのでリストを使います。
授業は教材のシーケンスなのですが，独立性の高い教材を
並べただけでは授業の流れを作りにくいので追加の説明記事を
加えることができるようにします．:introductionは，この授業全体の
イントロのためのURLを指定する場所で，通常のHTML文章であると
仮定しています(画像やflashを入れても構わない)．さらに，
一つ一つの教材に対しても，この教材の授業における役割や
ポイントなどを説明する文章が付けられるようにします．
そのため，:contentsの目的語は教材(:em)と説明(:note)を持つ
空白ノードのリストになっています．
説明文のほうはURLで指定し，:introductionと同様にHTML文章を
仮定しています．

授業の再利用や，急な休講などの事情を考えて授業の日時や場所の
データはここには記述しないように変更しました．かわりに講義
データの中に記述することにします．

授業を一意に識別するためのIDを入れることができるように
しました．IDは任意の文字列ですが一意になるように工夫し
なければなりません．現在の実装ではIDを付けずにデータを入力
すると100番からの数字を文字列に変換した物が自動で付け
られるようにルールを追加しています．最初からIDが付いている
時には，それが優先されます．
最初からIDが付いている状況というのはテストデータの場合
などです．実際に使用する時にはどうすべきか悩んでるところです．

* lesson_add
* lesson_update
* lesson_delete

講義
----------------------------------------

複数の授業をまとめて，前期とか後期，1学期とか
2学期などで通して行われる内容を記述するための
方法です．基本的に授業(lesson)のシーケンスになります．
さらに，履修している学生の情報も，ここに記述することに
します．今のところ学習者の学力に応じて複数の
シナリオがあるような講義には対応していません。

    _:実際の講義 a :course ;
        :id  '100' ;
        :title        '人工知能' ;
        :main_teacher _:ksaito ;
        :teacher      _:hajime ;
        :TA           _:s0712000 ;
        :TA           _:s0712001 ;
        :lessons      ( [ :lesson _:実際の授業1 ;
                          dc:date '2007-06-21T10:30:06+09:00'^^<http://www.w3.org/2001/XMLSchema#dateTime> ;
                          dct:spatial _:教室1 ]
                        [ :lesson _:実際の授業2 ;
                          dc:date '2007-06-28T10:30:06+09:00'^^<http://www.w3.org/2001/XMLSchema#dateTime> ;
                          dct:spatial _:教室1 ]
                        ...
                        [ :lesson _:実際の授業15 ;
                          dc:date '2007-xx-xxT10:30:06+09:00'^^<http://www.w3.org/2001/XMLSchema#dateTime> ;
                          dct:spatial _:教室1 ] ) ;
        :student      _:s0512001 ;
        :student      _:s0512002 ;
        ...
        :student      _:s0512100 .

TAがいる講義の場合はその情報も記述します．先生が複数人数関係する場合を
想定して:main_teacherと:teacherを記述可能にしました．:teacherは省略
可能で，:main_teacherは省略不可であるとします．
授業は上のオントロジで示したものと開催日時，教室の三つの情報を持つ
空白ノードであらわし，そのシークエンスで講義を構成するものとします．

授業と同様，講義にも一意に識別するためのIDを入れることができるように
しました．IDは任意の文字列ですが一意になるように工夫し
なければなりません．現在の実装ではIDを付けずにデータを入力
すると100番からの数字を文字列に変換した物が自動で付け
られるようにルールを追加しています．最初からIDが付いている
時には，それが優先されます．
最初からIDが付いている状況というのはテストデータの場合
などです．実際に使用する時にはどうすべきか悩んでるところです．

* course_add
* course_update
* course_delete

(ゆるい)協調学習
----------------------------------------

まだ途中…

場所
----------------------------------------

教室などの授業が行われる場所の記述です．

    _:教室1 a :location ;
        :description '講義塔202教室' .

教室などが無く，各自自宅のPCからアクセスするような
授業の場合は，特別な場合は「:no_room a :location」を
使うことにします．

未整理
----------------------------------------

未整理の項目を書いておきます．

* 興味関心も学習項目の一つと考える
* 学習項目の詳しい説明をrdf:commentで加える．
* 発展的学習項目を記述できるようにする．(とりやめ)
    + xhtml2scormの改良
    + 教材の中と，学習項目オントロジーの両方で記述可能
    + お勧め教材の表示に活用する

-----

* 教材の種類(edu_material)
    + 階層的ではなく以下の分類の組合せ
        + a
            + 教師が用意する教材(made_by_teature)
            + 学習者が作る教材(made_by_learner)
        + b
            + 読む教材(textbook)
            + テスト問題(採点が必要な教材)(examination)
        + c
            + 自動採点教材(auto_rating)
            + 教師が採点する教材(teature_rating)
            + 自己採点教材(self_rating)
        + d
            + フォーラムのスレッド(thread)
            + wiki(wiki)
            + リンク集(web_links)
        + ファイルをアップロードする教材(upload_em)
* イベントの種類(:event，http://purl.org/dc/dcmitype/Eventも考慮すべし)
    + ユーザのログイン(login_event)
    + ユーザのログアウト(logout_event)
    + スレッドへの書き込み(thread_event)
    + wikiへの書き込み(wiki_event)
    + 教材の観覧開始(open_event)
    + 教材の観覧終了(close_event)
    + 教材の採点(rating_event)
* 学習スタイル(learning_style)
    + 教科書型(theory_type)
    + 実習・演習型(practice_type)
* 教授スタイル(teaching_style)
    + 階層的ではなく以下の分類の組合せ
        + 教師あり(supervised_learning)，教師なし(unsupervised_learning)
        + 座学(classroom_lecture)，演習(practice_activity)
        + 個人(personal_learning)，強い協調(グループ)(strong_cl)，弱い協調(weak_cl)
* 最終成績(grade)
    + 優(grade_yu)・良(grade_ryou)・可(grade_ka)・不可(grade_fuka)

-----

「教材」はteaching materialと訳してきたけど，
これからはeducational materialが良いかと思う．
略す時はedu_materialとかemとする．

協調学習は(Cooperative Learning)なので，
略す時はclとする．

教材以外のコンテンツも扱うかもしれないので，
:contentというクラスを作り，:edu_materialは
:contentのサブクラスとする．
