package jp.ac.do_johodai.j314.sw.lms;

import java.util.HashMap;
import java.util.Map;

import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.receivers.AbstractMessageReceiver;
import org.apache.axis2.rpc.receivers.RPCInOnlyMessageReceiver;
import org.apache.axis2.rpc.receivers.RPCMessageReceiver;
import org.apache.axis2.transport.http.SimpleHTTPServer;
import org.apache.axis2.engine.AxisConfiguration;

import jp.ac.do_johodai.j314.sw.je.*;

public class JenaLMSServer {
    JenaEngine engine;
    SimpleHTTPServer server;

    public JenaLMSServer(JenaEngine je) {
        try {
            engine = je;
            Map<String,AbstractMessageReceiver> m
                = new HashMap<String,AbstractMessageReceiver>();
            //m.put("http://www.w3.org/2004/08/wsdl/in-only",
            //    RPCInOnlyMessageReceiver.class.newInstance());
            //m.put("http://www.w3.org/2004/08/wsdl/in-out",
            //    RPCMessageReceiver.class.newInstance());
            m.put("http://www.w3.org/ns/wsdl/in-only",
                RPCInOnlyMessageReceiver.class.newInstance());
            m.put("http://www.w3.org/ns/wsdl/in-out",
                RPCMessageReceiver.class.newInstance());
            ConfigurationContext cc = ConfigurationContextFactory
                    .createConfigurationContextFromFileSystem(null, null);
            AxisConfiguration ac = cc.getAxisConfiguration();
            AxisService as = AxisService.createService(
                    "jp.ac.do_johodai.j314.sw.lms.JenaLMS", ac,
                     m, "", "http://x314.do-johodai.ac.jp/sw_ws/xsd");
            ac.addService(as);
            ac.startService("JenaLMS");

            server = new SimpleHTTPServer(cc,8080);
            server.start();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String args[]) {
        JenaEngine je = new JenaEngine();
        je.registerBuiltin(new BindBuiltin());
        new JenaLMSServer(je);
    }
}
