/*
 * lms javascript
 * LMSが提供するAPIを実現するJavaScript
 * このスクリプトを利用するダミーLMSのHTMLでは
 * ユーザIDを「window.document.form1.userID.value」で
 * 教材のURLを「window.document.form1.lmURL.value」で
 * 取ってこれるようにしておかないといけない．
 * ただし，この動作はすぐ下のgetUserIDとgetTmURLの関数を
 * 書換えれば変更できる．
 * 通信部分はXMLHttpRequestを使う．
 *
 * http://www.w3.org/TR/REC-DOM-Level-1/level-one-core.html
 * DOM Level1でXMLのネームスペースはどうなってる？
 */

//ユーザIDをゲットするための関数
function getUserID() {
    return window.document.form1.userID.value;
}

//教材のURLをゲットするための関数
function getTmURL() {
    return window.document.form1.lmURL.value;
    //return location.pathname;
}

buffer = new Array();

function MyInitialize(NullString) {
    var inparam = new Array();
    inparam.push(getUserID());
    inparam.push(getTmURL());
    sendData('lmsInitialize',inparam);
    return true;
}
function MyTerminate(NullString) {
    MyCommit("");
    var inparam = new Array();
    inparam.push(getUserID());
    inparam.push(getTmURL());
    sendData('lmsFinish',inparam);
    return;
}
function MyGetValue(DataName) {
    var inparam = new Array();
    inparam.push(getUserID());
    inparam.push(getTmURL());
    inparam.push(DataName);
    var res = sendData('lmsGetValue',inparam);
    return res[0];
}
function MySetValue(DataName, Data) {
    buffer[DataName] = Data;
    return true;
}
function MyCommit(NullString) {
    var inparam = new Array();
    inparam.push(getUserID());
    inparam.push(getTmURL());
    for (i in buffer) {
        inparam.push(i);
        inparam.push(buffer[i]);
    }
    sendData('lmsSetValue',inparam);
    buffer = new Array();
    return true;
}
function MyGetLastError() {
    //alert("LMSGetLastError was called!");
    return 0;
}
function MyGetErrorString(ErrorCode) {
    alert("LMSGetErrorString was called!");
    return "dummy error.";
}
function MyGetDiagnostic(ErrorCode) {
    alert("LMSGetDiagnostic was called!");
    return "dummy error";
}
function MyGetAllValue() {
    var inparam = new Array();
    inparam.push(getUserID());
    inparam.push(getTmURL());
    var res = sendData('lmsGetAllValue',inparam);
    return res;
}
function MyDelValue(DataName) {
    var inparam = new Array();
    inparam.push(getUserID());
    inparam.push(getTmURL());
    inparam.push(DataName);
    sendData('lmsDelValue',inparam);
    return;
}

function MyAPI2004() {
    this.Initialize = MyInitialize;
    this.Terminate = MyTerminate;
    this.GetValue = MyGetValue;
    this.SetValue = MySetValue;
    this.Commit = MyCommit;
    this.GetLastError = MyGetLastError;
    this.GetErrorString = MyGetLastError;
    this.GetDiagnostic = MyGetDiagnostic;
    this.GetAllValue = MyGetAllValue;
    this.DelValue = MyDelValue;
}

function MyAPI12() {
    this.LMSInitialize = MyInitialize;
    this.LMSFinish = MyTerminate;
    this.LMSGetValue = MyGetValue;
    this.LMSSetValue = MySetValue;
    this.LMSCommit = MyCommit;
    this.LMSGetLastError = MyGetLastError;
    this.LMSGetErrorString = MyGetLastError;
    this.LMSGetDiagnostic = MyGetDiagnostic;
    this.LMSGetAllValue = MyGetAllValue;
    this.LMSDelValue = MyDelValue;
}

function MyLMS() {
    window.API_1484_11 = new MyAPI2004();
    window.API = new MyAPI12();
}

/* 以下XMLHttpRequest関連 */

function createHttpRequest() {
    //Win ie用
    if (window.ActiveXObject) {
        try {
            return new ActiveXObject("Msxml2.XMLHTTP");
        } catch (e) {
            try {
                //旧MSXML用
                return new ActiveXObject("Microsoft.XMLHTTP");
            } catch (e2) {
                return null;
            }
        }
    } else if (window.XMLHttpRequest) {
        //Win ie以外のXMLHttpRequestオブジェクト実装ブラウザ用
        return new XMLHttpRequest();
    } else {
        return null;
    }
}

function createEmptyDOM() {
    //Win ie用
    if (window.ActiveXObject) {
        return new ActiveXObject("Microsoft.XMLDOM");
    } else if (document.implementation) {
        return document.implementation.createDocument("", "", null);
    } else {
        return null;
    }
}

//データの送信．入力は文字列の配列，
//出力は文字列の配列，または文字列の配列の配列と仮定している．
//Safariの文字化けはあきらめた．
function sendData(operation,args) {
    var request = createHttpRequest();
    request.open("POST","/axis2/services/JenaLMS",false);
    request.setRequestHeader("Content-Type", "text/xml");

    var dom = createEmptyDOM();
    //var operation = dom.createElement("ns:"+operation);
    var operation = dom.createElement(operation);
    //operation.setAttribute("xmlns:ns","http://lms.sw.j314.do_johodai.ac.jp/xsd");
    //operation.setAttributeNS("xmlns","ns","http://lms.sw.j314.do_johodai.ac.jp/xsd");
    operation.setAttribute("xmlns","http://lms.sw.j314.do_johodai.ac.jp/xsd");
    for (i=0;i<args.length;i++) {
        var inparam = dom.createElement("Text");
        var t = dom.createTextNode(args[i]);
        inparam.appendChild(t);
        operation.appendChild(inparam);
    }
    dom.appendChild(operation);

    request.send(dom);
//alert(request.responseText);

    //次の行，取り出し方が甘いかも
    var replyElementName = request.responseXML.firstChild.firstChild.nodeName;
    if (replyElementName.indexOf("return")>=0) {
        //alert("lms.js function sendData(). return!!!");
        var ret = new Array();
        //次の行，取り出し方が甘いかも
        var result = request.responseXML.firstChild.childNodes;
        for (i=0;i<result.length;i++) {
            if (result[i].nodeName.indexOf("return")>=0) {
                ret.push(result[i].firstChild.data);
            }
        }
        return ret;
    } else if (replyElementName.indexOf("item")>=0) {
        //alert("lms.js function sendData(). item!!!");
        var ret = new Array();
        var retTmp;
        var n = -1;
        //次の行，取り出し方が甘いかも
        var result = request.responseXML.firstChild.childNodes;
        for (i=0;i<result.length;i++) {
            if (result[i].nodeName.indexOf("item")>=0) {
                var nTmp = parseInt(result[i].nodeName.substring(4));
                if (nTmp>n) {
                    retTmp = new Array();
                    n = nTmp;
                    ret.push(retTmp);
                }
                retTmp.push(result[i].firstChild.data);
            }
        }
        return ret;
    } else {
        alert("lms.js function sendData(). GAHA");
        alert(replyElementName);
        return null;
    }
}
