/*
 * Decompiled with CFR 0.152.
 */
package jp.ac.do_johodai.j314.sw.je;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.reasoner.rulesys.BindingEnvironment;
import com.hp.hpl.jena.reasoner.rulesys.RuleContext;
import com.hp.hpl.jena.reasoner.rulesys.builtins.BaseBuiltin;
import com.hp.hpl.jena.util.iterator.ClosableIterator;
import java.util.ArrayList;

public class List2StringBuiltin
extends BaseBuiltin {
    public String getName() {
        return "list2string";
    }

    public int getArgLength() {
        return 2;
    }

    public boolean bodyCall(Node[] args, int length, RuleContext context) {
        if (length != 2) {
            return false;
        }
        this.list2string(args, length, context);
        return true;
    }

    public void headAction(Node[] args, int length, RuleContext context) {
        this.list2string(args, length, context);
    }

    void list2string(Node[] args, int length, RuleContext context) {
        String ret = this.list2stringR(args[0], context);
        BindingEnvironment env = context.getEnv();
        env.bind(args[1], Node.createLiteral((String)ret));
    }

    String list2stringR(Node n, RuleContext context) {
        String ret = "";
        Node first = Node.create((String)"http://www.w3.org/1999/02/22-rdf-syntax-ns#first");
        Node rest = Node.create((String)"http://www.w3.org/1999/02/22-rdf-syntax-ns#rest");
        Node nil = Node.create((String)"http://www.w3.org/1999/02/22-rdf-syntax-ns#nil");
        ArrayList<Node> al = new ArrayList<Node>();
        Node tmpN = n;
        while (!tmpN.equals((Object)nil)) {
            ClosableIterator ci = context.find(tmpN, first, null);
            Node e = ((Triple)ci.next()).getObject();
            al.add(e);
            ci = context.find(tmpN, rest, null);
            tmpN = ((Triple)ci.next()).getObject();
        }
        ret = ret + "(";
        Node[] nn = al.toArray(new Node[0]);
        for (int i = 0; i < nn.length; ++i) {
            ClosableIterator ci;
            if (nn[i].isBlank() && (ci = context.find(nn[i], first, null)).hasNext() && (ci = context.find(nn[i], rest, null)).hasNext()) {
                ret = ret + this.list2stringR(nn[i], context);
                continue;
            }
            String sTmp = nn[i].toString();
            if (sTmp.startsWith("\"") && sTmp.endsWith("\"")) {
                sTmp = sTmp.substring(1, sTmp.length() - 1);
            }
            ret = ret + sTmp + " ";
        }
        ret = ret + ") ";
        return ret;
    }
}

