package jp.ac.do_johodai.j314.sw.ws;

//import org.apache.axis2.transport.http.server.SimpleHttpServer;
import org.apache.axis2.transport.http.SimpleHTTPServer;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
//import org.apache.axis2.transport.http.HTTPWorker;
import java.util.*;

import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;

import org.apache.axis2.receivers.AbstractMessageReceiver;
import org.apache.axis2.rpc.receivers.RPCInOnlyMessageReceiver;
import org.apache.axis2.rpc.receivers.RPCMessageReceiver;

import jp.ac.do_johodai.j314.sw.je.*;

public class ServerWrapper {
    // SimpleHttpServer server;
    SimpleHTTPServer server;
    AxisConfiguration ac;
    int port = 8080;

    public ServerWrapper(JenaEngine je) {
        JEService.engine = je;
        //おれおれ証明書のような証明書でも通信できるようにする。
        try {
            SSLContext ssl = SSLContext.getInstance("SSL");
            TrustManager[] tm = { new LazyTrustManager() };
            ssl.init(null, tm, null);
            HttpsURLConnection.setDefaultSSLSocketFactory(
                ssl.getSocketFactory()
            );
            HttpsURLConnection.setDefaultHostnameVerifier(
                new LazyHostnameVerifier()
            );
        } catch(Exception e) {
            e.printStackTrace();
        }
    }
    public void start() {
        try {
            if (server!=null)
                return;
            Map<String,AbstractMessageReceiver> m
                = new HashMap<String,AbstractMessageReceiver>();
            //m.put("http://www.w3.org/2004/08/wsdl/in-only",
            //    RPCInOnlyMessageReceiver.class.newInstance());
            //m.put("http://www.w3.org/2004/08/wsdl/in-out",
            //    RPCMessageReceiver.class.newInstance());
            m.put("http://www.w3.org/ns/wsdl/in-only",
                RPCInOnlyMessageReceiver.class.newInstance());
            m.put("http://www.w3.org/ns/wsdl/in-out",
                RPCMessageReceiver.class.newInstance());
            ConfigurationContext cc = ConfigurationContextFactory.createConfigurationContextFromFileSystem(null, null);
            ac = cc.getAxisConfiguration();
            AxisService as = AxisService.createService("jp.ac.do_johodai.j314.sw.ws.JEService", ac,
            		m,"","http://x314.do-johodai.ac.jp/sw_ws/xsd",ServerWrapper.class.getClassLoader());
            ac.addService(as);

            ac.startService("JEService");

            // server = new SimpleHttpServer(port,null);
            // server.setRequestHandler(new HTTPWorker(cc));
            server = new SimpleHTTPServer(cc, port);
            server.start();
        } catch (Exception e) {
            e.printStackTrace();
        }
        
    }
    public void stop() {
        try {
            if (server==null)
                return;
            ac.stopService("JEService");
            ac = null;
            server.stop();
            server = null;
        } catch (Exception e) {
            e.printStackTrace();
        }
        
    }
    public void setPort(int p) {
        port = p;
        if (server!=null) {
            stop();
            start();
        }
    }
}
