package jp.ac.do_johodai.j314.sw.je;

import com.hp.hpl.jena.graph.*;
import com.hp.hpl.jena.reasoner.rulesys.builtins.BaseBuiltin;
import com.hp.hpl.jena.reasoner.rulesys.RuleContext;
import com.hp.hpl.jena.reasoner.rulesys.BindingEnvironment;

/**
 * java.lang.String.formatを使って文字列をフォーマットします。
 * フォーマットの書式文字列で使えるのは%sだけになるかも。
 * 第1引数がフォーマット文字列、第2引数が変数、
 * 第3引数以降がフォーマット文字列に渡す文字列。
 * ビルトインの名前は'stringFormat'。
 */
public class StringFormatBuiltin extends BaseBuiltin {
    public String getName() {
        return "stringFormat";
    }

    public int getArgLength() {
        return 0;
    }

    public boolean bodyCall(Node[] args, int length, RuleContext context) {
        return stringFormat(args,length,context);
    }

    public void headAction(Node[] args, int length, RuleContext context) {
        stringFormat(args,length,context);
    }
    boolean stringFormat(Node[] args, int length, RuleContext context) {
    	String f = ((Node_Literal)args[0]).getLiteralLexicalForm();
    	Object ss[] = new String[length-2];
    	for (int i=2;i<length;i++) {
    		ss[i-2] = ((Node_Literal)args[i]).getLiteralLexicalForm();
    	}
    	String s = String.format(f,ss);
        Node n = Node.createLiteral(s);
        BindingEnvironment env = context.getEnv();
        env.bind(args[1],n);
        return true;
    }
}
