package jp.ac.do_johodai.j314.sw.je;

import com.hp.hpl.jena.graph.*;
import com.hp.hpl.jena.reasoner.rulesys.builtins.BaseBuiltin;
import com.hp.hpl.jena.reasoner.rulesys.RuleContext;
import com.hp.hpl.jena.reasoner.rulesys.BindingEnvironment;

/**
 * 第2引数から第n引数の文字列を結合して第1引数の変数に代入する。
 * ビルトインの名前は'stringConcat'。
 */
public class StringConcatBuiltin extends BaseBuiltin {
    public String getName() {
        return "stringConcat";
    }

    public int getArgLength() {
        return 0;
    }

    public boolean bodyCall(Node[] args, int length, RuleContext context) {
        return stringConcat(args,length,context);
    }

    public void headAction(Node[] args, int length, RuleContext context) {
        stringConcat(args,length,context);
    }
    boolean stringConcat(Node[] args, int length, RuleContext context) {
    	String s = "";
    	for (int i=1;i<length;i++) {
    		s = s + ((Node_Literal)args[i]).getLiteralLexicalForm();
    	}
        Node n = Node.createLiteral(s);
        BindingEnvironment env = context.getEnv();
        env.bind(args[0],n);
        return true;
    }
}
