package jp.ac.do_johodai.j314.sw.je;

import com.hp.hpl.jena.graph.*;
import com.hp.hpl.jena.reasoner.rulesys.builtins.BaseBuiltin;
import com.hp.hpl.jena.reasoner.rulesys.RuleContext;

/**
 * 状態を表すための変数記憶領域の内容全てを表示する。
 * 引数はなし。
 * ビルトインの名前は'state_print'。
 */
public class StatePrintBuiltin extends BaseBuiltin {

    public String getName() {
        return "state_print";
    }

    public int getArgLength() {
        return 0;
    }

    public boolean bodyCall(Node[] args, int length, RuleContext context) {
        state_print();
        return true;
    }

    public void headAction(Node[] args, int length, RuleContext context) {
        state_print();
    }
    void state_print() {
    	for (Node key : StateSetBuiltin.map.keySet()) {
    		System.out.print(key.toString()+" --> ");
    		System.out.println(StateSetBuiltin.map.get(key).toString());
    	}
    }
}
