package jp.ac.do_johodai.j314.sw.je;

import com.hp.hpl.jena.graph.*;
import com.hp.hpl.jena.reasoner.rulesys.builtins.BaseBuiltin;
import com.hp.hpl.jena.reasoner.rulesys.RuleContext;
import com.hp.hpl.jena.reasoner.rulesys.BindingEnvironment;
import java.text.SimpleDateFormat;
import java.util.Date;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;

/**
 * 第1引数(long)をDateTimeに変換して第2引数(dateTime)の変数に
 * 代入する。
 * ビルトインの名前は'long2datetime'。
 */
public class Long2DateTimeBuiltin extends BaseBuiltin {
    public String getName() {
        return "long2datetime";
    }

    public int getArgLength() {
        return 2;
    }

    public boolean bodyCall(Node[] args, int length, RuleContext context) {
        if (length != 2)
            return false;
        long2datetime(args,length,context);
        return true;
    }

    public void headAction(Node[] args, int length, RuleContext context) {
        long2datetime(args,length,context);
    }
    void long2datetime(Node[] args, int length, RuleContext context) {
        String s = ((Node_Literal)args[0]).getLiteralLexicalForm();
        long l = Long.parseLong(s);
        Date date = new Date(l);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        String d = sdf.format(date);
        Node n = Node.createLiteral(d,null,XSDDatatype.XSDdateTime);
        BindingEnvironment env = context.getEnv();
        env.bind(args[1],n);
    }
}
