package jp.ac.do_johodai.j314.sw.je;

import com.hp.hpl.jena.graph.*;
import com.hp.hpl.jena.reasoner.rulesys.builtins.BaseBuiltin;
import com.hp.hpl.jena.reasoner.rulesys.RuleContext;
import com.hp.hpl.jena.reasoner.rulesys.BindingEnvironment;

/**
 * RDFのリストを生成するためのビルトイン。
 * ビルトインの名前は'list'。第1引数を変数にしておき、
 * 第2引数以降にリストの要素を並べると、作成されたリストが
 * 第1引数の変数に代入される。
 */
public class ListBuiltin extends BaseBuiltin {

    public String getName() {
        return "list";
    }

    public int getArgLength() {
        return 0;
    }

    public boolean bodyCall(Node[] args, int length, RuleContext context) {
        if (length == 0)
            return false;
        makeListAndBind(args,length,context);
        return true;
    }

    public void headAction(Node[] args, int length, RuleContext context) {
        makeListAndBind(args,length,context);
    }

    void makeListAndBind(Node[] args,int length,RuleContext context) {
        Node first = Node.create("http://www.w3.org/1999/02/22-rdf-syntax-ns#first");
        Node rest = Node.create("http://www.w3.org/1999/02/22-rdf-syntax-ns#rest");
        Node list = Node.create("http://www.w3.org/1999/02/22-rdf-syntax-ns#nil");
        for (int i=(length-1);i>0;i--) {
            Node tail = list;
            list = Node.createAnon();
            context.add(new Triple(list,first,args[i]));
            context.add(new Triple(list,rest,tail));
        }
        BindingEnvironment env = context.getEnv();
        env.bind(args[0],list);
    }
}
