package jp.ac.do_johodai.j314.sw.je;

import java.util.ArrayList;

import net.java.sen.*;
import com.hp.hpl.jena.graph.*;
import com.hp.hpl.jena.reasoner.rulesys.builtins.BaseBuiltin;
import com.hp.hpl.jena.reasoner.rulesys.RuleContext;
import com.hp.hpl.jena.reasoner.rulesys.BindingEnvironment;
import com.hp.hpl.jena.graph.Node;

/**
 * 形態素解析をするためのビルトインで、keitaisoビルトインの詳細版。
 * ビルトインの名前は'keitaisokaiseki'。第1引数に文字列を与えると
 * 第2引数の変数に形態素解析の結果のデータがリストのリスト形式で計算
 * されバインドされる。このビルトインを使用する前にkeitaiso_init
 * ビルトインを呼び出して初期化しておかなければならない。
 * 
 * 例:
 * 本日は晴天なり。→
 * (("本日", "本日", "名詞-副詞可能", "*", "ホンジツ", "ホンジツ")
 *  ("は", "は", "助詞-係助詞", "*", "ハ", "ワ")
 *  ("晴天", "晴天", "名詞-一般", "*", "セイテン", "セイテン")
 *  ("なり", "なり", "助動詞", "基本形", "ナリ", "ナリ")
 *  ("．", "．", "記号-句点", "*", "．", "．"))
 *  
 * 横の並びですが、表層表現、基本形、品詞情報、活用形、読み、発音です。
 */
public class KeitaisokaisekiBuiltin extends BaseBuiltin {
    public String getName() {
        return "keitaisokaiseki";
    }

    public int getArgLength() {
        return 2;
    }

    public boolean bodyCall(Node[] args, int length, RuleContext context) {
        if (length != 2)
            return false;
        doKeitaisokaiseki(args,length,context);
        return true;
    }

    public void headAction(Node[] args, int length, RuleContext context) {
        doKeitaisokaiseki(args,length,context);
    }

    void doKeitaisokaiseki(Node[] args,int length,RuleContext context) {
        try {
            String inStr = ((Node_Literal) args[0]).getLiteralLexicalForm();
            StringTagger tagger = StringTagger.getInstance();
            Token[] token = tagger.analyze(inStr);

            ArrayList<Node> al = new ArrayList<Node>();
            for (int i=0;i<token.length;i++) {
                Node n = doKeitaisokaiseki2(token[i],context);
                al.add(n);
            }
            Node[] nodes = al.toArray(new Node[0]);
            Node list = makeList(nodes,context);

            BindingEnvironment env = context.getEnv();
            env.bind(args[1],list);
        } catch(Exception e) {
            e.printStackTrace();
        }
    }
    Node doKeitaisokaiseki2(Token t,RuleContext context) {
        Node[] nodes = new Node[6];
        nodes[0] = Node.createLiteral(t.getSurface());
        nodes[1] = Node.createLiteral(t.getBasicString());
        nodes[2] = Node.createLiteral(t.getPos());
        nodes[3] = Node.createLiteral(t.getCform());
        nodes[4] = Node.createLiteral(t.getReading());
        nodes[5] = Node.createLiteral(t.getPronunciation());
        return makeList(nodes,context);
    }
    Node makeList(Node nodes[],RuleContext context) {
        Node first = Node.create("http://www.w3.org/1999/02/22-rdf-syntax-ns#first");
        Node rest = Node.create("http://www.w3.org/1999/02/22-rdf-syntax-ns#rest");
        Node list = Node.create("http://www.w3.org/1999/02/22-rdf-syntax-ns#nil");
        for (int i=(nodes.length-1);i>=0;i--) {
            Node tail = list;
            list = Node.createAnon();
            context.add(new Triple(list,first,nodes[i]));
            context.add(new Triple(list,rest,tail));
        }
        return list;
    }
}
