package jp.ac.do_johodai.j314.sw.je;

import net.java.sen.*;
import com.hp.hpl.jena.graph.*;
import com.hp.hpl.jena.reasoner.rulesys.builtins.BaseBuiltin;
import com.hp.hpl.jena.reasoner.rulesys.RuleContext;
import com.hp.hpl.jena.reasoner.rulesys.BindingEnvironment;
import com.hp.hpl.jena.graph.Node;

/**
 * 形態素解析をするためのビルトイン。
 * ビルトインの名前は'keitaiso'。第1引数に文字列を与えると
 * 第2引数の変数に形態素に分解された文字列のリストがバインド
 * される。このビルトインを使用する前にkeitaiso_init
 * ビルトインを呼び出して初期化しておかなければならない。
 */
public class KeitaisoBuiltin extends BaseBuiltin {
    public String getName() {
        return "keitaiso";
    }

    public int getArgLength() {
        return 2;
    }

    public boolean bodyCall(Node[] args, int length, RuleContext context) {
        if (length != 2)
            return false;
        doKeitaiso(args,length,context);
        return true;
    }

    public void headAction(Node[] args, int length, RuleContext context) {
        doKeitaiso(args,length,context);
    }

    void doKeitaiso(Node[] args,int length,RuleContext context) {
        try {
            String inStr = ((Node_Literal) args[0]).getLiteralLexicalForm();
            StringTagger tagger = StringTagger.getInstance();
            Token[] token = tagger.analyze(inStr);

            Node first = Node.create("http://www.w3.org/1999/02/22-rdf-syntax-ns#first");
            Node rest = Node.create("http://www.w3.org/1999/02/22-rdf-syntax-ns#rest");
            Node list = Node.create("http://www.w3.org/1999/02/22-rdf-syntax-ns#nil");
            for (int i=(token.length-1);i>=0;i--) {
                Node t = Node.createLiteral(token[i].getBasicString());
                Node tail = list;
                list = Node.createAnon();
                context.add(new Triple(list,first,t));
                context.add(new Triple(list,rest,tail));
            }
            BindingEnvironment env = context.getEnv();
            env.bind(args[1],list);
        } catch(Exception e) {
            e.printStackTrace();
        }
    }
}
