package jp.ac.do_johodai.j314.sw.je;

import com.hp.hpl.jena.graph.*;
import com.hp.hpl.jena.reasoner.rulesys.builtins.BaseBuiltin;
import com.hp.hpl.jena.reasoner.rulesys.RuleContext;
import com.hp.hpl.jena.reasoner.rulesys.BindingEnvironment;

/**
 * RDFのリストを生成するためのビルトイン。
 * ビルトインの名前は'cons'。第2引数に与えられたリストの
 * 先頭に第1引数の値を追加し、そのリストを第三引数の変数に
 * 代入する。
 */
public class ConsBuiltin extends BaseBuiltin {
    public String getName() {
        return "cons";
    }

    public int getArgLength() {
        return 3;
    }

    public boolean bodyCall(Node[] args, int length, RuleContext context) {
        if (length != 3)
            return false;
        makeListAndBind(args,length,context);
        return true;
    }

    public void headAction(Node[] args, int length, RuleContext context) {
        makeListAndBind(args,length,context);
    }

    void makeListAndBind(Node[] args,int length,RuleContext context) {
        Node first = Node.create("http://www.w3.org/1999/02/22-rdf-syntax-ns#first");
        Node rest = Node.create("http://www.w3.org/1999/02/22-rdf-syntax-ns#rest");
        Node bNode = Node.createAnon();
        context.add(new Triple(bNode,first,args[0]));
        context.add(new Triple(bNode,rest,args[1]));
        BindingEnvironment env = context.getEnv();
        env.bind(args[2],bNode);
    }
}
