package jp.ac.do_johodai.j314.sw.je;

import com.hp.hpl.jena.graph.*;
import com.hp.hpl.jena.reasoner.rulesys.builtins.BaseBuiltin;
import com.hp.hpl.jena.reasoner.rulesys.RuleContext;
import com.hp.hpl.jena.reasoner.rulesys.BindingEnvironment;

/**
 * 第1引数の変数に、第2引数の内容をバインド(代入)する。
 * ビルトインの名前は'bind'。
 */
public class BindBuiltin extends BaseBuiltin {
    public String getName() {
        return "bind";
    }

    public int getArgLength() {
        return 2;
    }

    public boolean bodyCall(Node[] args, int length, RuleContext context) {
        if (length != 2)
            return false;
        BindingEnvironment env = context.getEnv();
        env.bind(args[0], args[1]);
        return true;
    }

    public void headAction(Node[] args, int length, RuleContext context) {
        BindingEnvironment env = context.getEnv();
        env.bind(args[0], args[1]);
    }
}
