package jp.ac.do_johodai.j314.sw.je;

import com.hp.hpl.jena.graph.*;
import com.hp.hpl.jena.reasoner.rulesys.builtins.BaseBuiltin;
import com.hp.hpl.jena.reasoner.rulesys.BindingEnvironment;
import com.hp.hpl.jena.reasoner.rulesys.RuleContext;

/**
 * Acerola3Dのウィンドウに下のほうにYes,Noボタンを付けて
 * いて、そのボタンから情報をゲットするためのビルトイン。
 * ビルトインの名前は'a3yesno'。
 * 第1引数がAcerola3Dを特定するためのリソース。
 * 第2引数を変数にしておくと、その変数に'yes'か'no'が
 * 代入される。
 */
public class A3YesNoBuiltin extends BaseBuiltin {
    public String getName() {
        return "a3yesno";
    }

    public int getArgLength() {
        return 2;
    }

    public boolean bodyCall(Node[] args, int length, RuleContext context) {
        if (length != 2)
            return false;
        if (!A3NewBuiltin.hash.containsKey(args[0]))
            return false;
        return yesNo(args, context);
    }

    public void headAction(Node[] args, int length, RuleContext context) {
        yesNo(args, context);
    }

    boolean yesNo(Node args[], RuleContext context) {
        A3NewBuiltin.MyFrame f = A3NewBuiltin.hash.get(args[0]);
        String v = f.yesNo();
        Node n = Node.createLiteral(v);
        BindingEnvironment env = context.getEnv();
        env.bind(args[1], n);
        return true;
    }
}
