package jp.ac.do_johodai.j314.sw.je;

import com.hp.hpl.jena.graph.*;
import com.hp.hpl.jena.reasoner.rulesys.builtins.BaseBuiltin;
import com.hp.hpl.jena.reasoner.rulesys.BindingEnvironment;
import com.hp.hpl.jena.reasoner.rulesys.RuleContext;

/**
 * Acerola3Dのウィンドウの下にテキストフィールドを
 * 付けてあり、そこから文字列を読み込むためのビルトイン。
 * ビルトインの名前は'a3read'。
 * 第一引数がAcerola3Dを特定するためのリソースで、
 * 第2引数に変数を指定しすると、その変数に文字が
 * 代入される。
 */
public class A3ReadBuiltin extends BaseBuiltin {
    public String getName() {
        return "a3read";
    }

    public int getArgLength() {
        return 2;
    }

    public boolean bodyCall(Node[] args, int length, RuleContext context) {
        if (length != 2)
            return false;
        if (!A3NewBuiltin.hash.containsKey(args[0]))
            return false;
        return read(args, context);
    }

    public void headAction(Node[] args, int length, RuleContext context) {
        read(args, context);
    }

    boolean read(Node args[], RuleContext context) {
        A3NewBuiltin.MyFrame f = A3NewBuiltin.hash.get(args[0]);
        String v = f.read();
        Node n = Node.createLiteral(v);
        BindingEnvironment env = context.getEnv();
        env.bind(args[1], n);
        return true;
    }
}
