package jp.ac.do_johodai.j314.sw.je;

import com.hp.hpl.jena.graph.*;
import com.hp.hpl.jena.reasoner.rulesys.builtins.BaseBuiltin;
import com.hp.hpl.jena.reasoner.rulesys.RuleContext;
import java.util.*;
import javax.swing.*;
import jp.ac.do_johodai.j314.sw.jc.JTextFieldInputStream;
import java.awt.event.*;
import java.io.*;

import jp.sourceforge.acerola3d.A23;
import jp.sourceforge.acerola3d.a3.*;

/**
 * Acerola3DのためのWindowを用意します。 ただ表示はしません。
 * 実際に表示させるには a3setVisibleビルトインを使います。
 * このビルトインの名前は'a3new'。 第1引数はAcerola3Dの
 * キャラクタを特定する ためのIDとなるリソースを入れる、
 * ここで指定するリソースには今のところ特に制限はない。 
 * 第2引数はAcrola3Dのデータが保存されている ファイルのURLを指定する。
 */
public class A3NewBuiltin extends BaseBuiltin {
    static HashMap<Node, MyFrame> hash = new HashMap<Node, MyFrame>();
    JenaEngine engine = null;

    public A3NewBuiltin() {
        super();
        A23.initA23();
    }
    public void setJenaEngine(JenaEngine e) {
    	engine = e;
    }

    public String getName() {
        return "a3new";
    }

    public int getArgLength() {
        return 2;
    }

    public boolean bodyCall(Node[] args, int length, RuleContext context) {
        if (length != 2)
            return false;
        return a3New(args);
    }

    public void headAction(Node[] args, int length, RuleContext context) {
        a3New(args);
    }

    boolean a3New(Node[] args) {
        if (hash.containsKey(args[0]))
            return false;
        String url = ((Node_Literal) args[1]).getLiteralLexicalForm();
        url.trim();
        MyFrame f = new MyFrame(url,engine);
        hash.put(args[0], f);
        return true;
    }

    class MyFrame extends JFrame implements ActionListener, JEListener {
        private static final long serialVersionUID = 1L;
        A3Canvas canvas;
        Action3D a3;
        JButton yesButton;
        JButton noButton;
        JTextField textField;
        JTextField textField2;
        BufferedReader br;
        JenaEngine engine;

        MyFrame(String url,JenaEngine e) {
        	engine = e;
            Box b = Box.createVerticalBox();
            this.getContentPane().add(b);
            canvas = A3Canvas.createA3Canvas(500, 500);
            b.add(canvas);
            Box b2 = Box.createHorizontalBox();
            b.add(b2);
            yesButton = new JButton("YES");
            yesButton.addActionListener(this);
            noButton = new JButton("NO");
            noButton.addActionListener(this);
            b2.add(yesButton);
            b2.add(noButton);
            Box b3 = Box.createHorizontalBox();
            b3.add(new JLabel("Ａ３入力"));
            textField = new JTextField();
            b3.add(textField);
            b.add(b3);
            JTextFieldInputStream jtfis = new JTextFieldInputStream(textField);
            InputStreamReader isr = new InputStreamReader(jtfis);
            br = new BufferedReader(isr);
            Box b4 = Box.createHorizontalBox();
            b4.add(new JLabel("三組入力"));
            textField2 = new JTextField();
            b4.add(textField2);
            b.add(b4);
            textField2.addActionListener(this);
            this.pack();
            a3 = null;
            try {
                a3 = Action3D.load(url);
            } catch (Exception ee) {
                ee.printStackTrace();
            }
            a3.change(0);// gaha 対処
            a3.setLoc(-0.2, -0.5, 0.0);
            canvas.add(a3);
        }

        void change(int i) {
            a3.change(i);
        }

        void setBalloon(String s) {
            a3.setBalloon(s);
        }

        String read() {
            try {
                return br.readLine();
            } catch (Exception e) {
                e.printStackTrace();
                return "";
            }
        }

        public void actionPerformed(ActionEvent ae) {
            if (ae.getSource() == yesButton) {
                yesNoString = "yes";
                synchronized (this) {
                    notifyAll();
                }
            } else if (ae.getSource() == noButton) {
                yesNoString = "no";
                synchronized (this) {
                    notifyAll();
                }
            } else if (ae.getSource() == textField2) {
            	sendInput();
            }
        }
        void sendInput() {
        	String s = textField2.getText();
        	textField2.setText("");
            System.out.println(s);
            JEMessage m = new JEMessage(JEMessage.Type.SET_INPUT, this, s);
            engine.recieveRequest(m);
        }

        String yesNoString = "no";

        String yesNo() {
            yesButton.setBackground(java.awt.Color.red);
            noButton.setBackground(java.awt.Color.red);
            synchronized (this) {
                try {
                    wait();
                } catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            yesButton.setBackground(java.awt.Color.white);
            noButton.setBackground(java.awt.Color.white);
            return yesNoString;
        }

		public void performResultMessage(JEMessage m) {
            //String res = (String)m.getResult();
            //System.out.println(res);
		}
    }
}
