package jp.ac.do_johodai.j314.sw.je;

import com.hp.hpl.jena.graph.*;
import com.hp.hpl.jena.reasoner.rulesys.builtins.BaseBuiltin;
import com.hp.hpl.jena.reasoner.rulesys.RuleContext;

/**
 * Acerola3Dのキャラクタのアクションを切り換えます。
 * ビルトインの名前は'a3change'。
 * 第1引数はキャラクタのIDがわりのリソース。
 * 第2引数はアクション番号。
 */
public class A3ChangeBuiltin extends BaseBuiltin {
    public String getName() {
        return "a3change";
    }

    public int getArgLength() {
        return 2;
    }

    public boolean bodyCall(Node[] args, int length, RuleContext context) {
        if (length != 2)
            return false;
        if (!A3NewBuiltin.hash.containsKey(args[0]))
            return false;
        return change(args);
    }

    public void headAction(Node[] args, int length, RuleContext context) {
        change(args);
    }

    boolean change(Node args[]) {
        A3NewBuiltin.MyFrame f = A3NewBuiltin.hash.get(args[0]);
        String v = ((Node_Literal) args[1]).getLiteralLexicalForm();
        v.trim();
        int i = Integer.parseInt(v);
        f.change(i);
        return true;
    }
}
