title: 形態素解析

形態素解析
========================================

形態素解析をするためのビルトインを作成しました．
このビルトインの作成には[sen](https://sen.dev.java.net/)
のバージョン1.2.2.1を使用しました．JenaCheckのWebStartには
形態素解析のための辞書を含めたくなかったので，
辞書は自前で用意して下さい．基本的にsenをインストール
過程で辞書を作成することになると思います．

現在のところ形態素解析関係で使用できるビルトインは

* keitaiso_init('senのインストールディレクトリ名')
* keitaiso(文字列, 変数)
* keitaisokaiseki(文字列, 変数)

の3種類となっています．
keitaiso_initで形態素解析システムの初期化をします．
このビルトインの引数はsenがインストールされたディレクト
名になります．実際にはsenのインストールされたディレクトリ
の中のdicサブディレクトリとconfサブディレクトリだけが
必要なようです．

keitaiso(文字列，変数)で，第一引数の文字列を形態素に分解して，
基本形になおしたもののリストを変数に代入します．(具体的には，
senのTokenオブジェクトのgetBasicString()メソッドで得られる
文字のリストです．)このリストはRDFのリスト形式になっています．

keitaisokaiseki(文字列，変数)では，更に詳しい情報も含めるために，
返される変数が，リストのリストになっていて，トップレベルのリスト
には分解した形態素の列に対応するデータが保存され，その下のレベルの
リストに一つ一つの形態素に関するデータが保存されます．

下のレベルリストの中の情報は以下の並びになっています．

1. 形態素(表層表現)(入力された文字列)
2. 基本形(活用する前の形)
3. 品詞情報(品詞，用言なら活用型，など)
4. 活用形(conjugated form)
5. 読み
6. 発音

それぞれ，senパッケージのTokenクラスの次のメソッドの返り値
です．

1. String getSurface()
2. String getBasicString()
3. String getPos()
4. String getCform()
5. String getReading()
6. String getPronunciation()

「読み」と「発音」の違いですが，以下のような感じです．

* 今日は
  - 読み: キョウ，ハ
  - 発音: キョー，ワ

使用例

    @prefix : <http://test.org/> .
    (:a :b :c) ->
        keitaiso_init('/usr/local/sen'),
        keitaiso('本日は晴天なり．',?x),
        print_list(?x) .

上のルールを実行するためにNotation3に次を入れる．

    @prefix : <http://test.org/> .
    :a :b :c .

Windowsではディレクトリ(フォルダ)の区切り文字として
バックスラッシュ(円マーク)を使っているので，senの
インストールされたディレクトリを指定する時には
エスケープする必要があると思います．

例

    keitaiso_init('C:\\sen-1.2.2.1')

----------

senのTokenのそのたのメソッド

String toString()
    形態素(表層表現)(たぶんgetSurface()と同じ)
int length()
    長さ
int start()
    形態素の始まりの位置
int end()
    形態素の終わりの位置
int getCost()
    コスト(たぶん出現頻度みたいなもの)
String getTermInfo()
    ?いろんな情報のよせあつめ?
String getAddInfo()
    ?
