title: FSMの使い方(出力処理の定義)
css: test.css

FSMの使い方(出力処理の定義)
----------------------------------------

デフォルトで使用できる出力処理と，拡張出力
処理でまにあわない場合は自分で出力処理を作成して，
FSMのfsm:outputに指定し使用することができます．

### 一番簡単な例

以下の例は，引数の値を標準出力に2回表示する
ためのルールで「:print2」という名前の出力処理と
します．

<pre><code>@prefix : &lt;http://test.org/> .
@prefix fsm: &lt;http://fsm.org/> .
#:print2 引数の内容を2回表示する．
(?b rdf:type fsm:out)
noValue(?b fsm:is fsm:fin)
(?b <span style="color:red;font-weight: bold;">:print2</span> <span style="color:blue;font-weight: bold;">?var</span>)
(?b fsm:target_fsm ?fsm)
makeTemp(?ib)
    ->
    <span style="color:green;font-weight: bold;">print(?var)
    print(?var)</span>
    (?b fsm:is fsm:fin)
    (?fsm fsm:input ?ib)
    (?ib fsm:input '@finished@')
    .
</code></pre>

上のほとんどの部分は決った書き方となっていて，
色を付けた部分が変更可能な部分です．赤の部分は出力
処理の識別子で，青の部分が引数となります．
緑の部分が実際の処理の内容です．

### 引数が2個以上ある場合の例

3つの引数を受け取ってそれをそれぞれ標準出力に表示する
出力処理を作ってみます．

<pre><code>@prefix : &lt;http://test.org/> .
@prefix fsm: &lt;http://fsm.org/> .
#:print3 3つの引数の内容をそれぞれ表示する．
(?b rdf:type fsm:out)
noValue(?b fsm:is fsm:fin)
(?b :print3 <span style="color:red;font-weight: bold;">?list</span>)
(?b fsm:target_fsm ?fsm)
<span style="color:blue;font-weight: bold;">listEntry(?list,0,?var0)
listEntry(?list,1,?var1)
listEntry(?list,2,?var2)</span>
makeTemp(?ib)
    ->
    <span style="color:green;font-weight: bold;">print(?var0)</span>
    <span style="color:green;font-weight: bold;">print(?var1)</span>
    <span style="color:green;font-weight: bold;">print(?var2)</span>
    (?b fsm:is fsm:fin)
    (?fsm fsm:input ?ib)
    (?ib fsm:input '@finished@')
    .
</code></pre>

引数の数が2以上の場合は，リストとして処理します．赤の部分で，そのリスト
を受け取って，青の部分でリストの内容をひとつづつ取り出し．緑の部分で，
それぞれ表示しています．

FSMから使用する時には以下のような感じでfsm:output
の目的語で3つの引数('A' 'B' 'C')を指定します．

    [ a               fsm:stt ;
      fsm:target_fsm  :FSM1 ;
      fsm:status      :a ;
      fsm:input       'A' ;
      fsm:output      (:print3 ('A' 'B' 'C')) ;
      fsm:next_status :a ] .


### 変数を利用する例

第一引数で指定された変数の値を第二引数で指定された変数に
コピーする出力処理を作ってみます．

<pre><code>@prefix : &lt;http://test.org/> .
@prefix fsm: &lt;http://fsm.org/> .
#:varCopy 第一引数の変数内容を第二引数の変数にコピーする
(?b rdf:type fsm:out)
noValue(?b fsm:is fsm:fin)
(?b :varCopy ?list)
(?b fsm:target_fsm ?fsm)
listEntry(?list,0,?var0)
listEntry(?list,1,?var1)
<span style="color:red;font-weight:bold;">(?fsm fsm:var ?vb)
(?vb ?var0 ?value)</span>
<span style="color:blue;font-weight:bold;">makeTemp(?vb2)</span>
makeTemp(?ib)
    ->
    <span style="color:green;font-weight: bold;">(?fsm fsm:var ?vb2)
    (?vb2 ?var1 ?value)</span>
    (?b fsm:is fsm:fin)
    (?fsm fsm:input ?ib)
    (?ib fsm:input '@finished@')
    .
</code></pre>

赤の部分で第一引数の変数の内容を`?value`変数に取り出しています．
青の部分で空白ノードを作成し，その空白ノードを利用して
緑の部分で新しい変数を作成しています．
