title: FSMの使い方(基本)
css: test.css

FSMの使い方(基本)
----------------------------------------

まず、以下の図のような簡単なFSMを実装す例で説明します．

<!--
<embed src="images/basicFSM.svg" type="image/svg+xml" width="300" height="150" />
-->

![basicFSM.png](./images/basicFSM.png)

このFSMは初期状態が「a」で，もう一つの状態として「b」を
持っています．状態が「a」の時に「A」という入力が入って
くると，「AAA」という文字を出力して状態「b」に移行します．
状態「b」で「B」という入力が入ってくると「BBB」という
文字を出力して状態「A」に移行します．

このFSMをNotation3によって記述すると以下のようになります．

    @prefix : <http://test.org/> .
    @prefix fsm: <http://fsm.org/> .
    #FSM1の定義と初期化
    :FSM1 a             fsm:fsm ;
          fsm:status    [ fsm:status :a ] ;
          fsm:inputList [ fsm:status :a;
                          fsm:list ('A') ] ,
                        [ fsm:status :b;
                          fsm:list ('B') ] .
    #三組入力をFSM1にバインド
    fsm:tripleInput fsm:bindto :FSM1 .
    #FSM1の状態遷移表の定義
    [ a               fsm:stt ;
      fsm:target_fsm  :FSM1 ;
      fsm:status      :a;
      fsm:input       'A' ;
      fsm:output      (fsm:print 'AAA') ;
      fsm:next_status :b ] .
    [ a               fsm:stt ;
      fsm:target_fsm  :FSM1 ;
      fsm:status      :b ;
      fsm:input       'B' ;
      fsm:output      (fsm:print 'BBB') ;
      fsm:next_status :a ] .

プレフィックスは`@prefix fsm: <http://fsm.org/> .`を
宣言しておくと良いでしょう．そして，FSMの実態はどの
ネームスペースにあってもよいのですが，上の例では
デフォルトのネームスペースを`@prefix : <http://test.org/> .`
というように定義して`:FSM1`というURIでFSMを宣言して
います．

`:FSM1`を主語とする三つ組がいくつかあり，最初のものは
`:FSM1`が`fsm:fsm`クラスに属していることを示しており，
初期状態が`:a`であると宣言しています．その次は，
`:FSM1`のそれぞれの状態における入力のリストを宣言
しています(この部分は2006,11/25バージョンから必要に
なりました)．

次の`fsm:tripleInput fsm:bindto :FSM1 .`の三つ組は，
三組入力を`:FSM1`で使用することを宣言しています．
(複数のFSMが使用できる仕様になっているため．)

最後の部分が，実際にFSMの動作を定義している部分で，
状態遷移表の内容です．上の図の一本の辺ごとに，
空白ノードを主語にして必要な情報がまとめられています．

* [fsm:target\_fsm]この状態遷移の情報が適用されるFSM
* [fsm:status]現在の状態
* [fsm:input]入力文字列
* [fsm:output]出力処理
* [fsm:next\_status]次の状態

この情報を要約すると，「[fsm:target\_fsm]のFSMは，
状態が[fsm:status]の時に[fsm:input]の入力が入ってくると，
[fsm:output]という出力処理を行い，[fsm:next\_status]の
状態に移行する」となります．

出力[fsm:output]の部分の目的後はリストになっており，
第1要素には処理の内容，第2要以降には処理に必要な
引数が指定されます．上の例では処理の内容は
「fsm:print」で，その引数が「AAA」や「BBB」などの
文字列となっています．この処理の内容と引数の組み合わせ
については[こちら](./usage2.mm)で説明します．

