title: FSMの拡張出力処理(A3)
css: test.css

FSMの拡張出力処理(A3)
----------------------------------------

A3ウィンドウの文字の入力には「三組入力」を
使用して下さい．そうすればデフォルトの
fsm:readがそのまま使用できます．

    @prefix fsm: <http://fsm.org/> .
    @prefix a3: <http://elm-ve.sf.net/a23/a3/fsm/> .
    #a3:init A3の初期化を行う
    #第一引数にはWindowのキーを第2引数にはA3ファイルのURLを指定
    (?b rdf:type fsm:out)
    noValue(?b fsm:is fsm:fin)
    (?b a3:init ?list)
    listEntry(?list,0,?wKey)
    listEntry(?list,1,?a3url)
    (?b fsm:target_fsm ?fsm)
    makeTemp(?ib)
        ->
        a3new(?wKey,?a3url)
        a3setVisible(?wKey,1)
        (?b fsm:is fsm:fin)
        (?fsm fsm:input ?ib)
        (?ib fsm:input '@finished@')
        .
    #a3:print A3のキャラクタの吹き出しに文字を出力
    #第一引数にはWindowのキーを第2引数には文字列を指定
    (?b rdf:type fsm:out)
    noValue(?b fsm:is fsm:fin)
    (?b a3:print ?list)
    listEntry(?list,0,?wKey)
    listEntry(?list,1,?string)
    (?b fsm:target_fsm ?fsm)
    makeTemp(?ib)
        ->
        a3print(?wKey,?string)
        (?b fsm:is fsm:fin)
        (?fsm fsm:input ?ib)
        (?ib fsm:input '@finished@')
        .
    #a3:varPrint A3のキャラクタの吹き出しに変数の内容を出力
    #第一引数にはWindowのキーを第2引数には変数名を指定
    (?b rdf:type fsm:out)
    noValue(?b fsm:is fsm:fin)
    (?b a3:varPrint ?list)
    #listEntry(?list,0,?wKey)
    #listEntry(?list,1,?var)
    (?list rdf:first ?wKey)
    (?list rdf:rest ?rest1)
    (?rest1 rdf:first ?var)
    (?b fsm:target_fsm ?fsm)
    (?fsm fsm:var ?vb)
    noValue(?vb fsm:is fsm:old)
    (?vb ?var ?value)
    makeTemp(?ib)
        ->
        a3print(?wKey,?value)
        (?b fsm:is fsm:fin)
        (?fsm fsm:input ?ib)
        (?ib fsm:input '@finished@')
        .
    #a3:change A3のキャラクタの動作を変更
    #第一引数にはWindowのキーを第2引数にはアクションNoを指定
    (?b rdf:type fsm:out)
    noValue(?b fsm:is fsm:fin)
    (?b a3:change ?list)
    listEntry(?list,0,?wKey)
    listEntry(?list,1,?aNo)
    (?b fsm:target_fsm ?fsm)
    makeTemp(?ib)
        ->
        a3change(?wKey,?aNo)
        (?b fsm:is fsm:fin)
        (?fsm fsm:input ?ib)
        (?ib fsm:input '@finished@')
        .
    #a3:yesno A3のウィンドウでYES,NOボタンの入力を変数に代入
    #第一引数にはWindowのキーを第2引数にはFSMの変数を指定
    (?b rdf:type fsm:out)
    noValue(?b fsm:is fsm:fin)
    (?b a3:yesno ?list)
    listEntry(?list,0,?wKey)
    listEntry(?list,1,?var)
    (?b fsm:target_fsm ?fsm)
    makeTemp(?vb)
    makeTemp(?ib)
        ->
        a3yesno(?wKey,?x)
        (?b fsm:is fsm:fin)
        (?fsm fsm:var ?vb)
        (?vb ?var ?x)
        (?fsm fsm:input ?ib)
        (?ib fsm:input '@finished@')
        .

確認のためのFSM

    @prefix : <http://test.org/> .
    @prefix fsm: <http://fsm.org/> .
    @prefix a3: <http://elm-ve.sf.net/a23/a3/fsm/> .
    #FSM1の定義と初期化
    :FSM1 a             fsm:fsm ;
          fsm:status    [ fsm:status :start ] ;
          fsm:input     [ fsm:input 'goNext' ] ;
          fsm:var       [ :testVar 'Hello World' ] ;
          fsm:inputList [ fsm:status :start;
                          fsm:list ('goNext') ] ,
                        [ fsm:status :a;
                          fsm:list ('A') ] .
    #三組入力をFSM1にバインド
    fsm:tripleInput fsm:bindto :FSM1 .
    #FSM1の状態遷移表の定義
    [ a               fsm:stt ;
      fsm:target_fsm  :FSM1 ;
      fsm:status      :start;
      fsm:input       'goNext' ;
      fsm:output      (a3:init (:w 'x-res:///jp/ac/do_johodai/j314/sw/jc/vesma9.a3')) ;
      fsm:next_status :a ] .
    [ a               fsm:stt ;
      fsm:target_fsm  :FSM1 ;
      fsm:status      :a ;
      fsm:input       'A' ;
      fsm:output      (a3:varPrint (:w :testVar)) ;
      fsm:next_status :a ] .
