title: FSMの余談
css: test.css

FSMの余談
----------------------------------------

このプログラムでは状態を保存するのに三つ組を使って
ますが，Jenaで状態を更新して新しくする上手い方法が
思いつきませんでした．(古い三つ組をremoveで消して，
新しい三つ組を作れば良さそうですが，そうすると
removeの作用が伝搬して消したくない三つ組が
消えてしまうことがあります．かといってdropを使うと，
削除されたことをJenaが認識しなくて無限ループとかに
なったりする．)そこで，代替案として古い状態に
(?s fsm:is fsm:old)のような情報を付けて，新しいものと
区別しています．つまり，古い情報も消さずに残している
ので，プログラムの実行が進行するにつれてゴミが増えて
いくことになります．

以下のSPARQLでゴミを消しても良いかも…．いやだめだった．
少なくとも，最後の入力だけは残しておかないとだめ
じゃないかと思う．でも最後の入力も，処理が終了すると
oldになるから以下のSPARQLではだめだった．

    PREFIX fsm: <http://fsm.org/>
    PREFIX in: <http://input.org/namespace#>
    PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>
    CONSTRUCT {
        ?b1 fsm:is fsm:old .
        ?b1 ?p1 ?o1 .
        ?b2 in:is in:old .
        ?b2 ?p2 ?o2 .
        ?b3 rdf:type fsm:out .
        ?b3 fsm:is fsm:fin .
        ?b3 ?p3 ?o3 .
    }
    WHERE {
        ?b1 fsm:is fsm:old .
        ?b1 ?p1 ?o1 .
        ?b2 in:is in:old .
        ?b2 ?p2 ?o2 .
        ?b3 rdf:type fsm:out .
        ?b3 fsm:is fsm:fin .
        ?b3 ?p3 ?o3 .
    }

