title: 通信

JenaCheckどうしの通信
========================================

ビルトイン
----------------------------------------

    send_n3('http://webservice.com/endpoint',S,P,O[,S,P,O,…])

RequestとReplyのある通信
----------------------------------------

以下のルールは，リクエストを出してその返事を受けとるという
通信を簡単に行うためのもので，汎用的に使用できるように
考えたものです．でも，まだまだ改善の余地はあります．
(2006,11/28:スマートじゃないですが，引数が3つまで
指定できるように改良しました．)

    @prefix co: <http://communication.org/> .
    @prefix rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#> .
    #自分のサービスエンドポイントを記録しておく
    -> (co:my co:sep 'http://自分のIPアドレス:8080/axis2/services/JEService') .
    #リクエスト送信のためのデータの引数が必ず3つになるようにするルール
    (?reqc rdf:type co:RequestClient),
    noValue(?reqc, co:arg1) ->
        (?reqc co:arg1 'dummy1') .
    (?reqc rdf:type co:RequestClient),
    noValue(?reqc, co:arg2) ->
        (?reqc co:arg2 'dummy2') .
    (?reqc rdf:type co:RequestClient),
    noValue(?reqc, co:arg3) ->
        (?reqc co:arg3 'dummy3') .
    #リクエスト送信のためのデータがあったら実際にリクエストを送信するルール
    (?reqc rdf:type co:RequestClient),
    (?reqc co:server ?x),
    (?reqc co:reqName ?y),
    (?reqc co:catchName ?z),
    (?reqc co:arg1     ?w1),
    (?reqc co:arg2     ?w2),
    (?reqc co:arg3     ?w3),
    (co:my co:sep ?sep) ->
        rand_int(1,10000,?n),
        (?reqc co:reqNumber ?n),
        send_n3(?x, co:reqS rdf:type co:RequestServer
                    co:reqS co:reqNumber ?n
                    co:reqS co:client ?sep
                    co:reqS co:reqName ?y
                    co:reqS co:arg1 ?w1
                    co:reqS co:arg2 ?w2
                    co:reqS co:arg3 ?w3) .
    #リクエストを受け取った時に適切なルールが起動されるようにするルール
    (?reqs rdf:type co:RequestServer),
    (?reqs co:client ?x),
    (?reqs co:reqName ?y),
    (?reqs co:arg1    ?z1),
    (?reqs co:arg2    ?z2),
    (?reqs co:arg3    ?z3) ->
        (?y co:reqs ?reqs),
        (?y co:arg1 ?z1),
        (?y co:arg2 ?z2),
        (?y co:arg3 ?z3) .
    #ルールが処理した内容をclientに返すルール
    (?reps rdf:type co:ReplyServer),
    (?reps co:reqs ?reqs),
    (?reps co:rep ?x),
    (?reqs rdf:type co:RequestServer),
    (?reqs co:client ?y),
    (?reqs co:reqNumber ?n),
    (?reqs co:reqName ?z),
    (?reqs co:arg1     ?w1),
    (?reqs co:arg2     ?w2),
    (?reqs co:arg3     ?w3) ->
        send_n3(?y, co:repC rdf:type co:ReplyClient
                    co:repC co:reqNumber ?n
                    co:repC co:rep ?x),
        remove(3,4,5,6,7,8,9) .
    #返ってきた返事を処理するルール
    (?repc rdf:type co:ReplyClient),
    (?repc co:reqNumber ?n),
    (?repc co:rep ?rep),
    (?reqc rdf:type co:RequestClient),
    (?reqc co:server ?x),
    (?reqc co:reqName ?y),
    (?reqc co:catchName ?z),
    (?reqc co:arg1 ?w1),
    (?reqc co:arg2 ?w2),
    (?reqc co:arg3 ?w3),
    (?reqc co:reqNumber ?n) ->
        remove(0,1,2,3,4,5,6,7,8,9,10),
        (?z co:rep ?rep) .

利用方法
----------------------------------------

クライアント側

    @prefix : <http://test.org/> .
    @prefix co: <http://communication.org/> .
    #リクエストを出すルールのテスト
    (:start :the :program) ->
        (:rTest rdf:type co:RequestClient),
        (:rTest co:server 'http://192.168.2.15:8080/axis2/services/JEService'),
        (:rTest co:reqName :test),
        (:rTest co:catchName :catch),
        (:rTest co:arg1 1) .
    #返事を受け取るルール
    (:catch co:rep ?x) ->
        print('返ってきた返事:', ?x) .

サーバ側

    @prefix : <http://test.org/> .
    @prefix co: <http://communication.org/> .
    #テストのルール(うけとった数字に10を加えて返す)
    (:test co:reqs ?reqs),
    (:test co:arg1 ?x)
    sum(?x,10,?xNew) ->
        (:tRep rdf:type co:ReplyServer),
        (:tRep co:reqs ?reqs),
        (:tRep co:rep ?xNew) .
