package jp.co.isic.SwissEphemeris;

//import java.util.*;
//import java.io.*;
import java.text.DecimalFormat;

public class AstroLib {

	public static final String AST_ARIES = "ҤĤ"; //ҤĤ //$NON-NLS-1$
	public static final String AST_TAURUS = ""; // //$NON-NLS-1$
	public static final String AST_GEMINI = "դ"; //դ //$NON-NLS-1$
	public static final String AST_CANCER = ""; // //$NON-NLS-1$
	public static final String AST_LEO = ""; // //$NON-NLS-1$
	public static final String AST_VIRGO = "Ȥ"; //Ȥ //$NON-NLS-1$
	public static final String AST_LIBRA = "ƤӤ"; //ƤӤ //$NON-NLS-1$
	public static final String AST_SCORPIUS = ""; // //$NON-NLS-1$
	public static final String AST_SAGITTARIUS = ""; // //$NON-NLS-1$
	public static final String AST_CAPRICORNUS = "䤮"; //䤮 //$NON-NLS-1$
	public static final String AST_AQUARIUS = "ߤ"; //ߤ //$NON-NLS-1$
	public static final String AST_PISCES = ""; // //$NON-NLS-1$
	public static final String AST_DEC = ""; // //$NON-NLS-1$
	public static final String AST_MIN = ""; //ʬ //$NON-NLS-1$
	public static final String AST_SEC = ""; // //$NON-NLS-1$
	static final double BIAS[] =
		{ 0, 0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334, 0 };
	static final double TP[] = { //
		400, 407, 410, 411, 408, //
		402, 394, 383, 370, 357, //
		343, 328, 314, 301, 290, //
		280, 272, 267, 264, 265, //
		268, 273, 279, 286, 294, //
		302, 310, 317, 325, 333, //
		341, 349, 358, 368, 378, //
		387, 396, 404, 409, 411, //
		410, 0 };
	static final double AP[] = { //
		4.2, 4.1, 4.1, 4.2, 4.1, //
		4.1, 4.0, 4.0, 4.0, 4.0, //
		3.9, 4.0, 4.0, 3.9, 3.8, //
		3.8, 3.9, 3.8, 3.8, 3.8, //
		3.8, 3.8, 3.8, 3.9, 3.9, //
		3.9, 3.9, 4.0, 4.0, 4.0, //
		4.0, 4.0, 4.0, 4.0, 4.0, //
		4.1, 4.2, 4.1, 4.1, 4.2, //
		4.2, 0 };
	static final double BP[] = { //
		-3.0, -3.1, -3.1, -2.9, -2.5, //
		-2.1, -1.7, -1.3, -0.9, -0.4, //
		0.1, 0.5, 1.0, 1.5, 2.0, //
		2.4, 2.8, 3.1, 3.2, 3.4, //
		3.2, 3.1, 2.8, 2.4, 2.1, //
		1.7, 1.3, 0.8, 0.4, -0.1, //
		-0.6, -1.1, -1.6, -1.9, -2.2, //
		-2.6, -2.9, -3.1, -3.1, -3.0, //
		-2.7, 0 };

	public static String toDec(double deg) {

		String DEC = ""; //$NON-NLS-1$
		int dec, min, sec;
		double tmp;
		DecimalFormat exFormat1 = new DecimalFormat("#00"); //$NON-NLS-1$
		tmp = deg;
		if (deg < 0) {
			deg = Math.abs(deg);
		}
		dec = (int) deg % 30;
		min = (int) Math.floor((deg - (Math.floor(deg / 30) * 30 + dec)) * 60);
		sec =
			(int) Math.floor(
				((deg - ((Math.floor(deg / 30) * 30 + dec)) + min / 60) * 60
					- min)
					* 60);
		if (deg != tmp) {
			dec = 0 - dec;
		}
		DEC =
			intFormat2(dec)
				+ AST_DEC
				+ exFormat1.format(min)
				+ AST_MIN
				+ exFormat1.format(sec)
				+ AST_SEC;

		return (DEC);
	}
	public static int getSign(double deg) {
		int sign;

		if (deg < 0) {
			deg = 360 - deg;
		}
		if (deg >= 360) {
			deg = deg - 360;
		}

		sign = (int) Math.floor(deg / 30);
		return (sign);
	}
	public static String toSign(double deg) {

		String SIGN = ""; //$NON-NLS-1$
		int sign;
		sign = getSign(deg);

		switch (sign) {
			case 0 :
				SIGN = AST_ARIES;
				break;
			case 1 :
				SIGN = AST_TAURUS;
				break;
			case 2 :
				SIGN = AST_GEMINI;
				break;
			case 3 :
				SIGN = AST_CANCER;
				break;
			case 4 :
				SIGN = AST_LEO;
				break;
			case 5 :
				SIGN = AST_VIRGO;
				break;
			case 6 :
				SIGN = AST_LIBRA;
				break;
			case 7 :
				SIGN = AST_SCORPIUS;
				break;
			case 8 :
				SIGN = AST_SAGITTARIUS;
				break;
			case 9 :
				SIGN = AST_CAPRICORNUS;
				break;
			case 10 :
				SIGN = AST_AQUARIUS;
				break;
			case 11 :
				SIGN = AST_PISCES;
				break;
		}
		return (SIGN);
	}

	public static void sunrisOld(
		int month,
		int day,
		double lon,
		double lat,
		int rise[]) {

		double a[], b[], t0[];
		int td, td1;
		int ib, it, ih, im;
		a = new double[1];
		b = new double[1];
		t0 = new double[1];

		td = (int) BIAS[month] + day;
		td1 = td + 19;
		ib = td1 / 10;
		cpara(td, ib, t0, a, b);
		it = (int) (t0[0] + a[0] * (139.8 - lon) + b[0] * (35.7 - lat));
		ih = it / 60;
		im = it % 60;
		rise[0] = ih;
		rise[1] = im;
	}

	private static void cpara(
		int td,
		int ib,
		double t0[],
		double a[],
		double b[]) {

		int it[], x[];
		it = new int[42];
		x = new int[5];
		double y[];
		y = new double[5];
		int i, j;

		for (i = 0; i < 41; i++) {
			it[i] = i * 10 - 19;
		}
		for (i = 0; i < 4; i++) {
			j = ib + i;
			x[i] = it[j];
			y[i] = TP[j];
		}
		ave(x, y, td, t0);
		for (i = 0; i < 4; i++) {
			j = ib + i;
			y[i] = AP[j];
		}
		ave(x, y, td, a);
		for (i = 0; i < 4; i++) {
			j = ib + i;
			y[i] = BP[j];
		}
		ave(x, y, td, b);
	}
	private static void ave(int x[], double y[], int td, double yy[]) {

		double xh, xl;
		int i, j;

		yy[0] = 0.0;
		for (i = 0; i < 4; i++) {
			xh = 1.0;
			xl = 1.0;
			for (j = 0; j < 4; j++) {
				if (i == j)
					continue;
				xh *= td - x[j];
				xl *= x[i] - x[j];
			}
			yy[0] += xh / xl * y[i];
		}
	}
	public static String intFormat2(int num) {
		if (num < 10) {
			return " " + num; //$NON-NLS-1$
		}
		return Integer.toString(num);
	}
	// sin function using degree
	public static double sind(double d) {
		return Math.sin(d * Math.PI / 180);
	}
	// cos function using degree
	public static double cosd(double d) {
		return Math.cos(d * Math.PI / 180);
	}
	// tan function using degree
	public static double tand(double d) {
		return Math.tan(d * Math.PI / 180);
	}
	// calculate Julius year (year from 2000/1/1, for variable "t")
	public double jy(
		int yy,
		int mm,
		int dd,
		int h,
		int m,
		int s,
		double i) { // yy/mm/dd h:m:s, i: time difference
		double k;
		yy -= 2000;

		if (mm <= 2) {
			mm += 12;
			yy--;
		}
		k =
			365 * (double) yy
				+ 30 * (double) mm
				+ (double) dd
				- 33.5
				- i / 24
				+ Math.floor(3 * ((double) mm + 1) / 5)
				+ Math.floor((double) yy / 4)
				- Math.floor((double) yy / 100)
				+ Math.floor((double) yy / 400);
		k += (((double) s / 60 + (double) m) / 60 + (double) h) / 24;
		// plus time
		k += (65 + (double) yy) / 86400; // plus delta T
		return k / 365.25;
	}
	// solar position1 (celestial longitude, degree)
	public double spls(double t) { // t: Julius year

		double l =
			280.4603
				+ 360.00769 * t
				+ (1.9146 - 0.00005 * t) * sind(357.538 + 359.991 * t)
				+ 0.0200 * sind(355.05 + 719.981 * t)
				+ 0.0048 * sind(234.95 + 19.341 * t)
				+ 0.0020 * sind(247.1 + 329.640 * t)
				+ 0.0018 * sind(297.8 + 4452.67 * t)
				+ 0.0018 * sind(251.3 + 0.20 * t)
				+ 0.0015 * sind(343.2 + 450.37 * t)
				+ 0.0013 * sind(81.4 + 225.18 * t)
				+ 0.0008 * sind(132.5 + 659.29 * t)
				+ 0.0007 * sind(153.3 + 90.38 * t)
				+ 0.0007 * sind(206.8 + 30.35 * t)
				+ 0.0006 * sind(29.8 + 337.18 * t)
				+ 0.0005 * sind(207.4 + 1.50 * t)
				+ 0.0005 * sind(291.2 + 22.81 * t)
				+ 0.0004 * sind(234.9 + 315.56 * t)
				+ 0.0004 * sind(157.3 + 299.30 * t)
				+ 0.0004 * sind(21.1 + 720.02 * t)
				+ 0.0003 * sind(352.5 + 1079.97 * t)
				+ 0.0003 * sind(329.7 + 44.43 * t);
		while (l >= 360) {
			l -= 360;
		}
		while (l < 0) {
			l += 360;
		}
		return l;
	}
	// solar position2 (distance, AU)
	public double spds(double t) { // t: Julius year
		double r =
			(0.007256 - 0.0000002 * t) * sind(267.54 + 359.991 * t)
				+ 0.000091 * sind(265.1 + 719.98 * t)
				+ 0.000030 * sind(90.0)
				+ 0.000013 * sind(27.8 + 4452.67 * t)
				+ 0.000007 * sind(254 + 450.4 * t)
				+ 0.000007 * sind(156 + 329.6 * t);
		r = Math.pow(10, r);
		return r;
	}
	// solar position3 (declination, degree)
	public double spal(double t) { // t: Julius year
		double ls = spls(t);
		double ep = 23.439291 - 0.000130042 * t;
		double al = Math.atan(tand(ls) * cosd(ep)) * 180 / Math.PI;
		if ((ls >= 0) && (ls < 180)) {
			while (al < 0) {
				al += 180;
			}
			while (al >= 180) {
				al -= 180;
			}
		} else {
			while (al < 180) {
				al += 180;
			}
			while (al >= 360) {
				al -= 180;
			}
		}
		return al;
	}
	// solar position4 (the right ascension, degree)
	public double spdl(double t) { // t: Julius year
		double ls = spls(t);
		double ep = 23.439291 - 0.000130042 * t;
		double dl = Math.asin(sind(ls) * sind(ep)) * 180 / Math.PI;
		return dl;
	}
	// Calculate sidereal hour (degree)
	public double sh(
		double t,
		int h,
		int m,
		int s,
		double l,
		double i) { // t: julius year, h: hour, m: minute, s: second,
		// l: longitude, i: time difference
		double d = (((double) s / 60 + (double) m) / 60 + (double) h) / 24;
		// elapsed hour (from 0:00 a.m.)
		double th =
			100.4606 + 360.007700536 * t + 0.00000003879 * t * t - 15 * i;
		th += l + 360 * d;
		while (th >= 360) {
			th -= 360;
		}
		while (th < 0) {
			th += 360;
		}
		return th;
	}
	// Calculating the seeming horizon altitude "sa"(degree)
	public double eandp(
		double alt,
		double ds) { // subfunction for altitude and parallax
		double e = 0.035333333 * Math.sqrt(alt);
		double p = 0.002442818 / ds;
		return p - e;
	}
	public double sa(
		double alt,
		double ds) { // alt: altitude (m), ds: solar distance (AU)
		double s = 0.266994444 / ds;
		double r = 0.585555555;
		double k = eandp(alt, ds) - s - r;
		return k;
	}
	// Calculating solar alititude (degree) {
	public double soal(
		double la,
		double th,
		double al,
		double dl) { // la: latitude, th: sidereal hour,
		// al: solar declination, dl: right ascension
		double h = sind(dl) * sind(la) + cosd(dl) * cosd(la) * cosd(th - al);
		h = Math.asin(h) * 180 / Math.PI;
		return h;
	}
	// Calculating solar direction (degree) {
	public double sodr(
		double la,
		double th,
		double al,
		double dl) { // la: latitude, th: sidereal hour,
		// al: solar declination, dl: right ascension
		double t = th - al;
		double dc = -cosd(dl) * sind(t);
		double dm = sind(dl) * sind(la) - cosd(dl) * cosd(la) * cosd(t);
		double st = 0, dr = 0;
		if (dm == 0) {
			st = sind(t);
			if (st > 0)
				dr = -90;
			if (st == 0)
				dr = 9999;
			if (st < 0)
				dr = 90;
		} else {
			dr = Math.atan(dc / dm) * 180 / Math.PI;
			if (dm < 0)
				dr += 180;
		}
		if (dr < 0)
			dr += 360;
		return dr;
	}
	public String sunris(int mm, int dd, double lon, double lat, int rise[]) {
		double i;
		i = -Math.floor(lon / 15);
		return sunris(1970, mm, dd, i, lat, lon, 0, rise);
	}

	public String sunris(//
	int mm, //
	int dd, //
	double i, //Timezone
	double la, //
	double lo, //
	int rise[]) // νл
	{
		return sunris(1970, mm, dd, i, la, lo, 0, rise);
	}

	public String sunris(//
	int yy, //
	int mm, //
	int dd, //
	double i, //Timezone
	double la, //
	double lo, //
	int rise[]) // νл
	{
		return sunris(yy, mm, dd, i, la, lo, 0, rise);
	}
	public String sunris(//
	int yy, //
	int mm, //
	int dd, //
	double i, //Timezone
	double la, //
	double lo, //
	double alt, //ɸ
	int rise[]) // νл
	{
		i = - (i);
		String ans = ""; // = yy + "ǯ" + mm + "" + dd + "η׻\n"; //$NON-NLS-1$

		double t = jy(yy, mm, dd - 1, 23, 59, 0, i);
		double th = sh(t, 23, 59, 0, lo, i);
		double ds = spds(t);
//		double ls = spls(t);
		double alp = spal(t);
		double dlt = spdl(t);
		double pht = soal(la, th, alp, dlt);
		double pdr = sodr(la, th, alp, dlt);
		int hh, m;
		double ht, dr, tt, t1, t2, t3, t4;
		H : for (hh = 0; hh < 24; hh++) {
			for (m = 0; m < 60; m++) {
				t = jy(yy, mm, dd, hh, m, 0, i);

				th = sh(t, hh, m, 0, lo, i);
				ds = spds(t);
//				ls = spls(t);
				alp = spal(t);
				dlt = spdl(t);
				ht = soal(la, th, alp, dlt);
				dr = sodr(la, th, alp, dlt);
				tt = eandp(alt, ds);
				t1 = tt - 18;
				t2 = tt - 12;
				t3 = tt - 6;
				t4 = sa(alt, ds);
				// Solar check 
				// 0: non, 1: astronomical twilight start , 2: voyage twilight start,
				// 3: citizen twilight start, 4: sun rise, 5: meridian, 6: sun set,
				// 7: citizen twilight end, 8: voyage twilight end,
				// 9: astronomical twilight end
				if ((pht < t1) && (ht > t1))
					ans += hh + "" + m + "ʬ ŷʸϤޤ\n"; //$NON-NLS-1$ //$NON-NLS-2$
				if ((pht < t2) && (ht > t2))
					ans += hh + "" + m + "ʬ ҳϤޤ\n"; //$NON-NLS-1$ //$NON-NLS-2$
				if ((pht < t3) && (ht > t3))
					ans += hh + "" + m + "ʬ ̱Ϥޤ\n"; //$NON-NLS-1$ //$NON-NLS-2$

				if ((pht < t4) && (ht > t4)) {
					ans += hh + "" + m + "ʬ (" + Math.floor(dr) + ")\n"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
					rise[0] = hh;
					rise[1] = m;
					break H;

				}
				if ((pdr < 180) && (dr > 180))
					ans += hh + "" + m + "ʬ (" + Math.floor(ht) + ")\n"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
				if ((pht > t4) && (ht < t4))
					ans += hh + "" + m + "ʬ (" + Math.floor(dr) + ")\n"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
				if ((pht > t3) && (ht < t3))
					ans += hh + "" + m + "ʬ ̱\n"; //$NON-NLS-1$ //$NON-NLS-2$
				if ((pht > t2) && (ht < t2))
					ans += hh + "" + m + "ʬ ҳ\n"; //$NON-NLS-1$ //$NON-NLS-2$
				if ((pht > t1) && (ht < t1))
					ans += hh + "" + m + "ʬ ŷʸ\n"; //$NON-NLS-1$ //$NON-NLS-2$
				pht = ht;
				pdr = dr;
			}
		}
		return ans;
	}
	public String solar(//
	int yy, //
	int mm, //
	int dd, //
	double i, //Timezone
	double la, //
	double lo, //
	double alt, //ɸ
	int set[][]) // ̥å
	{
		i = - (i);
		String ans = ""; // = yy + "ǯ" + mm + "" + dd + "η׻\n"; //$NON-NLS-1$

		double t = jy(yy, mm, dd - 1, 23, 59, 0, i);
		double th = sh(t, 23, 59, 0, lo, i);
		double ds = spds(t);
//		double ls = spls(t);
		double alp = spal(t);
		double dlt = spdl(t);
		double pht = soal(la, th, alp, dlt);
		double pdr = sodr(la, th, alp, dlt);
		int hh, m;
		double ht, dr, tt, t1, t2, t3, t4;
		H : for (hh = 0; hh < 24; hh++) {
			for (m = 0; m < 60; m++) {
				t = jy(yy, mm, dd, hh, m, 0, i);

				th = sh(t, hh, m, 0, lo, i);
				ds = spds(t);
//				ls = spls(t);
				alp = spal(t);
				dlt = spdl(t);
				ht = soal(la, th, alp, dlt);
				dr = sodr(la, th, alp, dlt);
				tt = eandp(alt, ds);
				t1 = tt - 18;
				t2 = tt - 12;
				t3 = tt - 6;
				t4 = sa(alt, ds);
				// Solar check 
				// 0: non, 1: astronomical twilight start , 2: voyage twilight start,
				// 3: citizen twilight start, 4: sun rise, 5: meridian, 6: sun set,
				// 7: citizen twilight end, 8: voyage twilight end,
				// 9: astronomical twilight end
				if ((pht < t1) && (ht > t1)) {
					ans += hh + "" + m + "ʬ ŷʸϤޤ\n"; //$NON-NLS-1$ //$NON-NLS-2$
					set[0][0] = hh;
					set[1][0] = m;
				}
				if ((pht < t2) && (ht > t2)) {
					ans += hh + "" + m + "ʬ ҳϤޤ\n"; //$NON-NLS-1$ //$NON-NLS-2$
					set[0][1] = hh;
					set[1][1] = m;
				}
				if ((pht < t3) && (ht > t3)) {
					ans += hh + "" + m + "ʬ ̱Ϥޤ\n"; //$NON-NLS-1$ //$NON-NLS-2$
					set[0][2] = hh;
					set[1][2] = m;
				}

				if ((pht < t4) && (ht > t4)) {
					ans += hh + "" + m + "ʬ (" + Math.floor(dr) + ")\n"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
					set[0][3] = hh;
					set[1][3] = m;
				}
				if ((pdr < 180) && (dr > 180)) {
					ans += hh + "" + m + "ʬ (" + Math.floor(ht) + ")\n"; //$NON-NLS-1$ //$NON-NLS-2$ //$NON-NLS-3$
                    set[0][4] = hh;
                    set[1][4] = m;
				}
				if ((pht > t4) && (ht < t4)) {
					ans += hh + "" + m + "ʬ (" + Math.floor(dr) + ")\n";  //$NON-NLS-1$ //$NON-NLS-2$//$NON-NLS-3$
					set[0][5] = hh;
					set[1][5] = m;
				}
				if ((pht > t3) && (ht < t3)) {
					ans += hh + "" + m + "ʬ ̱\n"; //$NON-NLS-1$ //$NON-NLS-2$
                    set[0][6] = hh;
                    set[1][6] = m;
				}
				if ((pht > t2) && (ht < t2)) {
					ans += hh + "" + m + "ʬ ҳ\n"; //$NON-NLS-1$ //$NON-NLS-2$
                    set[0][7] = hh;
                    set[1][7] = m;
				}
				if ((pht > t1) && (ht < t1)) {
					ans += hh + "" + m + "ʬ ŷʸ\n"; //$NON-NLS-1$ //$NON-NLS-2$
                    set[0][8] = hh;
                    set[1][8] = m;
				}
				pht = ht;
				pdr = dr;
			}
		}
		return ans;
	}

}