#!/usr/bin/env ruby

#------------------------------------------------------------
# suzuran
# 検索CGI (C)2007 suzuran project.
#------------------------------------------------------------

SUZURAN_VERSION = "0.6.0"

require "nkf"
require "cgi"
require "estraierpure"

load "../suzuran.conf"
if RELWORDS_DB != ""
  require "villa"
end

DIR_TEMPLATE = "../template/"
FILE_HTML_TEMPLATE = DIR_TEMPLATE + "default.html"

class Suzuran
  private
  def initialize
    @cgi = CGI.new
    @header = { "type" => "text/html", "charset" => "utf-8", "expires" => Time.now }
    @query = ""
    @query2 = nil
    @query_org = ""
    @radio = [" checked ", ""]
    @radio_selected = 0
    @page = 0
    @list_max = 0
    @list = LIST
    @sort = SORT_TYPE_DEFAULT
    @sort_org = ""
    @user_agent = get_user_agent
    @javascript = check_javascript
    @sort_type = {
      "lank"      => "[SCA]",    # 自動
      "date"  => "@mdate NUMD",  # 日付 (新しい順)
      "-date"  => "@mdate NUMA", # 日付 (古い順)
      "title" => "@title STRA",  # 題名 (昇順)
      "-title" => "@title STRD", # 題名 (降順)
      "size"  => "@size NUMA",   # 文書の長さ (短い順)
      "-size"  => "@size NUMD",  # 文書の長さ (長い順)
      "uri"   => "@uri STRA",    # ホームページアドレス (昇順)
      "-uri"   => "@uri STRD"    # ホームページアドレス (降順)
    }
    if @cgi.key?("radio")
      for i in 0..(@radio.length - 1)
        if cgikey("radio") == i.to_s
          @radio[i] = " checked "
          @radio_selected = i
        else
          @radio[i] = ""
      	end
      end
    end
    @cmd = cgikey("cmd", "search")
    begin
      __send__("cmd_#{@cmd}")
    rescue
      cmd_search
    end
  end

  def cgikey(name, default = "")
    result = default
    if @cgi.key?(name)
      result = @cgi.params[name][0]
      if result != result.to_s
        result = @cgi.params[name][0].read
      end
    end
    result
  end

  # ---------------------------------------- cmd cccc

  def cmd_search
    html = ""
    if cgikey("szquely") != "" or cgikey("query") != ""
      html = make_search
    end
    @cgi.out( @header ) { make_html(html).gsub(/__time__/, (Process.times.utime + Process.times.stime).to_s + "秒") }
  end

  def cmd_advanced
    html = ""
    html = make_advanced
    @cgi.out( @header ) { make_html(html).gsub(/__time__/, (Process.times.utime + Process.times.stime).to_s + "秒") }
  end

  # ---------------------------------------- sub ssss

  def get_user_agent
    result = nil
    user_agent = @cgi.user_agent  
    case user_agent
      when /MSIE (6.0|7.0)/
        result = "IE"
      when /Firefox\/(1|2)/
        result = "FF"
      when /Opera 7/
        result = "OP"
    end
    result
  end

  def check_javascript
    result = nil
    case @user_agent
      when "IE"
        result = "IE"
      when "FF"
        result = "FF"
      when "OP"
        result = "OP"
    end
    result
  end

  def make_phrase(phrase)
    phrase = phrase.gsub(/ /, " AND ")
    phrase = phrase.gsub(/　/, " AND ")
    phrase
  end

  def make_similar(id)
    node = EstraierPure::Node::new
    node.set_url(NODE_URL)    
    doc = node.get_doc(id)
    result = ""
    if doc
        num = 0
      preword = ""
      doc.keywords.each{|word, i|
        result << "WITH " + i + " " + word + " "
      }
      result = "[SIMILAR] 16 1024 4096 " + result
    end
    result
  end

  def attr(s)
    CGI.escapeHTML(s.to_s)
  end

  def url(s)
    CGI.escape(s.to_s)
  end

  def reg_escape(s)
    s.gsub(/\[/, '\[').gsub(/\(/, '\(')
  end

  # ---------------------------------------- make html hhhh

  def get_allkwd(word)
    sum = 0
    allkwd = {}
    begin
      db = Villa::new(RELWORDS_DB)
      terms = word.split(/[ \t]/)
      terms.each do |term|
        next if term.length < 1
        begin
          line = db.get(term)
        rescue
          line = "0"
        end
        fields = line.split(/\t/)
        num = fields.shift.to_i
        sum = sum + num
        diam = 32 / ((num + 8) ** 0.6)
        r_word = Regexp.compile(word)
        counter = -1 
        for i in 0...fields.length
          next if i % 2 > 0
          key = fields[i]
          next if !(r_word =~ key)
          if word == key then next end
          if key.to_s == "eos" then next end
          counter += 1
          if counter > RELWORDS_MAX
            break
          end
          val = fields[i+1].to_i * diam
          cur = allkwd[key]
          allkwd[key] = cur ? cur + val : val
        end
      end
    rescue
    ensure
      db.close if db
    end
    return sum, allkwd
  end  

  def make_related_terms
    result = ""
    if RELWORDS_DB == "" then return "" end
    if @query_org == "." then return "" end
    word = @query_org
    sum, allkwd = get_allkwd(word)
    if sum > 0 && allkwd.size > 0
      result << <<-_HTML
      <div id="relwords">関連検索 : 
      _HTML
      scores = []
      allkwd.each do |key, val|
        scores.push([key, val])
      end
      scores.sort! do |a, b|
        b[1] - a[1]
      end
      i = 0
      scores.each do |elem|
        key = elem[0]
        val = elem[1]
        if i != 0
          result << "- "
        end
        result << <<-_HTML
        <a href="./?szquely=#{url(key)};num=#{attr(@list)}">#{key}</a>
        _HTML
        i += 1
        break if i >= 32
      end
      result << <<-_HTML
      </div>
      _HTML
    end
    result
  end

  def make_form
    result = ""
    if @cmd == "advanced"
      result = <<-_HTML
        <h2 class="title">検索オプション</h2>
      _HTML
    else
      result = make_form_normal
    end
    result
  end

  def check_selected(form_value, cgi_value = @sort_org)
    result = ""
    if cgi_value == form_value
      result = "selected"
    end
    result
  end

  def make_advanced
    result = ""
    get_cgikey
    result = <<-_HTML
    <form method="get" id="searchFormAdvanced" name="searchFormAdvanced" action="./">
    <table cellpadding="5" cellspacing="0" id="advancedTable" summary="検索フォーム">
    <tr bgcolor="#ccccff"><th rowspan="2">検索する文字</th><td>含む文字</td>
        <td><input type="text" name="szquely" size="40" value="#{attr(@query_org)}" id="szquely"></td>
        <td rowspan="2" valign="top"><input type="submit" name="submit" value="検索"></td></tr>
    <tr bgcolor="#ccccff"><td>除く文字</td>
        <td><input type="text" name="query2" size="40" value="" id="query2"></td></tr>
    <tr bgcolor="#ccccff"><td><br></td><td><br></td>
        <td colspan="2">#{make_radio_button}</td></tr>
    <tr><th>表示の順番</th>
        <td colspan="2"><select name="sort">
            <option value="lank"  #{check_selected("lank")}>自動
            <option value="date"  #{check_selected("date")}>日付 (新しい順)
            <option value="-date" #{check_selected("-date")}>日付 (古い順)
            <option value="title" #{check_selected("title")}>題名 (昇順)
            <option value="-title"#{check_selected("-title")}>題名 (降順)
            <option value="size"  #{check_selected("size")}>文書の長さ (短い順)
            <option value="-size" #{check_selected("-size")}>文書の長さ (長い順)
            <option value="uri"   #{check_selected("uri")}>ホームページアドレス (昇順)
            <option value="-uri"  #{check_selected("-uri")}>ホームページアドレス (降順)
           </select></td><td rowspan="2"><br></td></tr>
    <tr><th>表示件数</th>
        <td colspan="2"><select name="num">
            <option value="10" #{check_selected(10, @list)}>&nbsp;&nbsp;10 件
            <option value="20" #{check_selected(20, @list)}>&nbsp;&nbsp;20 件
            <option value="30" #{check_selected(30, @list)}>&nbsp;&nbsp;30 件
            <option value="50" #{check_selected(50, @list)}>&nbsp;&nbsp;50 件
            <option value="100" #{check_selected(100, @list)}>100 件
           </select></td></tr>
    </table>
    </form>
    _HTML
    result
  end

  def make_radio_button
    result = ""
    for i in 0..(@radio.length - 1)
      result << <<-_HTML
        <span class="radio">
          <input type="radio" name="radio" #{@radio[i]} value="#{i}" id="radio#{i}"><label for="radio#{i}">#{RADIO[i]}</label>
        </span>
      _HTML
    end
    result
  end
  
  def make_form_normal
    result = <<-_HTML
      <form method="get" id="searchform" name="searchform" action="./">
      <table summary="検索フォーム">
      <tr>
        <td>
          <strong>検索</strong> 
        </td>
	<td>
          <input type="text" name="szquely" size="40" value="#{attr(@query_org)}" id="szquely">
          <input type="hidden" name="sort" value="#{attr(@sort_org)}">
          <input type="hidden" name="num" value="#{attr(@list)}">
          <input type="hidden" name="cmd" value="search">
          <input type="submit" name="submit" value="検索"> <span id="searchOption">
           <a href="./?cmd=advanced;szquely=#{url(@query_org)};radio=#{attr(@radio_selected)};num=#{attr(@list)};sort=#{attr(@sort_org)}">検索オプション</a></span>
        </td>
      </tr>
      <tr>
      <td><br></td>
      <td>
      #{make_radio_button}
      </td></tr>
      </table> 
      </form>
    _HTML
    result
  end

  def make_navi
    result ="<table cellspacing=\"5\" summary=\"ナビゲーション\"><tr>"
    simid = cgikey("simid")
    if simid != ""
      simid = ";simid=#{attr(simid)}"
    end
    link = "<td><a href=\"./?szquely=#{url(@query_org)}#{attr(simid)};sort=#{attr(@sort_org)};num=#{attr(@list)};radio=#{attr(@radio_selected)};page="
    if @page != 0
      result << <<-_HTML
        <td>#{link + (@page - 1).to_s}"><img src="../img/prev.png" alt="←" border="0"><br>前へ</a></td>
      _HTML
    end
    list_cur = 0
    start = @page -5
    if start < 0
      start = 0
    end
    max = start + 10
    if max > @list_max / @list
      max = @list_max / @list
    end
    if @list_max % @list == 0
      max = max - 1
    end
    if start == max or @list_max == @list
      return ""
    end
    for i in start..max
      if @page == i
        result << "<td>#{(i + 1).to_s}</td>"
      else
        result << "#{link + i.to_s}\">#{(i + 1).to_s}</a></td>"
      end
    end
    if @page < @list_max / @list
      if (@list_max % @list == 0) and (@page + 1 == @list_max / @list)
      else
        result << <<-_HTML
          <td>#{link + (@page + 1).to_s}"><img src="../img/next.png" alt="→" border="0"><br>次へ</a></td>
        _HTML
      end
    end
    result << "</tr></table>"
  end

  def make_footer
    result = ""
    result = HTML_FOOTER
  end

  def make_html(body)
    result = ""
    html = open(FILE_HTML_TEMPLATE).readlines.to_s
    html.each do |l|
      l =~ /(__.*__)/
      if $1
        case $1
          when "__head_title__"
            l.gsub!($1, SEARCH_HEADER_TITLE + " / " + attr(@query_org.to_s))
          when "__title__"
            l.gsub!($1, "")
          when "__head__"
            l.gsub!($1, make_head)
          when "__body__"
            l.gsub!($1, body)
          when "__navi__"
            l.gsub!($1, make_navi)
          when "__footer__"
            l.gsub!($1, make_footer)
          when "__version__"
            l.gsub!($1, "Powered by <a href=\"http://hyperestraier.sourceforge.net/\">Hyper Estraier</a> + suzuran " + SUZURAN_VERSION)
        end
      end
      result << l 
    end
    result
  end
  
  def make_head
    result = <<-_HTML
    <table width="100%" summary="ヘッダ">
      <tr>
        <td valign="top" width="10%"><a href="#{HOMEPAGE}"><img src="../img/title.gif" alt="('-')" border="0"></a></td>
        <td align="left">#{make_form}</td>
      </tr>
    </table>
    _HTML
  end
  
  def make_title(text)
    result = text
    @query_org.split(/ /).each {|s|
      result = result.gsub(Regexp.compile(reg_escape(s)), "<em>" + s + "</em>")
    }
    result
  end

  def make_text(text)
    result = text
    @query_org.split(/ /).each {|s|
      s = NKF.nkf("-Zw80W", s)
      result = result.gsub(Regexp.compile(reg_escape(s.upcase + "\t" + s.downcase)), "<em>" + s + "</em>")
    }
    if !(@cgi.key?("simid"))
      tmp = ""
      line = 0
      result.each{|s|
        if s != "\n"
          tmp << s
        else
          line += 1
          tmp << " ...<br>"
          if line == 1
            tmp << "... "
          end
        end
        if line == 2
          break
        end
      }
      result = tmp
    end
    result
  end

  def make_search_header(nres)
    result = ""
    @list_max = nres.doc_num
    max = @page * @list + @list
    if max > @list_max
      max = @list_max
    end
    if max == 0
      max = @list
    end
    result << <<-_HTML
      <div id="searchHeader">
        <table width="100%" summary="検索結果ヘッダ">
          <tr><td width="40%"><span id="searchHeaderTitle">#{SEARCH_HEADER_TITLE}</span></td>
              <td width="60%" align="right"><span id="searchHeaderMessage">
           <em>#{attr(@query_org)}</em> の検索結果
           #{@page * @list + 1} 〜 #{max}件目
           / #{@list_max.to_s} 件 (__time__)</span></td>
          </tr>
        </table>
      </div>
    _HTML
  end

  def make_sort_link
    result = <<-_HTML
      <div id="sortLink">
      表示順の変更 :
    _HTML
    if @sort_org == "lank"
      result << <<-_HTML
        <a href="./?szquely=#{url(@query_org)};num=#{attr(@list)};sort=numddate;radio=#{attr(@radio_selected)}">更新日順</a>
        - ランク順
      _HTML
    else
      result << <<-_HTML
        更新日順
        - <a href="./?szquely=#{url(@query_org)};num=#{attr(@list)};sort=lank;radio=#{attr(@radio_selected)}">ランク順</a>
     _HTML
    end
    result << "</div>"
  end

  def make_list(nres)
    result = "<div id=\"list\">"
    @page = cgikey("page", 0).to_i
    if @page < 0
      @page = 0
    end
    max = nres.doc_num
    @list_max = max
    if @list_max > 100
      @list_max = 100
    end
    if max > (@page + 1) * @list
      max = (@page + 1) * @list
    end
    if max <= 0
      max = 10
    end
    public_html = Regexp.compile("file:\/\/" + PUBLIC_HTML.gsub(/\//, "\\/"))
    query = Regexp.compile(reg_escape(@query_org))
    for i in @page * @list...max
      rdoc = nres.get_doc(i)
      if !rdoc
        return "<p class='message'><b>#{attr(@query_org)}</b> に一致するページは見つかりませんでした。"
      end
      if rdoc.attr("@title").to_s == ""
        result << <<-_HTML
          <p class="resultTitle"><a href="#{rdoc.attr("@uri").to_s.gsub(public_html, "http://")}">タイトル無し</a></p>
        _HTML
      else
        result << <<-_HTML
          <p class="resultTitle"><a href="#{rdoc.attr("@uri").to_s.gsub(public_html, "http://")}"
          >#{make_title(rdoc.attr("@title").to_s)}</a></p>
        _HTML
      end
      result << <<-_HTML
        <p class="resultText">
        #{make_text(rdoc.snippet)}
        </p>
        <p class="resultUri">
        #{rdoc.attr("@uri").to_s.gsub(/file:\/\/\/home\/search-j\//, "http://")}
        ( #{(rdoc.attr("@size").to_i / 1000.0).ceil.to_s}k )
        <span class="resultSimilar"> - 
        <a href="./?szquely=#{url(@query_org)};num=#{attr(@list)};sort=#{attr(@sort_org)};simid=#{rdoc.attr("@id")};radio=#{attr(@radio_selected)}">類似ページ</a>
        </span>
        </p>
      _HTML
    end
    result << "</div>#{make_sort_link}"
  end

  def get_cgikey
    if cgikey("query") != ""
      @query_org = NKF.nkf("-w80", cgikey("query")).gsub(/　/, " ").gsub(/\\/, "\\\\\\\\").gsub(/^ /, "")
    elsif cgikey("szquely") != ""
      @query_org =  NKF.nkf("-w80", cgikey("szquely")).gsub(/　/, " ").gsub(/\\/, "\\\\\\\\").gsub(/^ /, "")
    end
    if @cgi.key?("query2")
      @query2 = cgikey("query2")
      if @query2 == ""
        @query2 = nil
      else
        @query2_org = @query2
        @query2 = " ANDNOT " + @query2.gsub(/ /, " ANDNOT ").gsub(/　/, " ANDNOT ")
      end
    end  
    if @cgi.key?("simid")
      @query = make_similar(cgikey("simid"))
    else
      @query = make_phrase(@query_org) + @query2.to_s
    end
    if @cgi.key?("num")
      @list = cgikey("num").to_i
      if @list <= 0 or @list > 100
        @list = 10
      end
    end
    if @cgi.key?("sort")
      if @sort_type[cgikey("sort")]
        @sort_org = cgikey("sort")
        @sort = @sort_type[cgikey("sort")]
      else
        @sort = SORT_TYPE_DEFAULT
      end
    end
  end

  def make_search
    # 検索条件式 一覧
    # http://hyperestraier.sourceforge.net/uguide-ja.html#searchcond
    result = ""
    option = ""
    get_cgikey
    node = EstraierPure::Node::new
    node.set_url(NODE_URL)
    cond = EstraierPure::Condition::new
    cond.add_attr(SEARCH_OPTION[@radio_selected])
    cond.set_max(SEARCH_MAX)
    cond.set_phrase(@query)
    cond.set_order(@sort)
    nres = node.search(cond, 0);
    if nres
      result << make_list(nres)
    else
      result << printf("error: %d\n", node.status)
    end
    result = make_search_header(nres) + make_related_terms + result
    result
  end


end


Suzuran.new
