/*
 * Decompiled with CFR 0.152.
 */
package net.jankenpoi.sudokuki.ui.swing;

import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.concurrent.ExecutionException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingWorker;
import net.jankenpoi.i18n.I18n;
import net.jankenpoi.sudokuki.view.GridView;

public class GridGenerationDialog
extends JDialog {
    private JFrame parent;
    private final GridView view;
    private final SwingWorker<Integer, Void> worker;

    public GridGenerationDialog(JFrame jFrame, GridView gridView) {
        super((Frame)jFrame, true);
        this.parent = jFrame;
        this.view = gridView;
        this.setResizable(false);
        short[] sArray = new short[81];
        for (int i = 0; i < 9; ++i) {
            for (int j = 0; j < 9; ++j) {
                if (!gridView.isCellReadOnly(i, j)) continue;
                sArray[9 * i + j] = gridView.getValueAt(i, j);
            }
        }
        this.worker = new SwingWorker<Integer, Void>(){

            @Override
            protected Integer doInBackground() {
                return GridGenerationDialog.this.generateGrid();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void done() {
                try {
                    this.get();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                    return;
                }
                catch (ExecutionException executionException) {
                    executionException.printStackTrace();
                    return;
                }
                finally {
                    GridGenerationDialog.this.dispose();
                }
            }
        };
        this.initComponents();
        this.worker.execute();
    }

    private void initComponents() {
        this.setDefaultCloseOperation(2);
        Container container = this.getContentPane();
        GridLayout gridLayout = new GridLayout(3, 1);
        container.setLayout(gridLayout);
        JLabel jLabel = new JLabel("<html><table border=\"0\"><tr>" + I18n.gtxt("Generating grid...") + "</tr>" + "</html>");
        JLabel jLabel2 = new JLabel("");
        JButton jButton = new JButton(I18n.gtxt("Please wait..."));
        jButton.setEnabled(false);
        jButton.setHorizontalTextPosition(0);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GridGenerationDialog.this.clickedCancel();
            }
        });
        container.add(jLabel);
        container.add(jLabel2);
        FlowLayout flowLayout = new FlowLayout(1);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(flowLayout);
        jPanel.add(jButton);
        container.add(jPanel);
        this.pack();
        this.setLocationRelativeTo(this.parent);
    }

    private void clickedCancel() {
        this.dispose();
    }

    private Integer generateGrid() {
        this.view.getController().notifyNewGridRequested();
        return 0;
    }
}

