/*
 * Decompiled with CFR 0.152.
 */
package net.jankenpoi.sudokuki.ui.swing;

import java.awt.Frame;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import net.jankenpoi.i18n.I18n;
import net.jankenpoi.sudokuki.ui.swing.SelectMemosPanel;
import net.jankenpoi.sudokuki.ui.swing.SelectNumberPanel;

public class DualSelectionDialog
extends JDialog {
    private SelectNumberPanel numberPanel;
    private SelectMemosPanel memosPanel;
    private JTabbedPane tabbedPane = new JTabbedPane();
    private int value = -1;
    private byte[] memos = null;

    public DualSelectionDialog(boolean bl, JFrame jFrame, byte by, Byte[] byteArray) {
        super((Frame)jFrame, true);
        this.numberPanel = new SelectNumberPanel(this, by);
        this.memosPanel = new SelectMemosPanel(this, byteArray);
        this.tabbedPane.addTab(I18n.gtxt("Select"), this.numberPanel);
        this.tabbedPane.addTab(I18n.gtxt("Memos"), this.memosPanel);
        this.tabbedPane.setSelectedComponent(bl ? this.numberPanel : this.memosPanel);
        this.add(this.tabbedPane);
        this.pack();
        this.setResizable(false);
    }

    JTabbedPane getTabbedPane() {
        return this.tabbedPane;
    }

    public byte[] getSelectedMemos() {
        return this.memos;
    }

    public int getClickedDigit() {
        return this.value;
    }

    void memosPanelConfirmed() {
        this.memos = this.memosPanel.getSelectedMemos();
        if (this.memosPanel.memosChanged()) {
            this.value = 0;
        }
        this.dispose();
    }

    public void numberPanelConfirmed() {
        this.value = this.numberPanel.getClickedDigit();
        this.memos = null;
        this.dispose();
    }

    public void memosPanelEscaped() {
        this.inputCancelled();
    }

    public void numberPanelEscaped() {
        this.inputCancelled();
    }

    private void inputCancelled() {
        this.value = -1;
        this.memos = null;
        this.dispose();
    }
}

