/*
 * Decompiled with CFR 0.152.
 */
package net.jankenpoi.sudokuki.ui.swing;

import java.util.Locale;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import net.jankenpoi.i18n.I18n;
import net.jankenpoi.i18n.LocaleListener;
import net.jankenpoi.sudokuki.ui.L10nComponent;
import net.jankenpoi.sudokuki.ui.swing.ActionsRepository;
import net.jankenpoi.sudokuki.ui.swing.LocaleListenerImpl;
import net.jankenpoi.sudokuki.ui.swing.ResolveAction;
import net.jankenpoi.sudokuki.ui.swing.SetAllMemosAction;
import net.jankenpoi.sudokuki.ui.swing.SetMemosHereAction;
import net.jankenpoi.sudokuki.ui.swing.StockIcons;
import net.jankenpoi.sudokuki.view.GridView;

public class CheatMenu
extends JMenu
implements L10nComponent {
    private final LocaleListener localeListener;
    private final JMenuItem itemSetMemosHere = new JMenuItem();
    private final JMenuItem itemSetAllMemos = new JMenuItem();
    private final JMenuItem itemResolve = new JMenuItem();
    private final Action actionSetMemosHere;
    private final Action actionSetAllMemos;
    private final Action actionResolve;

    @Override
    public void setL10nMessages(Locale locale, String string) {
        this.setText(I18n.gtxt("Solution..."));
        this.setIcon(StockIcons.ICON_SOLUTION_MENU);
        this.itemSetMemosHere.setText(I18n.gtxt("Memos"));
        this.actionSetMemosHere.putValue("ShortDescription", I18n.gtxt("Set memos"));
        this.itemSetAllMemos.setText(I18n.gtxt("All memos"));
        this.actionSetAllMemos.putValue("ShortDescription", I18n.gtxt("Set memos in all cells"));
        this.itemResolve.setText(I18n.gtxt("Resolve"));
        this.actionResolve.putValue("SmallIcon", StockIcons.ICON_GO_JUMP);
        this.actionResolve.putValue("ShortDescription", I18n.gtxt("Resolve the grid"));
        this.actionResolve.putValue("MnemonicKey", new Integer(82));
    }

    public CheatMenu(ActionsRepository actionsRepository, JFrame jFrame, GridView gridView) {
        this.actionSetMemosHere = new SetMemosHereAction(I18n.gtxt("Memos"), StockIcons.ICON_SET_MEMOS_HERE, I18n.gtxt("Set memos"), new Integer(84), gridView);
        actionsRepository.put("SetMemosHere", this.actionSetMemosHere);
        this.actionSetAllMemos = new SetAllMemosAction(I18n.gtxt("All memos"), StockIcons.ICON_SET_ALL_MEMOS, I18n.gtxt("Set memos in all cells"), new Integer(88), gridView);
        actionsRepository.put("SetAllMemos", this.actionSetAllMemos);
        this.actionResolve = new ResolveAction(jFrame, I18n.gtxt("Resolve"), StockIcons.ICON_GO_JUMP, I18n.gtxt("Resolve the grid"), new Integer(82), gridView);
        actionsRepository.put("ResolveGrid", this.actionResolve);
        this.addItems();
        this.setEnabled(true);
        this.setL10nMessages(null, I18n.gtxt("DETECTED_LANGUAGE"));
        this.localeListener = new LocaleListenerImpl(this);
        I18n.addLocaleListener(this.localeListener);
    }

    private void addItems() {
        this.itemSetMemosHere.setAction(this.actionSetMemosHere);
        this.add(this.itemSetMemosHere);
        this.itemSetAllMemos.setAction(this.actionSetAllMemos);
        this.add(this.itemSetAllMemos);
        this.addSeparator();
        this.itemResolve.setAction(this.actionResolve);
        this.add(this.itemResolve);
    }
}

