////////////////////////////////////////////////////////////////////////////////
// sudokuki - C++ graphical sudoku game                                       //
// Copyright (C) 2007-2009 Sylvain Vedrenne                                   //
//                                                                            //
// This program is free software; you can redistribute it and/or              //
// modify it under the terms of the GNU General Public License                //
// as published by the Free Software Foundation; either version 2             //
// of the License, or (at your option) any later version.                     //
//                                                                            //
// This program is distributed in the hope that it will be useful,            //
// but WITHOUT ANY WARRANTY; without even the implied warranty of             //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              //
// GNU General Public License for more details.                               //
//                                                                            //
// You should have received a copy of the GNU General Public License along    //
// with this program; if not, write to the Free Software Foundation, Inc.,    //
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.              //
////////////////////////////////////////////////////////////////////////////////
#include <string.h>//std::memcpy
#include "solver.hh"
#include "grid.hh"
#include "tst_grid.hh"
#include "tst_solver.hh"
/*****************************************************************************/
#define MAX_ITER_NB 20000
#define SOLVER_TABLE_COMPLETE_TRACE 0
#define SOLVER_ITERATION_TRACES 0

/* use this to configure local traces */
#define TRACES_SOLVER_CC 0

/* use this to deactivate local traces when ALL_TRACES is defined */
#define NO_TRACES_SOLVER_CC 1

#if (ALL_TRACES/*defined in sudokukimm.h*/ ||TRACES_SOLVER_CC)&&!NO_TRACES_SOLVER_CC
#define DBGM_TRACES 1
#else
#define DBGM_TRACES 0
#endif
#include "../dbgm_traces.h"

//#define DBGM ;
//#define DBGF ;

int
solver::resolve()
{
	// DONE: des qu'une cellule est vide mais n'a plus de valeur possible: IMPASSE!!!

	DBGM("solver::resolve()............................................................");
	short* p_cur = m_pmem; // location in memory of 1st grid <- current grid
	short* p_next = p_cur + grid_len; // 2nd grid <- next grid

	memcpy( p_next, p_cur, grid_len*sizeof(short) ); // 1

	DBGF("grid_len: %d", grid_len);

	p_cur = p_next; // 2
	grid* p_gr_cur;
	p_gr_cur = new grid( p_cur, false );// create a grid at cur. pos (without memory re-init)

	for( int iter=1; iter < MAX_ITER_NB; iter++ ) {
#if SOLVER_ITERATION_TRACES
		DBGF("iteration:%d", iter);
#endif

		short cur_li, cur_co, dummy_nb, val;
		int res;

		res = p_gr_cur->pop_min_poss_cell(&cur_li, &cur_co, &dummy_nb); // 3, 4
		// =>the "current cell" (cur_li,cur_co) has the min dummy_nb of poss values
		DBGF("res:%d min poss nb of vals %d in cell(%d,%d)", res, dummy_nb, cur_li, cur_co);
		//	assert( 1 == res ); // TODO: traiter le cas où pas de cellule (valide) trouvée avec val min: IMPASSE!
		if ( 2 == res ) {
#if SOLVER_TABLE_COMPLETE_TRACE
			DBGF("\nTABLE COMPLETE (iteration:%d)", iter);
			tst_grid tst_cur_grid( p_gr_cur );
			tst_cur_grid.dump();
#endif
			m_pcur_grid = p_cur; // used in current_grid_values_get()
			return 1;
		} else
			if ( 3 == res ) {
				// DEAD-END
				DBGM("DEAD-END found in min_poss_cell_pop(). Go back 1 position...");
				p_cur = p_cur - grid_len;
				delete p_gr_cur;
				p_gr_cur = new grid( p_cur, false );
				continue;
			} else

				// THIS PART IS BUGGY, NOT WORKING. FIX IT AND MAKE IT WORK!////////////////////////////////
				if ( 1 != res ) {
					assert( false ); /////////// execution never arrives here ///////////////////////////

					p_cur = p_cur - grid_len;
					delete p_gr_cur;
					p_gr_cur = new grid( p_cur, false );
					DBGM("IMPASSE - retour arriere d'une position...(; continue;)");
					continue;
				}///////////////////////////////////////////////////////////////////////////////////////////

		int res_value_pop;
		res_value_pop = p_gr_cur->pop_value(cur_li, cur_co, &val); // 5
		// =>popped an available value val from the "current cell" in the current grid
		assert ( 1 == res_value_pop );
		DBGF("popped val: %d", val);
		delete p_gr_cur;
		DBGM("after delete p_gr_cur;");




		p_next = p_cur + grid_len; // 6
		memcpy( p_next, p_cur, grid_len*sizeof(short) ); // 6
		DBGM("after memcpy( p_next, p_cur, grid_len*sizeof(short) ); // 6");
		p_gr_cur = new grid( p_cur, false ); // 7
		DBGM("before cell_value_screen");
		p_gr_cur->screen_cell_value(cur_li, cur_co, val); // 7
		delete p_gr_cur;

		p_next = p_cur + grid_len; // 8
		p_cur = p_next; // 8
		p_gr_cur = new grid( p_cur, false ); // 8

		assert ( 1 <= val && val <= 9 );
		assert ( 0 <= cur_li && cur_li <= 9 );
		assert ( 0 <= cur_co && cur_co <= 9 );
		int res_value_set = p_gr_cur->set_cell_value(cur_li, cur_co, val);

#if SOLVER_ITERATION_TRACES
		tst_grid tst_cur_grid( p_gr_cur );
		tst_cur_grid.dump();
#endif

		if ( 3 == res_value_set /* impasse */ ) {
			p_cur = p_cur - grid_len;
			delete p_gr_cur;
			p_gr_cur = new grid( p_cur, false );
			DBGM("solver::resolve() IMPASSE - retour arriere d'une position...(3 == res_value_set /* impasse */)");

#if SOLVER_ITERATION_TRACES
			tst_grid tst_cur_grid( p_gr_cur );
			tst_cur_grid.dump();
#endif
		}

	}
	return -10;
}
/*****************************************************************************/
std::map<int, int>
solver::get_current_grid_values()
{
	std::map<int, int> tmp_map;

	grid cur_grid( m_pcur_grid, false );
	for ( int li=0; li<9; li++ ) {
		for ( int co=0; co<9; co++ ) {
			int value = cur_grid.get_value_in_cell(li, co);
//			tmp_map.insert( std::pair<int, int>(100+li*10+co, value ));
			tmp_map.insert( std::pair<int, int>(li*9+co, value ));
		}
	}

	return tmp_map;
}
/*****************************************************************************/
int
solver::get_cell_value( int li, int co )
{
	grid tmp_grid_1( m_pmem, false );// temporary object used to READ in the solver memory

	int value = tmp_grid_1.get_value_in_cell( li, co );
	DBGF("cell_value_get(%d,%d):%d\n", li, co, value);
	return value;
}
/*****************************************************************************/
