////////////////////////////////////////////////////////////////////////////////
// sudokuki - C++ graphical sudoku game                                       //
// Copyright (C) 2007-2009 Sylvain Vedrenne                                   //
//                                                                            //
// This program is free software; you can redistribute it and/or              //
// modify it under the terms of the GNU General Public License                //
// as published by the Free Software Foundation; either version 2             //
// of the License, or (at your option) any later version.                     //
//                                                                            //
// This program is distributed in the hope that it will be useful,            //
// but WITHOUT ANY WARRANTY; without even the implied warranty of             //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              //
// GNU General Public License for more details.                               //
//                                                                            //
// You should have received a copy of the GNU General Public License along    //
// with this program; if not, write to the Free Software Foundation, Inc.,    //
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.              //
////////////////////////////////////////////////////////////////////////////////
#ifndef _HH_PLAYER_HH_
#define _HH_PLAYER_HH_

#include <iostream>
#include <assert.h>
#include <map>
#include "grid_tool.hh"

using namespace std;

class player : virtual public grid_tool {

public:
	player() {
//		printf("[%s/%s]%s\n", __FILE__, __func__, "");
	};
	virtual ~player() {
//		printf("[%s/%s]%s\n", __FILE__, __func__, "");
	};
	void init( const string grid_str );

	int get_cell_value( int li, int co );
	int set_cell_value( int, int, int );

	bool go_back_one_grid();
	int get_current_grid_index();
	std::map<int, int> get_current_grid_values();
	std::string get_current_grid_values_string();
	int fill_additional_moves( std::string );
	bool is_cell_empty( int li, int co );
	bool is_value_possible( int li, int co, int val );

private:
	int m_cur_grid_idx;

//	int dummy() { return 0;}
};

#endif //_HH_PLAYER_HH_
