////////////////////////////////////////////////////////////////////////////////
// sudokuki - C++ graphical sudoku game                                       //
// Copyright (C) 2007-2009 Sylvain Vedrenne                                   //
//                                                                            //
// This program is free software; you can redistribute it and/or              //
// modify it under the terms of the GNU General Public License                //
// as published by the Free Software Foundation; either version 2             //
// of the License, or (at your option) any later version.                     //
//                                                                            //
// This program is distributed in the hope that it will be useful,            //
// but WITHOUT ANY WARRANTY; without even the implied warranty of             //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              //
// GNU General Public License for more details.                               //
//                                                                            //
// You should have received a copy of the GNU General Public License along    //
// with this program; if not, write to the Free Software Foundation, Inc.,    //
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.              //
////////////////////////////////////////////////////////////////////////////////
#include <string.h>//std::memcpy
#include "grid_tool.hh"
#include "grid.hh"
//#include "tst_grid.hh"
/*****************************************************************************/
/* use this to configure local traces */
#define TRACES_GRID_TOOL_CC 0
#define GRID_COMPLETE_TRACES 0

/* use this to deactivate local traces when ALL_TRACES is defined */
#define NO_TRACES_GRID_TOOL_CC 1

#if (ALL_TRACES/*defined in sudokukimm.h*/ ||TRACES_SOLVER_CC)&&!NO_TRACES_SOLVER_CC
#define DBGM_TRACES 1
#else
#define DBGM_TRACES 0
#endif
#include "../dbgm_traces.h"

short char2short( const char car )
{
	short tmp_short = car - '0';

	if ( 1<=tmp_short && tmp_short<=9 ) {
		return tmp_short; // cell with a value (1..9)
	} else {
		return short(VAL::EMPTY);
	}
}
/*****************************************************************************/
void
grid_tool::init( const string grid_str )
{
	DBGM("grid_tool::init");
	DBGF("grid_tool::init(..) grid_str.length() : %d", grid_str.length());
	assert( nb_lines*nb_cols <= (int)grid_str.length() );

	// fill the grid_tool memory with values VAL::UNUSED everywhere
	std::fill( m_pmem, m_pmem + nb_grids*grid_len, short(VAL::UNUSED) );

	fill_1st_grid( grid_str );
	m_pcur_grid = m_pmem;
	DBGM("end of grid_tool::init\n");
}
/*****************************************************************************/
int
grid_tool::fill_1st_grid( const string grid_str )
{
	// Writes in the grid_tool memory at the first grid position, using the string grid_str

	// temporary object used to write in the grid_tool memory (with prior memory init!)
	grid tmp_grid_1( m_pmem );
	m_number_of_filled_cells = 0; // there has been a prior memory init, so at the moment the grid is empty

	for ( int li=0; li<nb_lines; li++ ) {
		for ( int co=0; co<nb_cols; co++ ) {
			short tmp_int = char2short( grid_str[ nb_cols*li + co ] );
			if ( 0 < tmp_int ) { // this cell is not to be empty
				assert(	0 != tmp_grid_1.set_cell_value( li, co, tmp_int ) );
				m_number_of_filled_cells++;
				DBGF("grid_tool.cc::fill_1st_grid m_number_of_filled_cells++ => %d", m_number_of_filled_cells);
			}
		}
	}

#if GRID_COMPLETE_TRACES
	tst_grid tst_grid_1( &tmp_grid_1 );
	tst_grid_1.dump();
#endif

	DBGM("\n END OF FILL 1ST GRID \n");
	return 1;
}
/*****************************************************************************/
