////////////////////////////////////////////////////////////////////////////////
// sudokuki - C++ graphical sudoku game                                       //
// Copyright (C) 2007-2009 Sylvain Vedrenne                                   //
//                                                                            //
// This program is free software; you can redistribute it and/or              //
// modify it under the terms of the GNU General Public License                //
// as published by the Free Software Foundation; either version 2             //
// of the License, or (at your option) any later version.                     //
//                                                                            //
// This program is distributed in the hope that it will be useful,            //
// but WITHOUT ANY WARRANTY; without even the implied warranty of             //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              //
// GNU General Public License for more details.                               //
//                                                                            //
// You should have received a copy of the GNU General Public License along    //
// with this program; if not, write to the Free Software Foundation, Inc.,    //
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.              //
////////////////////////////////////////////////////////////////////////////////
#ifndef _HH_GRID_HH_
#define _HH_GRID_HH_

#include <assert.h>
#include <string>

static unsigned short nb_grids = 82; // 82 grids in a solver = max number possible
static unsigned short nb_flags = 12;
static unsigned short nb_lines = 9;
static unsigned short nb_cols = 9;
static unsigned short grid_len = nb_flags*nb_lines*nb_cols;

namespace VAL {
enum {
	EMPTY = -1, // initial value after a grid (inside solver memory) was initialized
	UNUSED = -2, // initial value after solver memory was initialized, value for unused grid
	SCREENED = 0 // REALLY USED ?????
};
}

class grid {
	friend class tst_grid;
public:
	inline grid( short* pbeg, bool grid_init = true )
	{
		m_pstart = pbeg;

		if ( grid_init) {
			m_possibles_min = 9;
			// init grid with  "-1"  everywhere
			std::fill( m_pstart, m_pstart + grid_len, short(VAL::EMPTY) );
			for ( int i=0; i<nb_grids; i++) {
				*(m_pstart + 10 + i*12) = 9; // 9 possible values for each cell
			}
		} else {
			// the grid now points to the memory located at pbeg
			// without memory initialization.
		}
	}

	int pop_min_poss_cell( short* li, short* co, short* nb );
	int pop_value( short li, short co, short* nb );

	int is_cell_free( const short li, const short co );
	bool is_cell_filled( const short li, const short co );

	int set_cell_value( const short li, const short co, const short val );
	int screen_cell_value( const short li, const short co, const short val );
	int is_cell_tried( const short li, const short co );
	short cell_poss_nb( const short li, const short co );

	int is_value_available( const short li, const short co, const short val );
	int is_value_screened( const short li, const short co, const short val );

	short int get_value_in_cell(const short li, const short co);
private:
	short* cell( const short li, const short co );

	short m_possibles_min; // minimum number of possible values for a cell in the grid
	short* m_pstart; // pointer to the first short in the grid's memory

	grid() { assert(false); }; // unused
};

#endif //_HH_GRID_HH_
