////////////////////////////////////////////////////////////////////////////////
// sudokuki - C++ graphical sudoku game                                       //
// Copyright (C) 2007-2009 Sylvain Vedrenne                                   //
//                                                                            //
// This program is free software; you can redistribute it and/or              //
// modify it under the terms of the GNU General Public License                //
// as published by the Free Software Foundation; either version 2             //
// of the License, or (at your option) any later version.                     //
//                                                                            //
// This program is distributed in the hope that it will be useful,            //
// but WITHOUT ANY WARRANTY; without even the implied warranty of             //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              //
// GNU General Public License for more details.                               //
//                                                                            //
// You should have received a copy of the GNU General Public License along    //
// with this program; if not, write to the Free Software Foundation, Inc.,    //
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.              //
////////////////////////////////////////////////////////////////////////////////
#if DISABLE_NLS
#define _(STR) STR
#else
#include <glibmm/i18n.h>
#endif/*DISABLE_NLS*/
#include <gtkmm/main.h>
#include "sudokukimm.h"

/* use this to configure local traces */
#define TRACES_MAINMM_CC 0

/* use this to deactivate local traces when ALL_TRACES is defined */
#define NO_TRACES_MAINMM_CC 1

#if (ALL_TRACES/*defined in sudokukimm.h*/ ||TRACES_MAINMM_CC)&&!NO_TRACES_MAINMM_CC
#define DBGM_TRACES 1
#else
#define DBGM_TRACES 0
#endif
#include "../dbgm_traces.h"


int main (int argc, char *argv[])
{
#if !(DISABLE_NLS)
#if	__SUDOKUKI_WIN32__
	bindtextdomain(PACKAGE, "locale");
#else/*__SUDOKUKI_WIN32__*/
	bindtextdomain(PACKAGE, LOCALEDIR);
#endif/*__SUDOKUKI_WIN32__*/
	bind_textdomain_codeset(PACKAGE, "UTF-8");
	textdomain(PACKAGE);
#endif/*!(DISABLE_NLS)*/

	Gtk::Main kit(argc, argv);
	{
        /* Change language */ //setenv ("LANGUAGE", "eo", 1);
//        Glib::setenv("LANGUAGE", "eo", true);
//        /* Make change known.  */
//        {
//          extern int  _nl_msg_cat_cntr;
//          ++_nl_msg_cat_cntr;
//        }
		std::cout << "Sudokuki starting with language: " << _("DETECTED_LANGUAGE") << "\n";
		Sudokukimm sudokukimm( _("DETECTED_LANGUAGE") );

		sudokukimm.run();
		cout << "Sudokuki, " << _("Goodbye!\n");
	}

#if __SUDOKUKI_WIN32__
	//  system("PAUSE");
#endif/*__SUDOKUKI_WIN32__*/
	return 0;
}
