/* REXX */

if arg() = 0 then do
say ''
say 'GZIPDATE.REX -- view or touch .gz file''s stored internal *nix date'
say '( requires Regina or BRexx )'
say ''
say 'gzipdate [-t] myfile.tgz'
say ''
say '-t   touch (else only views internal date; uses external TOUCH.COM)'
say ''
exit 255
end

parse arg option filename
parse version ver

if pos('Regina',ver) = 0 & pos('brexx',ver) = 0 then do
say ''
say 'Regina or BRexx required!'
exit 1
end

if option \= '-t' then filename = option

if filename = '' then do
say ''
say 'No .GZ file specified!'
exit 2
end

ch = charin(filename,1,2)
if ch \= '1f'x || '8b'x then do
say ''
say 'Not a valid .GZ file!'
exit 3
end

ch = charin(filename,5,4)
mydate = c2d(reverse(ch))

if pos('Regina',ver) \= 0 then ,
newdate = date('U',mydate,'T')     /* Unix->USA, not ANSI !! */

if pos('brexx',ver) \= 0 then do
if import('dates.r') = 0 then do
newdate = GMTime(mydate)
newdate = delstr(newdate,pos(' ',newdate))
parse var newdate year 5 6 monthday
newdate = monthday'/'year
end
else do
say ''
say 'Can''t find BRexx''s dates.r'
exit 4
end
end

say newdate   /* Regina: 02/21/10  BRexx: 2/21/2010 */

/*
using Kris Heidenstrom's TOUCH.COM for FreeDOS
http://www.ibiblio.org/pub/micro/pc-stuff/freedos/files/distributions/...
      /1.0/pkgs/touch[xs].zip
*/

if option = '-t' then do
'dir' filename
'touch' newdate filename
'dir' filename
end

/* EOF */
