;-----------------------------------------------------------------------------
; name		: TEDATA.ASM
; object	: Tiny Editor - initialized data
; type		: include file
; version	: 1.7
; date		: Feb 20, 2000
; author	: J R Ferguson
;-----------------------------------------------------------------------------


xhelp:
;	....v....1....v....2....v....3....v....4....v....5....v....6....v....7....v....
h01 db 2
    db '			TE v1.7 COMMAND SUMMARY',cr,3
h02 db '<Up>	^E  line up	    <F1>   ^J  help		  ^KH hide block',cr
h03 db '<Dn>	^X  line down	    <F2>   ^KS save & resume	  ^KC copy block',cr
h04 db '<Lft>	^S  char left	    <F3>       load new file	  ^KV move block',cr
h05 db '<Rgt>	^D  char right	    <F4>   ^KX save & exit	  ^KY delete block',cr
h06 db '<PgUp>	^R  page up	    <F5>   ^QF find text	  ^KP print block',cr
h07 db '<PgDn>	^C  page down	    <F6>   ^QA find/replace	  ^KR read block',cr
h08 db '^<Up>	^W  scroll up	    <F7>   ^KB begin block	  ^KW write block',cr
h09 db '^<Dn>	^Z  scroll down	    <F8>   ^KK end block	  ^KT mark word',cr
h10 db '<Home>	    to begin line   <F9>   ^KM mark line	  ^Kn set marker n',cr
h11 db '<End>	    to end of line  <F10>  ^K\ repeat line	  ^Qn to marker n',cr
h12 db '^<Home>	^QE to screen top   	   ^KA move line up	  ^QP to last position',cr
h13 db '^<End>	^QX to screen end	   ^KZ move line down	  ^QV to pre-find pos',cr
h14 db '^<PgUp>	^QR to top of file  <ESC>  ^U  abort command	  ^QB to begin block',cr
h15 db '^<PgDn>	^QC to end of file  <Ins>  ^V  insert on/off	  ^QK to end block',cr
h16 db '<Del>	^G  delete char	    <BS>   ^H  delete char left	  ^L  repeat find/repl',cr
h17 db '^<Lft>	^A  word left		   ^Y  delete line	  ^QU undelete chars',cr
h18 db '^<Rgt>	^F  word right		   ^QY delete line right  ^QL undelete line',cr
h19 db '	^T  delete word	    ^Q<BS> ^QH delete line left	  ^KU undelete block',cr
h20 db '	^N  insert new line	   ^QS window left	  ^QG goto line number',cr
h21 db '	^P  insert literal	   ^QD window right	  ^KD file menu',cr
h22 db '	^K] trim block		   ^B  reformat paragraph ^KQ quit (no save)',cr
h23 db '',cr,2
h24 db 'Press O for text formatting options	     Any other key to resume edit mode '
;	....v....1....v....2....v....3....v....4....v....5....v....6....v....7....v....
    db 0

		page
xhelpfmt:
;	....v....1....v....2....v....3....v....4....v....5....v....6....v....7....v....
o01 db 2
    db '			TEXT FORMATTING OPTIONS',cr,3
o02 db cr
o03 db '^OD	Control display : '
ocd db 'Off',cr
o04 db '^O]	Strip blanks	: '
ost db 'Off',cr
o05 db '^QI	Auto-indent	: '
oai db 'Off',cr
o06 db cr
o07 db '^OW	Word wrap	: '
oww db 'Off',cr
o08 db '^OJ	Justification	: '
ojs db 'On ',cr
o09 db '^OL	Left margin	: '
oml db '1   ',cr
o10 db '^OR	Right margin	: '
omr db '79  ',cr
o11 db '^OI	Copy margins from cursor line',cr
o12 db cr
o13 db cr
o14 db cr
o15 db cr
o16 db cr
o17 db cr
o18 db cr
o19 db cr
o20 db cr
o21 db cr
o22 db cr
o23 db cr,2
o24 db '			Press any key to resume edit mode '
;	....v....1....v....2....v....3....v....4....v....5....v....6....v....7....v....
    db 0

		page
xfkeys		db	'    '
		db	'F1',	2,'HELP',	1,' '
		db	'2',	2,'SAVE',	1,' '
		db	'3',	2,'LOAD',	1,' '
		db	'4',	2,'EXIT',	1,' '
		db	'5',	2,'FIND',	1,' '
		db	'6',	2,'REPLACE',	1,' '
		db	'7',	2,'BEG BLK',	1,' '
		db	'8',	2,'END BLK',	1,' '
		db	'9',	2,'MARK LN',	1,' '
		db	'10',	2,'REPT LN',	1
		db	0

;Status messages
xstaidn		db	'TE v1.6  ',0		;default
xstawait	db	'WAIT     ',0
xstaread	db	'READ ERR ',0
xstawrite	db	'WRITE ERR',0
xstanfd		db	'NOT FOUND',0
xstamem		db	'MEM FULL ',0
xstatrimoff	db	'STRIP OFF',0
xstatrimon	db	'STRIP ON ',0
xstaindtoff	db	'NO INDENT',0
xstaindton	db	'INDENT ON',0
xstajustoff	db	'JUST OFF ',0
xstajuston	db	'JUSTIFY  ',0
xstawrapon	db	'WRAP ON  ',0
xstawrapoff	db	'WRAP OFF ',0
xstactrlit	db	'CONTR LIT',0
xstactrwst	db	'CONTR ^x ',0
xstactroff	db	'CONTR OFF',0
xstalrmar	db	'MARGINS  ',0

;Status info line
xstatus		db	2			;invers video attrib
xstamsg		db	'         '		;status message
		db	' L'
xstarow		db	'    '			;line nr
xstarowsiz	equ	$ - xstarow
xstarowov	db	' '			;overflow mark
		db	'C'
xstacol		db	'    '			;column nr
xstacolsiz	equ	$ - xstacol
xsatcolov	db	' '			;overflow mark
xstachg		db	' '			;change mark
xstafsp		db	maxfsp dup(' ')		;filespec
		db	' '
xstains		db	'Ins'			;insert/delete
		db	1			;normal video attrib
		db	0

xOn		db	'On ',0
xOff		db	'Off',0
xctrwst		db	'^x ',0
xctrlit		db	'Lit',0
xinsmode	db	'Ins',0
xovrmode	db	'Ovr',0

xrfsp		db	'Filespec too long',0
xrmem		db	'Out of memory',0
xrread		db	'Read error',0
xexit		db	'Exit. '
xsave		db	'Save as: ',0
xwrite		db	'Save block as: ',0
xabandon	db	'Abandon work. '
xload		db	'Load file: ',0
xread		db	'Read file: ',0
xquit		db	'Quit',0
xdot		db	'. ',0
xdiscard	db	'Lose changes',0
xlnr		db	'Go to line: ',0
xfind		db	'Find: ',0
xrepl		db	'Replace by: ',0
xfindopt	db	'Options: ',0
xexist		db	'File exists, overwrite',0
xyesno		db	' ? [Y/n] ',0
xnoyes		db	' ? [y/N] ',0
xfmnu		db	'<S>ave  <L>oad  <N>ew  <Q>uit  <E>xit : ',0
xlftmar		db	'Left margin (ESC = cur col) : ',0
xrgtmar		db	'Right margin (ESC = cur col) : ',0
exttmp		db	'.$$$',0
extbak		db	'.BAK',0

attrnorm	db	attrnormmono		;normal video attribute
attrhigh	db	attrhighmono		;highlight video attribute
attrinv		db	attrinvmono		;invers video attribute
vidseg		dw	vidsegmono		;video buffer seg
msgptr		dw	xstaidn			;status prefix pointer
status		db	drwwin+drwsta+drwinf	;main status flags
endprgsw	db	false			;end of program
chrdelcnt	dw	0			;char del count
lindelcnt	dw	0			;line del count
blkdelcnt	dw	0			;block del count
dellftsw	db	false			;delete left switch
trimsw		db	false			;remove trailing blanks switch
isrtsw		db	true			;insert mode switch
indtsw		db	false			;auto-indent switch
wrapsw		db	false			;word wrap switch
justsw		db	true			;justification switch
justupsw	db	true			;justification left-to-right
ctrmode		db	0			;control char display mode

;window relative rows/columns
maxwinrow	dw	22			;max text display row
stawinrow	dw	23			;status info row
prmwinrow	dw	24			;message/prompt row
maxwincol	dw	80			;max col

;text relative columns
lftmar		dw	0			;left margin
rgtmar		dw	78			;right margin

;global text pointers
pointers struc
 usrtxt		dw	10 dup(nil)		;0-9: user text pointers
 fndtxt		dw	nil			;10 : pre-find pos
 prvtxt		dw	nil			;11 : previous pos
 begblk		dw	nil			;12 : begin block
 endblk		dw	nil			;13 : end block
 curtxt		dw	0			;14 : current position
 endtxt		dw	0			;15 : end of text
 winref		dw	0			;16 : window reference pointer
 wrpjstbeg	dw	nil			;17 : word wrap begin just area
 wrpsepbeg	dw	nil			;18 : word wrap begin sep
 wrpwrdbeg	dw	nil			;19 : word wrap begin word
 wrpwrdend	dw	nil			;20 : word wrap end word
 wrptxtend	dw	nil			;21 : word wrap end ptr
 tmpsave	dw	nil			;22 : temp ptr
ends

dflpnt		pointers <>			;initial pointer buffer
pntcnt		equ	($-dflpnt)/2		;nr of text pointers

		page
exttbl:	;Command dispatch table for extended keycodes
dw	533Bh,help,save,loadnew,exit,find,fndrep,blkbeg,blkend,mrklin,rptlin
;	     <F01  F02  F03     F04  F05  F06    F07    F08    F09    F10
dw	dmy,dmy,gtosol,up,pgup,dmy,left,dmy,right,dmy,gtoeol,down,pgdn,tglins
;	        Home   Up PgUp     Left     Right     End    Down PgDn Ins
dw	delchr,7773h,lftwrd,rgtwrd,botscr,bottom,topscr,8484h,top,8D8Dh,sup
;	Del   >     <^Left ^Right ^End   ^PgDn  ^Home  >    <^PgUp>    <^Up>
dw	9191h,sdown
;	     <^Down>
db 0	;end of table


ctrtbl:	;Command dispatch table for control-characters
dw	1A01h,lftwrd,reformat,pgdn,right,up,rgtwrd,delchr,delleft,instab
;	     <^A     ^B       ^C   ^D    ^E ^F     ^G     ^H      ^I,Tab
dw	help,ctrkcmd,rfind,newlin,insnwl,ctrocmd,ctrpcmd,ctrqcmd,pgup,left
;	^J   ^K      ^L    ^M,CR  ^N     ^O      ^P      ^Q      ^R   ^S
dw	delwrd,dmy,tglins,sup,down,dellin,sdown,7F7Fh,delleft
;	^T     ^U  ^V     ^W  ^X   ^Y     ^Z   >     <^<BS>  >
db 0	;end of table


ctrktbl:;Command dispatch table for ctr-K subcommands
dw	4441h,linup,blkbeg,blkcopy,filemenu,4848h,blktoggle,4D4Bh,blkend,dmy
;	     <^KA   ^KB    ^KC     ^KD     >     <^KH      >     <^KK
dw	mrklin,5D50h,blkprint,quit,blkread,save,mrkwrd,blkundel,blkmove
;	^KM   >     <^KP      ^KQ  ^KR     ^KS  ^KT    ^KU      ^KV
dw	blkwrite,exit,blkdel,lindown,dmy,rptlin,blktrim,3930h,10 dup(setmark)
;	^KW      ^KX  ^KY    ^KZ         ^K\    ^K]    >            <^K0-^K9>
db 0	;end of table


ctrotbl:;Command dispatch table for ctr-O subcommands
dw	4444h,chgctrmode,4C49h,setLRmar,tgljust,dmy,setlftmar
;	     <^OD       >     <^OI      ^OJ           ^OL      >
dw	5252h,setrgtmar,5757h,tglwrap,5D5Dh,tgltrim
;	     <^OR      >     <^OW   >      < ^O]   >
db 0	;end of table


ctrqtbl:;Command dispatch table for ctr-Q subcommands
dw	4C41h,fndrep,tobegblk,bottom,sright,topscr,find,gtolin,delsol,tglindent
;	     <^QA    ^QB      ^QC    ^QD    ^QE    ^QF  ^QG   ^QH/BS  ^QI
dw	dmy,toendblk,linundel,5950h,gtoprev,dmy,top,sleft,dmy,undo
;	    ^QK      ^QL     >     <^QP         ^QR ^QS       ^QU
dw	gtofind,dmy,botscr,deleol,3930h,10 dup(gtomark),7F7Fh,delsol
;	 ^QV        ^QX    ^QY  >             <^Q0-^Q9>     < ^Q<BS> >
db 0	;end of table


fmnutbl:;Command dispatch table for file menu
dw	4545h,exit,4C4Ch,loadnew,4E4Eh,newfile,5151h,quit,5353h,save
;	     <E   >     <L      >     <N      >     <Q   >     <S   >
db 0	;end of table

;--- END TEDATA.ASM ----------------------------------------------------------
