/*
 * Copyright (C) 2007 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.widget;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public interface ExpandableListAdapter {

public void registerDataSetObserver(android.database.DataSetObserver observer);

public void unregisterDataSetObserver(android.database.DataSetObserver observer);

public int getGroupCount();

public int getChildrenCount(int groupPosition);

public java.lang.Object getGroup(int groupPosition);

public java.lang.Object getChild(int groupPosition, int childPosition);

public long getGroupId(int groupPosition);

public long getChildId(int groupPosition, int childPosition);

public boolean hasStableIds();

public android.view.View getGroupView(int groupPosition, boolean isExpanded, android.view.View convertView, android.view.ViewGroup parent);

public android.view.View getChildView(int groupPosition, int childPosition, boolean isLastChild, android.view.View convertView, android.view.ViewGroup parent);

public boolean isChildSelectable(int groupPosition, int childPosition);

public boolean areAllItemsEnabled();

public boolean isEmpty();

public void onGroupExpanded(int groupPosition);

public void onGroupCollapsed(int groupPosition);

public long getCombinedChildId(long groupId, long childId);

public long getCombinedGroupId(long groupId);
}

