/*
 * Copyright (C) 2019 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.service.controls.actions;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public abstract class ControlAction {

ControlAction() { throw new RuntimeException("Stub!"); }

public static final boolean isValidResponse(int response) { throw new RuntimeException("Stub!"); }

public abstract int getActionType();

@android.annotation.NonNull
public java.lang.String getTemplateId() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public java.lang.String getChallengeValue() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public static android.service.controls.actions.ControlAction getErrorAction() { throw new RuntimeException("Stub!"); }

public static final int RESPONSE_CHALLENGE_ACK = 3; // 0x3

public static final int RESPONSE_CHALLENGE_PASSPHRASE = 5; // 0x5

public static final int RESPONSE_CHALLENGE_PIN = 4; // 0x4

public static final int RESPONSE_FAIL = 2; // 0x2

public static final int RESPONSE_OK = 1; // 0x1

public static final int RESPONSE_UNKNOWN = 0; // 0x0

public static final int TYPE_BOOLEAN = 1; // 0x1

public static final int TYPE_COMMAND = 5; // 0x5

public static final int TYPE_ERROR = -1; // 0xffffffff

public static final int TYPE_FLOAT = 2; // 0x2

public static final int TYPE_MODE = 4; // 0x4
}

