/*
 * Copyright (C) 2015 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.security.keystore;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public abstract class KeyProperties {

private KeyProperties() { throw new RuntimeException("Stub!"); }

public static final int AUTH_BIOMETRIC_STRONG = 2; // 0x2

public static final int AUTH_DEVICE_CREDENTIAL = 1; // 0x1

public static final java.lang.String BLOCK_MODE_CBC = "CBC";

public static final java.lang.String BLOCK_MODE_CTR = "CTR";

public static final java.lang.String BLOCK_MODE_ECB = "ECB";

public static final java.lang.String BLOCK_MODE_GCM = "GCM";

public static final java.lang.String DIGEST_MD5 = "MD5";

public static final java.lang.String DIGEST_NONE = "NONE";

public static final java.lang.String DIGEST_SHA1 = "SHA-1";

public static final java.lang.String DIGEST_SHA224 = "SHA-224";

public static final java.lang.String DIGEST_SHA256 = "SHA-256";

public static final java.lang.String DIGEST_SHA384 = "SHA-384";

public static final java.lang.String DIGEST_SHA512 = "SHA-512";

public static final java.lang.String ENCRYPTION_PADDING_NONE = "NoPadding";

public static final java.lang.String ENCRYPTION_PADDING_PKCS7 = "PKCS7Padding";

public static final java.lang.String ENCRYPTION_PADDING_RSA_OAEP = "OAEPPadding";

public static final java.lang.String ENCRYPTION_PADDING_RSA_PKCS1 = "PKCS1Padding";

@Deprecated public static final java.lang.String KEY_ALGORITHM_3DES = "DESede";

public static final java.lang.String KEY_ALGORITHM_AES = "AES";

public static final java.lang.String KEY_ALGORITHM_EC = "EC";

public static final java.lang.String KEY_ALGORITHM_HMAC_SHA1 = "HmacSHA1";

public static final java.lang.String KEY_ALGORITHM_HMAC_SHA224 = "HmacSHA224";

public static final java.lang.String KEY_ALGORITHM_HMAC_SHA256 = "HmacSHA256";

public static final java.lang.String KEY_ALGORITHM_HMAC_SHA384 = "HmacSHA384";

public static final java.lang.String KEY_ALGORITHM_HMAC_SHA512 = "HmacSHA512";

public static final java.lang.String KEY_ALGORITHM_RSA = "RSA";

public static final int ORIGIN_GENERATED = 1; // 0x1

public static final int ORIGIN_IMPORTED = 2; // 0x2

public static final int ORIGIN_SECURELY_IMPORTED = 8; // 0x8

public static final int ORIGIN_UNKNOWN = 4; // 0x4

public static final int PURPOSE_AGREE_KEY = 64; // 0x40

public static final int PURPOSE_ATTEST_KEY = 128; // 0x80

public static final int PURPOSE_DECRYPT = 2; // 0x2

public static final int PURPOSE_ENCRYPT = 1; // 0x1

public static final int PURPOSE_SIGN = 4; // 0x4

public static final int PURPOSE_VERIFY = 8; // 0x8

public static final int PURPOSE_WRAP_KEY = 32; // 0x20

public static final int SECURITY_LEVEL_SOFTWARE = 0; // 0x0

public static final int SECURITY_LEVEL_STRONGBOX = 2; // 0x2

public static final int SECURITY_LEVEL_TRUSTED_ENVIRONMENT = 1; // 0x1

public static final int SECURITY_LEVEL_UNKNOWN = -2; // 0xfffffffe

public static final int SECURITY_LEVEL_UNKNOWN_SECURE = -1; // 0xffffffff

public static final java.lang.String SIGNATURE_PADDING_RSA_PKCS1 = "PKCS1";

public static final java.lang.String SIGNATURE_PADDING_RSA_PSS = "PSS";

public static final int UNRESTRICTED_USAGE_COUNT = -1; // 0xffffffff
}

