/*
 * Copyright (C) 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.net.ipsec.ike.exceptions;

import android.net.ipsec.ike.ChildSessionCallback;
import android.net.ipsec.ike.IkeSessionCallback;
import java.net.UnknownHostException;
import java.io.IOException;

/** Wrapper for I/O exceptions encountered during IKE operations. */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class IkeIOException extends android.net.ipsec.ike.exceptions.IkeNonProtocolException {

/**
 * Constructs a new exception with the specified cause.
 *
 * <p>Callers are not generally expected to instantiate this object themselves, except for
 * testing. A reference is passed via {@link android.net.ipsec.ike.IkeSessionCallback IkeSessionCallback} or {@link android.net.ipsec.ike.ChildSessionCallback ChildSessionCallback}.
 *
 * @param cause the cause (which is saved for later retrieval by the {@link #getCause()}
 *     method).

 * This value cannot be {@code null}.
 */

public IkeIOException(@android.annotation.NonNull java.io.IOException cause) { throw new RuntimeException("Stub!"); }

/**
 * Returns the cause of this IkeIOException.
 *
 * @return the cause of this IkeIOException. It might be a subclass of IOException that
 *     represents a specific type of I/O issue. For example, {@link java.net.UnknownHostException UnknownHostException} and
 *     {@link android.net.ipsec.ike.exceptions.IkeTimeoutException IkeTimeoutException}.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.io.IOException getCause() { throw new RuntimeException("Stub!"); }

/** @hide */

public synchronized java.lang.Throwable initCause(java.lang.Throwable cause) { throw new RuntimeException("Stub!"); }
}

