/*
 * Copyright (C) 2014 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.net;


/**
 * Defines a request for a network, made through {@link android.net.NetworkRequest.Builder NetworkRequest.Builder} and used
 * to request a network via {@link android.net.ConnectivityManager#requestNetwork ConnectivityManager#requestNetwork} or listen for changes
 * via {@link android.net.ConnectivityManager#registerNetworkCallback ConnectivityManager#registerNetworkCallback}.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public class NetworkRequest implements android.os.Parcelable {

NetworkRequest() { throw new RuntimeException("Stub!"); }

public int describeContents() { throw new RuntimeException("Stub!"); }

public void writeToParcel(android.os.Parcel dest, int flags) { throw new RuntimeException("Stub!"); }

/**
 * @see android.net.NetworkRequest.Builder#addCapability(int)

 * @param capability Value is {@link android.net.NetworkCapabilities#NET_CAPABILITY_MMS}, {@link android.net.NetworkCapabilities#NET_CAPABILITY_SUPL}, {@link android.net.NetworkCapabilities#NET_CAPABILITY_DUN}, {@link android.net.NetworkCapabilities#NET_CAPABILITY_FOTA}, {@link android.net.NetworkCapabilities#NET_CAPABILITY_IMS}, {@link android.net.NetworkCapabilities#NET_CAPABILITY_CBS}, {@link android.net.NetworkCapabilities#NET_CAPABILITY_WIFI_P2P}, {@link android.net.NetworkCapabilities#NET_CAPABILITY_IA}, {@link android.net.NetworkCapabilities#NET_CAPABILITY_RCS}, {@link android.net.NetworkCapabilities#NET_CAPABILITY_XCAP}, {@link android.net.NetworkCapabilities#NET_CAPABILITY_EIMS}, {@link android.net.NetworkCapabilities#NET_CAPABILITY_NOT_METERED}, {@link android.net.NetworkCapabilities#NET_CAPABILITY_INTERNET}, {@link android.net.NetworkCapabilities#NET_CAPABILITY_NOT_RESTRICTED}, {@link android.net.NetworkCapabilities#NET_CAPABILITY_TRUSTED}, {@link android.net.NetworkCapabilities#NET_CAPABILITY_NOT_VPN}, {@link android.net.NetworkCapabilities#NET_CAPABILITY_VALIDATED}, {@link android.net.NetworkCapabilities#NET_CAPABILITY_CAPTIVE_PORTAL}, {@link android.net.NetworkCapabilities#NET_CAPABILITY_NOT_ROAMING}, {@link android.net.NetworkCapabilities#NET_CAPABILITY_FOREGROUND}, {@link android.net.NetworkCapabilities#NET_CAPABILITY_NOT_CONGESTED}, {@link android.net.NetworkCapabilities#NET_CAPABILITY_NOT_SUSPENDED}, android.net.NetworkCapabilities.NET_CAPABILITY_OEM_PAID, {@link android.net.NetworkCapabilities#NET_CAPABILITY_MCX}, android.net.NetworkCapabilities.NET_CAPABILITY_PARTIAL_CONNECTIVITY, {@link android.net.NetworkCapabilities#NET_CAPABILITY_TEMPORARILY_NOT_METERED}, android.net.NetworkCapabilities.NET_CAPABILITY_OEM_PRIVATE, android.net.NetworkCapabilities.NET_CAPABILITY_VEHICLE_INTERNAL, android.net.NetworkCapabilities.NET_CAPABILITY_NOT_VCN_MANAGED, {@link android.net.NetworkCapabilities#NET_CAPABILITY_ENTERPRISE}, android.net.NetworkCapabilities.NET_CAPABILITY_VSIM, android.net.NetworkCapabilities.NET_CAPABILITY_BIP, {@link android.net.NetworkCapabilities#NET_CAPABILITY_HEAD_UNIT}, {@link android.net.NetworkCapabilities#NET_CAPABILITY_MMTEL}, {@link android.net.NetworkCapabilities#NET_CAPABILITY_PRIORITIZE_LATENCY}, or {@link android.net.NetworkCapabilities#NET_CAPABILITY_PRIORITIZE_BANDWIDTH}
 */

public boolean hasCapability(int capability) { throw new RuntimeException("Stub!"); }

/**
 * Returns true if and only if the capabilities requested in this NetworkRequest are satisfied
 * by the provided {@link android.net.NetworkCapabilities NetworkCapabilities}.
 *
 * @param nc Capabilities that should satisfy this NetworkRequest. null capabilities do not
 *           satisfy any request.
 */

public boolean canBeSatisfiedBy(@android.annotation.Nullable android.net.NetworkCapabilities nc) { throw new RuntimeException("Stub!"); }

/**
 * @see android.net.NetworkRequest.Builder#addTransportType(int)

 * @param transportType Value is {@link android.net.NetworkCapabilities#TRANSPORT_CELLULAR}, {@link android.net.NetworkCapabilities#TRANSPORT_WIFI}, {@link android.net.NetworkCapabilities#TRANSPORT_BLUETOOTH}, {@link android.net.NetworkCapabilities#TRANSPORT_ETHERNET}, {@link android.net.NetworkCapabilities#TRANSPORT_VPN}, {@link android.net.NetworkCapabilities#TRANSPORT_WIFI_AWARE}, {@link android.net.NetworkCapabilities#TRANSPORT_LOWPAN}, android.net.NetworkCapabilities.TRANSPORT_TEST, or {@link android.net.NetworkCapabilities#TRANSPORT_USB}
 */

public boolean hasTransport(int transportType) { throw new RuntimeException("Stub!"); }

/**
 * @see android.net.NetworkRequest.Builder#setNetworkSpecifier(NetworkSpecifier)

 * @return This value may be {@code null}.
 */

@android.annotation.Nullable
public android.net.NetworkSpecifier getNetworkSpecifier() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param obj This value may be {@code null}.
 */

public boolean equals(@android.annotation.Nullable java.lang.Object obj) { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

/**
 * Gets all the capabilities set on this {@code NetworkRequest} instance.
 *
 * @return an array of capability values for this instance.
 
 * This value cannot be {@code null}.

 * Value is {@link android.net.NetworkCapabilities#NET_CAPABILITY_MMS}, {@link android.net.NetworkCapabilities#NET_CAPABILITY_SUPL}, {@link android.net.NetworkCapabilities#NET_CAPABILITY_DUN}, {@link android.net.NetworkCapabilities#NET_CAPABILITY_FOTA}, {@link android.net.NetworkCapabilities#NET_CAPABILITY_IMS}, {@link android.net.NetworkCapabilities#NET_CAPABILITY_CBS}, {@link android.net.NetworkCapabilities#NET_CAPABILITY_WIFI_P2P}, {@link android.net.NetworkCapabilities#NET_CAPABILITY_IA}, {@link android.net.NetworkCapabilities#NET_CAPABILITY_RCS}, {@link android.net.NetworkCapabilities#NET_CAPABILITY_XCAP}, {@link android.net.NetworkCapabilities#NET_CAPABILITY_EIMS}, {@link android.net.NetworkCapabilities#NET_CAPABILITY_NOT_METERED}, {@link android.net.NetworkCapabilities#NET_CAPABILITY_INTERNET}, {@link android.net.NetworkCapabilities#NET_CAPABILITY_NOT_RESTRICTED}, {@link android.net.NetworkCapabilities#NET_CAPABILITY_TRUSTED}, {@link android.net.NetworkCapabilities#NET_CAPABILITY_NOT_VPN}, {@link android.net.NetworkCapabilities#NET_CAPABILITY_VALIDATED}, {@link android.net.NetworkCapabilities#NET_CAPABILITY_CAPTIVE_PORTAL}, {@link android.net.NetworkCapabilities#NET_CAPABILITY_NOT_ROAMING}, {@link android.net.NetworkCapabilities#NET_CAPABILITY_FOREGROUND}, {@link android.net.NetworkCapabilities#NET_CAPABILITY_NOT_CONGESTED}, {@link android.net.NetworkCapabilities#NET_CAPABILITY_NOT_SUSPENDED}, android.net.NetworkCapabilities.NET_CAPABILITY_OEM_PAID, {@link android.net.NetworkCapabilities#NET_CAPABILITY_MCX}, android.net.NetworkCapabilities.NET_CAPABILITY_PARTIAL_CONNECTIVITY, {@link android.net.NetworkCapabilities#NET_CAPABILITY_TEMPORARILY_NOT_METERED}, android.net.NetworkCapabilities.NET_CAPABILITY_OEM_PRIVATE, android.net.NetworkCapabilities.NET_CAPABILITY_VEHICLE_INTERNAL, android.net.NetworkCapabilities.NET_CAPABILITY_NOT_VCN_MANAGED, {@link android.net.NetworkCapabilities#NET_CAPABILITY_ENTERPRISE}, android.net.NetworkCapabilities.NET_CAPABILITY_VSIM, android.net.NetworkCapabilities.NET_CAPABILITY_BIP, {@link android.net.NetworkCapabilities#NET_CAPABILITY_HEAD_UNIT}, {@link android.net.NetworkCapabilities#NET_CAPABILITY_MMTEL}, {@link android.net.NetworkCapabilities#NET_CAPABILITY_PRIORITIZE_LATENCY}, or {@link android.net.NetworkCapabilities#NET_CAPABILITY_PRIORITIZE_BANDWIDTH}
 */

@android.annotation.NonNull
public int[] getCapabilities() { throw new RuntimeException("Stub!"); }

/**
 * Gets all the transports set on this {@code NetworkRequest} instance.
 *
 * @return an array of transport type values for this instance.
 
 * This value cannot be {@code null}.

 * Value is {@link android.net.NetworkCapabilities#TRANSPORT_CELLULAR}, {@link android.net.NetworkCapabilities#TRANSPORT_WIFI}, {@link android.net.NetworkCapabilities#TRANSPORT_BLUETOOTH}, {@link android.net.NetworkCapabilities#TRANSPORT_ETHERNET}, {@link android.net.NetworkCapabilities#TRANSPORT_VPN}, {@link android.net.NetworkCapabilities#TRANSPORT_WIFI_AWARE}, {@link android.net.NetworkCapabilities#TRANSPORT_LOWPAN}, android.net.NetworkCapabilities.TRANSPORT_TEST, or {@link android.net.NetworkCapabilities#TRANSPORT_USB}
 */

@android.annotation.NonNull
public int[] getTransportTypes() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull public static final android.os.Parcelable.Creator<android.net.NetworkRequest> CREATOR;
static { CREATOR = null; }
/**
 * Builder used to create {@link android.net.NetworkRequest NetworkRequest} objects.  Specify the Network features
 * needed in terms of {@link android.net.NetworkCapabilities NetworkCapabilities} features
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static class Builder {

/**
 * Default constructor for Builder.
 */

public Builder() { throw new RuntimeException("Stub!"); }

/**
 * Creates a new Builder of NetworkRequest from an existing instance.

 * @param request This value cannot be {@code null}.
 */

public Builder(@android.annotation.NonNull android.net.NetworkRequest request) { throw new RuntimeException("Stub!"); }

/**
 * Build {@link android.net.NetworkRequest NetworkRequest} give the current set of capabilities.
 */

public android.net.NetworkRequest build() { throw new RuntimeException("Stub!"); }

/**
 * Add the given capability requirement to this builder.  These represent
 * the requested network's required capabilities.  Note that when searching
 * for a network to satisfy a request, all capabilities requested must be
 * satisfied.
 *
 * @param capability The capability to add.
 * Value is {@link android.net.NetworkCapabilities#NET_CAPABILITY_MMS}, {@link android.net.NetworkCapabilities#NET_CAPABILITY_SUPL}, {@link android.net.NetworkCapabilities#NET_CAPABILITY_DUN}, {@link android.net.NetworkCapabilities#NET_CAPABILITY_FOTA}, {@link android.net.NetworkCapabilities#NET_CAPABILITY_IMS}, {@link android.net.NetworkCapabilities#NET_CAPABILITY_CBS}, {@link android.net.NetworkCapabilities#NET_CAPABILITY_WIFI_P2P}, {@link android.net.NetworkCapabilities#NET_CAPABILITY_IA}, {@link android.net.NetworkCapabilities#NET_CAPABILITY_RCS}, {@link android.net.NetworkCapabilities#NET_CAPABILITY_XCAP}, {@link android.net.NetworkCapabilities#NET_CAPABILITY_EIMS}, {@link android.net.NetworkCapabilities#NET_CAPABILITY_NOT_METERED}, {@link android.net.NetworkCapabilities#NET_CAPABILITY_INTERNET}, {@link android.net.NetworkCapabilities#NET_CAPABILITY_NOT_RESTRICTED}, {@link android.net.NetworkCapabilities#NET_CAPABILITY_TRUSTED}, {@link android.net.NetworkCapabilities#NET_CAPABILITY_NOT_VPN}, {@link android.net.NetworkCapabilities#NET_CAPABILITY_VALIDATED}, {@link android.net.NetworkCapabilities#NET_CAPABILITY_CAPTIVE_PORTAL}, {@link android.net.NetworkCapabilities#NET_CAPABILITY_NOT_ROAMING}, {@link android.net.NetworkCapabilities#NET_CAPABILITY_FOREGROUND}, {@link android.net.NetworkCapabilities#NET_CAPABILITY_NOT_CONGESTED}, {@link android.net.NetworkCapabilities#NET_CAPABILITY_NOT_SUSPENDED}, android.net.NetworkCapabilities.NET_CAPABILITY_OEM_PAID, {@link android.net.NetworkCapabilities#NET_CAPABILITY_MCX}, android.net.NetworkCapabilities.NET_CAPABILITY_PARTIAL_CONNECTIVITY, {@link android.net.NetworkCapabilities#NET_CAPABILITY_TEMPORARILY_NOT_METERED}, android.net.NetworkCapabilities.NET_CAPABILITY_OEM_PRIVATE, android.net.NetworkCapabilities.NET_CAPABILITY_VEHICLE_INTERNAL, android.net.NetworkCapabilities.NET_CAPABILITY_NOT_VCN_MANAGED, {@link android.net.NetworkCapabilities#NET_CAPABILITY_ENTERPRISE}, android.net.NetworkCapabilities.NET_CAPABILITY_VSIM, android.net.NetworkCapabilities.NET_CAPABILITY_BIP, {@link android.net.NetworkCapabilities#NET_CAPABILITY_HEAD_UNIT}, {@link android.net.NetworkCapabilities#NET_CAPABILITY_MMTEL}, {@link android.net.NetworkCapabilities#NET_CAPABILITY_PRIORITIZE_LATENCY}, or {@link android.net.NetworkCapabilities#NET_CAPABILITY_PRIORITIZE_BANDWIDTH}
 * @return The builder to facilitate chaining
 *         {@code builder.addCapability(...).addCapability();}.
 */

public android.net.NetworkRequest.Builder addCapability(int capability) { throw new RuntimeException("Stub!"); }

/**
 * Removes (if found) the given capability from this builder instance.
 *
 * @param capability The capability to remove.
 * Value is {@link android.net.NetworkCapabilities#NET_CAPABILITY_MMS}, {@link android.net.NetworkCapabilities#NET_CAPABILITY_SUPL}, {@link android.net.NetworkCapabilities#NET_CAPABILITY_DUN}, {@link android.net.NetworkCapabilities#NET_CAPABILITY_FOTA}, {@link android.net.NetworkCapabilities#NET_CAPABILITY_IMS}, {@link android.net.NetworkCapabilities#NET_CAPABILITY_CBS}, {@link android.net.NetworkCapabilities#NET_CAPABILITY_WIFI_P2P}, {@link android.net.NetworkCapabilities#NET_CAPABILITY_IA}, {@link android.net.NetworkCapabilities#NET_CAPABILITY_RCS}, {@link android.net.NetworkCapabilities#NET_CAPABILITY_XCAP}, {@link android.net.NetworkCapabilities#NET_CAPABILITY_EIMS}, {@link android.net.NetworkCapabilities#NET_CAPABILITY_NOT_METERED}, {@link android.net.NetworkCapabilities#NET_CAPABILITY_INTERNET}, {@link android.net.NetworkCapabilities#NET_CAPABILITY_NOT_RESTRICTED}, {@link android.net.NetworkCapabilities#NET_CAPABILITY_TRUSTED}, {@link android.net.NetworkCapabilities#NET_CAPABILITY_NOT_VPN}, {@link android.net.NetworkCapabilities#NET_CAPABILITY_VALIDATED}, {@link android.net.NetworkCapabilities#NET_CAPABILITY_CAPTIVE_PORTAL}, {@link android.net.NetworkCapabilities#NET_CAPABILITY_NOT_ROAMING}, {@link android.net.NetworkCapabilities#NET_CAPABILITY_FOREGROUND}, {@link android.net.NetworkCapabilities#NET_CAPABILITY_NOT_CONGESTED}, {@link android.net.NetworkCapabilities#NET_CAPABILITY_NOT_SUSPENDED}, android.net.NetworkCapabilities.NET_CAPABILITY_OEM_PAID, {@link android.net.NetworkCapabilities#NET_CAPABILITY_MCX}, android.net.NetworkCapabilities.NET_CAPABILITY_PARTIAL_CONNECTIVITY, {@link android.net.NetworkCapabilities#NET_CAPABILITY_TEMPORARILY_NOT_METERED}, android.net.NetworkCapabilities.NET_CAPABILITY_OEM_PRIVATE, android.net.NetworkCapabilities.NET_CAPABILITY_VEHICLE_INTERNAL, android.net.NetworkCapabilities.NET_CAPABILITY_NOT_VCN_MANAGED, {@link android.net.NetworkCapabilities#NET_CAPABILITY_ENTERPRISE}, android.net.NetworkCapabilities.NET_CAPABILITY_VSIM, android.net.NetworkCapabilities.NET_CAPABILITY_BIP, {@link android.net.NetworkCapabilities#NET_CAPABILITY_HEAD_UNIT}, {@link android.net.NetworkCapabilities#NET_CAPABILITY_MMTEL}, {@link android.net.NetworkCapabilities#NET_CAPABILITY_PRIORITIZE_LATENCY}, or {@link android.net.NetworkCapabilities#NET_CAPABILITY_PRIORITIZE_BANDWIDTH}
 * @return The builder to facilitate chaining.
 */

public android.net.NetworkRequest.Builder removeCapability(int capability) { throw new RuntimeException("Stub!"); }

/**
 * Completely clears all the {@code NetworkCapabilities} from this builder instance,
 * removing even the capabilities that are set by default when the object is constructed.
 *
 * @return The builder to facilitate chaining.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.NetworkRequest.Builder clearCapabilities() { throw new RuntimeException("Stub!"); }

/**
 * Adds the given transport requirement to this builder.  These represent
 * the set of allowed transports for the request.  Only networks using one
 * of these transports will satisfy the request.  If no particular transports
 * are required, none should be specified here.
 *
 * @param transportType The transport type to add.
 * Value is {@link android.net.NetworkCapabilities#TRANSPORT_CELLULAR}, {@link android.net.NetworkCapabilities#TRANSPORT_WIFI}, {@link android.net.NetworkCapabilities#TRANSPORT_BLUETOOTH}, {@link android.net.NetworkCapabilities#TRANSPORT_ETHERNET}, {@link android.net.NetworkCapabilities#TRANSPORT_VPN}, {@link android.net.NetworkCapabilities#TRANSPORT_WIFI_AWARE}, {@link android.net.NetworkCapabilities#TRANSPORT_LOWPAN}, android.net.NetworkCapabilities.TRANSPORT_TEST, or {@link android.net.NetworkCapabilities#TRANSPORT_USB}
 * @return The builder to facilitate chaining.
 */

public android.net.NetworkRequest.Builder addTransportType(int transportType) { throw new RuntimeException("Stub!"); }

/**
 * Removes (if found) the given transport from this builder instance.
 *
 * @param transportType The transport type to remove.
 * Value is {@link android.net.NetworkCapabilities#TRANSPORT_CELLULAR}, {@link android.net.NetworkCapabilities#TRANSPORT_WIFI}, {@link android.net.NetworkCapabilities#TRANSPORT_BLUETOOTH}, {@link android.net.NetworkCapabilities#TRANSPORT_ETHERNET}, {@link android.net.NetworkCapabilities#TRANSPORT_VPN}, {@link android.net.NetworkCapabilities#TRANSPORT_WIFI_AWARE}, {@link android.net.NetworkCapabilities#TRANSPORT_LOWPAN}, android.net.NetworkCapabilities.TRANSPORT_TEST, or {@link android.net.NetworkCapabilities#TRANSPORT_USB}
 * @return The builder to facilitate chaining.
 */

public android.net.NetworkRequest.Builder removeTransportType(int transportType) { throw new RuntimeException("Stub!"); }

/**
 * Sets the optional bearer specific network specifier.
 * This has no meaning if a single transport is also not specified, so calling
 * this without a single transport set will generate an exception, as will
 * subsequently adding or removing transports after this is set.
 * </p>
 * If the {@code networkSpecifier} is provided, it shall be interpreted as follows:
 * <ul>
 * <li>If the specifier can be parsed as an integer, it will be treated as a
 * {@link android.net TelephonyNetworkSpecifier}, and the provided integer will be
 * interpreted as a SubscriptionId.
 * <li>If the value is an ethernet interface name, it will be treated as such.
 * <li>For all other cases, the behavior is undefined.
 * </ul>
 *
 * @param networkSpecifier A {@code String} of either a SubscriptionId in cellular
 *                         network request or an ethernet interface name in ethernet
 *                         network request.
 *
 * @deprecated Use {@link #setNetworkSpecifier(android.net.NetworkSpecifier)} instead.
 */

@Deprecated
public android.net.NetworkRequest.Builder setNetworkSpecifier(java.lang.String networkSpecifier) { throw new RuntimeException("Stub!"); }

/**
 * Sets the optional bearer specific network specifier.
 * This has no meaning if a single transport is also not specified, so calling
 * this without a single transport set will generate an exception, as will
 * subsequently adding or removing transports after this is set.
 * </p>
 *
 * @param networkSpecifier A concrete, parcelable framework class that extends
 *                         NetworkSpecifier.
 */

public android.net.NetworkRequest.Builder setNetworkSpecifier(android.net.NetworkSpecifier networkSpecifier) { throw new RuntimeException("Stub!"); }

/**
 * Specifies whether the built request should also match networks that do not apply to the
 * calling UID.
 *
 * By default, the built request will only match networks that apply to the calling UID.
 * If this method is called with {@code true}, the built request will match any network on
 * the system that matches the other parameters of the request. In this case, any
 * information in the built request that is subject to redaction for security or privacy
 * purposes, such as a {@link android.net.NetworkSpecifier NetworkSpecifier}, will be redacted or removed to prevent the
 * application deducing sensitive information.
 *
 * @param include Whether to match networks that do not apply to the calling UID.
 * @return The builder to facilitate chaining.

 * This value cannot be {@code null}.
 */

@android.annotation.NonNull
public android.net.NetworkRequest.Builder setIncludeOtherUidNetworks(boolean include) { throw new RuntimeException("Stub!"); }
}

}

