/*
 * Copyright (C) 2013 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.media;

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class MediaDrm implements java.lang.AutoCloseable {

public MediaDrm(@android.annotation.NonNull java.util.UUID uuid) throws android.media.UnsupportedSchemeException { throw new RuntimeException("Stub!"); }

public static boolean isCryptoSchemeSupported(@android.annotation.NonNull java.util.UUID uuid) { throw new RuntimeException("Stub!"); }

public static boolean isCryptoSchemeSupported(@android.annotation.NonNull java.util.UUID uuid, @android.annotation.NonNull java.lang.String mimeType) { throw new RuntimeException("Stub!"); }

public static boolean isCryptoSchemeSupported(@android.annotation.NonNull java.util.UUID uuid, @android.annotation.NonNull java.lang.String mimeType, int securityLevel) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public static java.util.List<java.util.UUID> getSupportedCryptoSchemes() { throw new RuntimeException("Stub!"); }

public void setOnExpirationUpdateListener(@android.annotation.Nullable android.media.MediaDrm.OnExpirationUpdateListener listener, @android.annotation.Nullable android.os.Handler handler) { throw new RuntimeException("Stub!"); }

public void setOnExpirationUpdateListener(@android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.media.MediaDrm.OnExpirationUpdateListener listener) { throw new RuntimeException("Stub!"); }

public void clearOnExpirationUpdateListener() { throw new RuntimeException("Stub!"); }

public void setOnKeyStatusChangeListener(@android.annotation.Nullable android.media.MediaDrm.OnKeyStatusChangeListener listener, @android.annotation.Nullable android.os.Handler handler) { throw new RuntimeException("Stub!"); }

public void setOnKeyStatusChangeListener(@android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.media.MediaDrm.OnKeyStatusChangeListener listener) { throw new RuntimeException("Stub!"); }

public void clearOnKeyStatusChangeListener() { throw new RuntimeException("Stub!"); }

public void setOnSessionLostStateListener(@android.annotation.Nullable android.media.MediaDrm.OnSessionLostStateListener listener, @android.annotation.Nullable android.os.Handler handler) { throw new RuntimeException("Stub!"); }

public void setOnSessionLostStateListener(@android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.Nullable android.media.MediaDrm.OnSessionLostStateListener listener) { throw new RuntimeException("Stub!"); }

public void clearOnSessionLostStateListener() { throw new RuntimeException("Stub!"); }

public void setOnEventListener(@android.annotation.Nullable android.media.MediaDrm.OnEventListener listener) { throw new RuntimeException("Stub!"); }

public void setOnEventListener(@android.annotation.Nullable android.media.MediaDrm.OnEventListener listener, @android.annotation.Nullable android.os.Handler handler) { throw new RuntimeException("Stub!"); }

public void setOnEventListener(@android.annotation.NonNull java.util.concurrent.Executor executor, @android.annotation.NonNull android.media.MediaDrm.OnEventListener listener) { throw new RuntimeException("Stub!"); }

public void clearOnEventListener() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public byte[] openSession() throws android.media.NotProvisionedException, android.media.ResourceBusyException { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public byte[] openSession(int level) throws android.media.NotProvisionedException, android.media.ResourceBusyException { throw new RuntimeException("Stub!"); }

public void closeSession(@android.annotation.NonNull byte[] sessionId) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.MediaDrm.KeyRequest getKeyRequest(@android.annotation.NonNull byte[] scope, @android.annotation.Nullable byte[] init, @android.annotation.Nullable java.lang.String mimeType, int keyType, @android.annotation.Nullable java.util.HashMap<java.lang.String,java.lang.String> optionalParameters) throws android.media.NotProvisionedException { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public native byte[] provideKeyResponse(@android.annotation.NonNull byte[] scope, @android.annotation.NonNull byte[] response) throws android.media.DeniedByServerException, android.media.NotProvisionedException;

public native void restoreKeys(@android.annotation.NonNull byte[] sessionId, @android.annotation.NonNull byte[] keySetId);

public native void removeKeys(@android.annotation.NonNull byte[] sessionId);

@android.annotation.NonNull
public native java.util.HashMap<java.lang.String,java.lang.String> queryKeyStatus(@android.annotation.NonNull byte[] sessionId);

@android.annotation.NonNull
public android.media.MediaDrm.ProvisionRequest getProvisionRequest() { throw new RuntimeException("Stub!"); }

public void provideProvisionResponse(@android.annotation.NonNull byte[] response) throws android.media.DeniedByServerException { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public native java.util.List<byte[]> getOfflineLicenseKeySetIds();

public native void removeOfflineLicense(@android.annotation.NonNull byte[] keySetId);

public native int getOfflineLicenseState(@android.annotation.NonNull byte[] keySetId);

@Deprecated
@android.annotation.NonNull
public native java.util.List<byte[]> getSecureStops();

@Deprecated
@android.annotation.NonNull
public native java.util.List<byte[]> getSecureStopIds();

@Deprecated
@android.annotation.NonNull
public native byte[] getSecureStop(@android.annotation.NonNull byte[] ssid);

@Deprecated
public native void releaseSecureStops(@android.annotation.NonNull byte[] ssRelease);

@Deprecated
public native void removeSecureStop(@android.annotation.NonNull byte[] ssid);

@Deprecated
public native void removeAllSecureStops();

@Deprecated
public void releaseAllSecureStops() { throw new RuntimeException("Stub!"); }

public native int getConnectedHdcpLevel();

public native int getMaxHdcpLevel();

public native int getOpenSessionCount();

public native int getMaxSessionCount();

public static int getMaxSecurityLevel() { throw new RuntimeException("Stub!"); }

public native int getSecurityLevel(@android.annotation.NonNull byte[] sessionId);

@android.annotation.NonNull
public native java.lang.String getPropertyString(@android.annotation.NonNull java.lang.String propertyName);

public native void setPropertyString(@android.annotation.NonNull java.lang.String propertyName, @android.annotation.NonNull java.lang.String value);

@android.annotation.NonNull
public native byte[] getPropertyByteArray(java.lang.String propertyName);

public native void setPropertyByteArray(@android.annotation.NonNull java.lang.String propertyName, @android.annotation.NonNull byte[] value);

public android.os.PersistableBundle getMetrics() { throw new RuntimeException("Stub!"); }

public android.media.MediaDrm.CryptoSession getCryptoSession(@android.annotation.NonNull byte[] sessionId, @android.annotation.NonNull java.lang.String cipherAlgorithm, @android.annotation.NonNull java.lang.String macAlgorithm) { throw new RuntimeException("Stub!"); }

public boolean requiresSecureDecoder(@android.annotation.NonNull java.lang.String mime) { throw new RuntimeException("Stub!"); }

public native boolean requiresSecureDecoder(@android.annotation.NonNull java.lang.String mime, int level);

protected void finalize() throws java.lang.Throwable { throw new RuntimeException("Stub!"); }

public void close() { throw new RuntimeException("Stub!"); }

@Deprecated
public void release() { throw new RuntimeException("Stub!"); }

@android.annotation.Nullable
public android.media.MediaDrm.PlaybackComponent getPlaybackComponent(@android.annotation.NonNull byte[] sessionId) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public native java.util.List<android.media.MediaDrm.LogMessage> getLogMessages();

@Deprecated public static final int EVENT_KEY_EXPIRED = 3; // 0x3

public static final int EVENT_KEY_REQUIRED = 2; // 0x2

@Deprecated public static final int EVENT_PROVISION_REQUIRED = 1; // 0x1

public static final int EVENT_SESSION_RECLAIMED = 5; // 0x5

public static final int EVENT_VENDOR_DEFINED = 4; // 0x4

public static final int HDCP_LEVEL_UNKNOWN = 0; // 0x0

public static final int HDCP_NONE = 1; // 0x1

public static final int HDCP_NO_DIGITAL_OUTPUT = 2147483647; // 0x7fffffff

public static final int HDCP_V1 = 2; // 0x2

public static final int HDCP_V2 = 3; // 0x3

public static final int HDCP_V2_1 = 4; // 0x4

public static final int HDCP_V2_2 = 5; // 0x5

public static final int HDCP_V2_3 = 6; // 0x6

public static final int KEY_TYPE_OFFLINE = 2; // 0x2

public static final int KEY_TYPE_RELEASE = 3; // 0x3

public static final int KEY_TYPE_STREAMING = 1; // 0x1

public static final int OFFLINE_LICENSE_STATE_RELEASED = 2; // 0x2

public static final int OFFLINE_LICENSE_STATE_UNKNOWN = 0; // 0x0

public static final int OFFLINE_LICENSE_STATE_USABLE = 1; // 0x1

public static final java.lang.String PROPERTY_ALGORITHMS = "algorithms";

public static final java.lang.String PROPERTY_DESCRIPTION = "description";

public static final java.lang.String PROPERTY_DEVICE_UNIQUE_ID = "deviceUniqueId";

public static final java.lang.String PROPERTY_VENDOR = "vendor";

public static final java.lang.String PROPERTY_VERSION = "version";

public static final int SECURITY_LEVEL_HW_SECURE_ALL = 5; // 0x5

public static final int SECURITY_LEVEL_HW_SECURE_CRYPTO = 3; // 0x3

public static final int SECURITY_LEVEL_HW_SECURE_DECODE = 4; // 0x4

public static final int SECURITY_LEVEL_SW_SECURE_CRYPTO = 1; // 0x1

public static final int SECURITY_LEVEL_SW_SECURE_DECODE = 2; // 0x2

public static final int SECURITY_LEVEL_UNKNOWN = 0; // 0x0
@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class CryptoSession {

CryptoSession() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public byte[] encrypt(@android.annotation.NonNull byte[] keyid, @android.annotation.NonNull byte[] input, @android.annotation.NonNull byte[] iv) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public byte[] decrypt(@android.annotation.NonNull byte[] keyid, @android.annotation.NonNull byte[] input, @android.annotation.NonNull byte[] iv) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public byte[] sign(@android.annotation.NonNull byte[] keyid, @android.annotation.NonNull byte[] message) { throw new RuntimeException("Stub!"); }

public boolean verify(@android.annotation.NonNull byte[] keyid, @android.annotation.NonNull byte[] message, @android.annotation.NonNull byte[] signature) { throw new RuntimeException("Stub!"); }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class ErrorCodes {

private ErrorCodes() { throw new RuntimeException("Stub!"); }

public static final int ERROR_CERTIFICATE_MALFORMED = 10; // 0xa

public static final int ERROR_CERTIFICATE_MISSING = 11; // 0xb

public static final int ERROR_CRYPTO_LIBRARY = 12; // 0xc

public static final int ERROR_FRAME_TOO_LARGE = 8; // 0x8

public static final int ERROR_GENERIC_OEM = 13; // 0xd

public static final int ERROR_GENERIC_PLUGIN = 14; // 0xe

public static final int ERROR_INIT_DATA = 15; // 0xf

public static final int ERROR_INSUFFICIENT_OUTPUT_PROTECTION = 4; // 0x4

public static final int ERROR_INSUFFICIENT_SECURITY = 7; // 0x7

public static final int ERROR_KEY_EXPIRED = 2; // 0x2

public static final int ERROR_KEY_NOT_LOADED = 16; // 0x10

public static final int ERROR_LICENSE_PARSE = 17; // 0x11

public static final int ERROR_LICENSE_POLICY = 18; // 0x12

public static final int ERROR_LICENSE_RELEASE = 19; // 0x13

public static final int ERROR_LICENSE_REQUEST_REJECTED = 20; // 0x14

public static final int ERROR_LICENSE_RESTORE = 21; // 0x15

public static final int ERROR_LICENSE_STATE = 22; // 0x16

public static final int ERROR_LOST_STATE = 9; // 0x9

public static final int ERROR_MEDIA_FRAMEWORK = 23; // 0x17

public static final int ERROR_NO_KEY = 1; // 0x1

public static final int ERROR_PROVISIONING_CERTIFICATE = 24; // 0x18

public static final int ERROR_PROVISIONING_CONFIG = 25; // 0x19

public static final int ERROR_PROVISIONING_PARSE = 26; // 0x1a

public static final int ERROR_PROVISIONING_REQUEST_REJECTED = 27; // 0x1b

public static final int ERROR_PROVISIONING_RETRY = 28; // 0x1c

public static final int ERROR_RESOURCE_BUSY = 3; // 0x3

public static final int ERROR_RESOURCE_CONTENTION = 29; // 0x1d

public static final int ERROR_SECURE_STOP_RELEASE = 30; // 0x1e

public static final int ERROR_SESSION_NOT_OPENED = 5; // 0x5

public static final int ERROR_STORAGE_READ = 31; // 0x1f

public static final int ERROR_STORAGE_WRITE = 32; // 0x20

public static final int ERROR_UNKNOWN = 0; // 0x0

public static final int ERROR_UNSUPPORTED_OPERATION = 6; // 0x6

public static final int ERROR_ZERO_SUBSAMPLES = 33; // 0x21
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
@Deprecated
@java.lang.annotation.Retention(java.lang.annotation.RetentionPolicy.SOURCE)
public static @interface HdcpLevel {
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class KeyRequest {

KeyRequest() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public byte[] getData() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.lang.String getDefaultUrl() { throw new RuntimeException("Stub!"); }

public int getRequestType() { throw new RuntimeException("Stub!"); }

public static final int REQUEST_TYPE_INITIAL = 0; // 0x0

public static final int REQUEST_TYPE_NONE = 3; // 0x3

public static final int REQUEST_TYPE_RELEASE = 2; // 0x2

public static final int REQUEST_TYPE_RENEWAL = 1; // 0x1

public static final int REQUEST_TYPE_UPDATE = 4; // 0x4
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class KeyStatus {

KeyStatus() { throw new RuntimeException("Stub!"); }

public int getStatusCode() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public byte[] getKeyId() { throw new RuntimeException("Stub!"); }

public static final int STATUS_EXPIRED = 1; // 0x1

public static final int STATUS_INTERNAL_ERROR = 4; // 0x4

public static final int STATUS_OUTPUT_NOT_ALLOWED = 2; // 0x2

public static final int STATUS_PENDING = 3; // 0x3

public static final int STATUS_USABLE = 0; // 0x0

public static final int STATUS_USABLE_IN_FUTURE = 5; // 0x5
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class LogMessage {

private LogMessage() { throw new RuntimeException("Stub!"); }

public long getTimestampMillis() { throw new RuntimeException("Stub!"); }

public int getPriority() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.lang.String getMessage() { throw new RuntimeException("Stub!"); }

public java.lang.String toString() { throw new RuntimeException("Stub!"); }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class MediaDrmStateException extends java.lang.IllegalStateException {

MediaDrmStateException() { throw new RuntimeException("Stub!"); }

public int getErrorCode() { throw new RuntimeException("Stub!"); }

public boolean isTransient() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.lang.String getDiagnosticInfo() { throw new RuntimeException("Stub!"); }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class MetricsConstants {

private MetricsConstants() { throw new RuntimeException("Stub!"); }

public static final java.lang.String CLOSE_SESSION_ERROR_COUNT = "drm.mediadrm.close_session.error.count";

public static final java.lang.String CLOSE_SESSION_ERROR_LIST = "drm.mediadrm.close_session.error.list";

public static final java.lang.String CLOSE_SESSION_OK_COUNT = "drm.mediadrm.close_session.ok.count";

public static final java.lang.String EVENT_KEY_EXPIRED_COUNT = "drm.mediadrm.event.KEY_EXPIRED.count";

public static final java.lang.String EVENT_KEY_NEEDED_COUNT = "drm.mediadrm.event.KEY_NEEDED.count";

public static final java.lang.String EVENT_PROVISION_REQUIRED_COUNT = "drm.mediadrm.event.PROVISION_REQUIRED.count";

public static final java.lang.String EVENT_SESSION_RECLAIMED_COUNT = "drm.mediadrm.event.SESSION_RECLAIMED.count";

public static final java.lang.String EVENT_VENDOR_DEFINED_COUNT = "drm.mediadrm.event.VENDOR_DEFINED.count";

public static final java.lang.String GET_DEVICE_UNIQUE_ID_ERROR_COUNT = "drm.mediadrm.get_device_unique_id.error.count";

public static final java.lang.String GET_DEVICE_UNIQUE_ID_ERROR_LIST = "drm.mediadrm.get_device_unique_id.error.list";

public static final java.lang.String GET_DEVICE_UNIQUE_ID_OK_COUNT = "drm.mediadrm.get_device_unique_id.ok.count";

public static final java.lang.String GET_KEY_REQUEST_ERROR_COUNT = "drm.mediadrm.get_key_request.error.count";

public static final java.lang.String GET_KEY_REQUEST_ERROR_LIST = "drm.mediadrm.get_key_request.error.list";

public static final java.lang.String GET_KEY_REQUEST_OK_COUNT = "drm.mediadrm.get_key_request.ok.count";

public static final java.lang.String GET_KEY_REQUEST_OK_TIME_MICROS = "drm.mediadrm.get_key_request.ok.average_time_micros";

public static final java.lang.String GET_PROVISION_REQUEST_ERROR_COUNT = "drm.mediadrm.get_provision_request.error.count";

public static final java.lang.String GET_PROVISION_REQUEST_ERROR_LIST = "drm.mediadrm.get_provision_request.error.list";

public static final java.lang.String GET_PROVISION_REQUEST_OK_COUNT = "drm.mediadrm.get_provision_request.ok.count";

public static final java.lang.String KEY_STATUS_EXPIRED_COUNT = "drm.mediadrm.key_status.EXPIRED.count";

public static final java.lang.String KEY_STATUS_INTERNAL_ERROR_COUNT = "drm.mediadrm.key_status.INTERNAL_ERROR.count";

public static final java.lang.String KEY_STATUS_OUTPUT_NOT_ALLOWED_COUNT = "drm.mediadrm.key_status_change.OUTPUT_NOT_ALLOWED.count";

public static final java.lang.String KEY_STATUS_PENDING_COUNT = "drm.mediadrm.key_status_change.PENDING.count";

public static final java.lang.String KEY_STATUS_USABLE_COUNT = "drm.mediadrm.key_status_change.USABLE.count";

public static final java.lang.String OPEN_SESSION_ERROR_COUNT = "drm.mediadrm.open_session.error.count";

public static final java.lang.String OPEN_SESSION_ERROR_LIST = "drm.mediadrm.open_session.error.list";

public static final java.lang.String OPEN_SESSION_OK_COUNT = "drm.mediadrm.open_session.ok.count";

public static final java.lang.String PROVIDE_KEY_RESPONSE_ERROR_COUNT = "drm.mediadrm.provide_key_response.error.count";

public static final java.lang.String PROVIDE_KEY_RESPONSE_ERROR_LIST = "drm.mediadrm.provide_key_response.error.list";

public static final java.lang.String PROVIDE_KEY_RESPONSE_OK_COUNT = "drm.mediadrm.provide_key_response.ok.count";

public static final java.lang.String PROVIDE_KEY_RESPONSE_OK_TIME_MICROS = "drm.mediadrm.provide_key_response.ok.average_time_micros";

public static final java.lang.String PROVIDE_PROVISION_RESPONSE_ERROR_COUNT = "drm.mediadrm.provide_provision_response.error.count";

public static final java.lang.String PROVIDE_PROVISION_RESPONSE_ERROR_LIST = "drm.mediadrm.provide_provision_response.error.list";

public static final java.lang.String PROVIDE_PROVISION_RESPONSE_OK_COUNT = "drm.mediadrm.provide_provision_response.ok.count";

public static final java.lang.String SESSION_END_TIMES_MS = "drm.mediadrm.session_end_times_ms";

public static final java.lang.String SESSION_START_TIMES_MS = "drm.mediadrm.session_start_times_ms";
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface OnEventListener {

public void onEvent(@android.annotation.NonNull android.media.MediaDrm md, @android.annotation.Nullable byte[] sessionId, int event, int extra, @android.annotation.Nullable byte[] data);
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface OnExpirationUpdateListener {

public void onExpirationUpdate(@android.annotation.NonNull android.media.MediaDrm md, @android.annotation.NonNull byte[] sessionId, long expirationTime);
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface OnKeyStatusChangeListener {

public void onKeyStatusChange(@android.annotation.NonNull android.media.MediaDrm md, @android.annotation.NonNull byte[] sessionId, @android.annotation.NonNull java.util.List<android.media.MediaDrm.KeyStatus> keyInformation, boolean hasNewUsableKey);
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static interface OnSessionLostStateListener {

public void onSessionLostState(@android.annotation.NonNull android.media.MediaDrm md, @android.annotation.NonNull byte[] sessionId);
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class PlaybackComponent {

PlaybackComponent() { throw new RuntimeException("Stub!"); }

public void setLogSessionId(@android.annotation.NonNull android.media.metrics.LogSessionId logSessionId) { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public android.media.metrics.LogSessionId getLogSessionId() { throw new RuntimeException("Stub!"); }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class ProvisionRequest {

ProvisionRequest() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public byte[] getData() { throw new RuntimeException("Stub!"); }

@android.annotation.NonNull
public java.lang.String getDefaultUrl() { throw new RuntimeException("Stub!"); }
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
@Deprecated
@java.lang.annotation.Retention(java.lang.annotation.RetentionPolicy.SOURCE)
public static @interface SecurityLevel {
}

@SuppressWarnings({"unchecked", "deprecation", "all"})
public static final class SessionException extends java.lang.RuntimeException {

public SessionException(int errorCode, @android.annotation.Nullable java.lang.String detailMessage) { throw new RuntimeException("Stub!"); }

@Deprecated
public int getErrorCode() { throw new RuntimeException("Stub!"); }

public boolean isTransient() { throw new RuntimeException("Stub!"); }

@Deprecated public static final int ERROR_RESOURCE_CONTENTION = 1; // 0x1

@Deprecated public static final int ERROR_UNKNOWN = 0; // 0x0
}

}

