/*
 * Copyright 2021 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */


package android.app.appsearch.observer;


/**
 * Contains information about an individual change detected by an {@link android.app.appsearch.observer.ObserverCallback ObserverCallback}.
 *
 * <p>This class reports information about document changes, i.e. when documents were added, updated
 * or removed.
 *
 * <p>Changes are grouped by package, database, schema type and namespace. Each unique combination
 * of these items will generate a unique {@link android.app.appsearch.observer.DocumentChangeInfo DocumentChangeInfo}.
 *
 * <p>Notifications are only sent for documents whose schema type matches an observer's schema
 * filters (as determined by {@link android.app.appsearch.observer.ObserverSpec#getFilterSchemas ObserverSpec#getFilterSchemas}).
 *
 * <p>Note that document changes that happen during schema migration from calling {@link
 * android.app.appsearch.AppSearchSession#setSchema} are not reported via this class. Such changes
 * are reported through {@link android.app.appsearch.observer.SchemaChangeInfo SchemaChangeInfo}.
 */

@SuppressWarnings({"unchecked", "deprecation", "all"})
public final class DocumentChangeInfo {

/**
 * Constructs a new {@link android.app.appsearch.observer.DocumentChangeInfo DocumentChangeInfo}.
 *
 * @param packageName The package name of the app which owns the documents that changed.
 * This value cannot be {@code null}.
 * @param database The database in which the documents that changed reside.
 * This value cannot be {@code null}.
 * @param namespace The namespace in which the documents that changed reside.
 * This value cannot be {@code null}.
 * @param schemaName The name of the schema type that contains the changed documents.
 * This value cannot be {@code null}.
 * @param changedDocumentIds The set of document IDs that have been changed as part of this
 *     notification.

 * This value cannot be {@code null}.
 */

public DocumentChangeInfo(@android.annotation.NonNull java.lang.String packageName, @android.annotation.NonNull java.lang.String database, @android.annotation.NonNull java.lang.String namespace, @android.annotation.NonNull java.lang.String schemaName, @android.annotation.NonNull java.util.Set<java.lang.String> changedDocumentIds) { throw new RuntimeException("Stub!"); }

/**
 * Returns the package name of the app which owns the documents that changed.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.lang.String getPackageName() { throw new RuntimeException("Stub!"); }

/**
 * Returns the database in which the documents that was changed reside.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.lang.String getDatabaseName() { throw new RuntimeException("Stub!"); }

/**
 * Returns the namespace of the documents that changed.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.lang.String getNamespace() { throw new RuntimeException("Stub!"); }

/**
 * Returns the name of the schema type that contains the changed documents.
 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.lang.String getSchemaName() { throw new RuntimeException("Stub!"); }

/**
 * Returns the set of document IDs that have been changed as part of this notification.
 *
 * <p>This will never be empty.

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.util.Set<java.lang.String> getChangedDocumentIds() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @param o This value may be {@code null}.
 */

public boolean equals(@android.annotation.Nullable java.lang.Object o) { throw new RuntimeException("Stub!"); }

public int hashCode() { throw new RuntimeException("Stub!"); }

/**
 * {@inheritDoc}

 * @return This value cannot be {@code null}.
 */

@android.annotation.NonNull
public java.lang.String toString() { throw new RuntimeException("Stub!"); }
}

