"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.behaviors = void 0;
const SoundSwitchCC_1 = require("@zwave-js/cc/SoundSwitchCC");
const safe_1 = require("@zwave-js/core/safe");
const testing_1 = require("@zwave-js/testing");
const defaultCapabilities = {
    defaultToneId: 1,
    defaultVolume: 0,
    tones: [],
};
const STATE_KEY_PREFIX = "SoundSwitch_";
const StateKeys = {
    defaultToneId: `${STATE_KEY_PREFIX}defaultToneId`,
    defaultVolume: `${STATE_KEY_PREFIX}defaultVolume`,
};
const respondToSoundSwitchConfigurationGet = {
    async onControllerFrame(controller, self, frame) {
        if (frame.type === testing_1.MockZWaveFrameType.Request &&
            frame.payload instanceof SoundSwitchCC_1.SoundSwitchCCConfigurationGet) {
            const capabilities = {
                ...defaultCapabilities,
                ...self.getCCCapabilities(safe_1.CommandClasses["Sound Switch"], frame.payload.endpointIndex),
            };
            const cc = new SoundSwitchCC_1.SoundSwitchCCConfigurationReport(self.host, {
                nodeId: controller.host.ownNodeId,
                defaultToneId: self.state.get(StateKeys.defaultToneId) ??
                    capabilities.defaultToneId,
                defaultVolume: self.state.get(StateKeys.defaultVolume) ??
                    capabilities.defaultVolume,
            });
            await self.sendToController((0, testing_1.createMockZWaveRequestFrame)(cc, {
                ackRequested: false,
            }));
            return true;
        }
        return false;
    },
};
const respondToSoundSwitchConfigurationSet = {
    onControllerFrame(controller, self, frame) {
        if (frame.type === testing_1.MockZWaveFrameType.Request &&
            frame.payload instanceof SoundSwitchCC_1.SoundSwitchCCConfigurationSet) {
            self.state.set(StateKeys.defaultToneId, frame.payload.defaultToneId);
            self.state.set(StateKeys.defaultVolume, frame.payload.defaultVolume);
            return true;
        }
        return false;
    },
};
const respondToSoundSwitchToneNumberGet = {
    async onControllerFrame(controller, self, frame) {
        if (frame.type === testing_1.MockZWaveFrameType.Request &&
            frame.payload instanceof SoundSwitchCC_1.SoundSwitchCCTonesNumberGet) {
            const capabilities = {
                ...defaultCapabilities,
                ...self.getCCCapabilities(safe_1.CommandClasses["Sound Switch"], frame.payload.endpointIndex),
            };
            const cc = new SoundSwitchCC_1.SoundSwitchCCTonesNumberReport(self.host, {
                nodeId: controller.host.ownNodeId,
                toneCount: capabilities.tones.length,
            });
            await self.sendToController((0, testing_1.createMockZWaveRequestFrame)(cc, {
                ackRequested: false,
            }));
            return true;
        }
        return false;
    },
};
const respondToSoundSwitchToneInfoGet = {
    async onControllerFrame(controller, self, frame) {
        if (frame.type === testing_1.MockZWaveFrameType.Request &&
            frame.payload instanceof SoundSwitchCC_1.SoundSwitchCCToneInfoGet) {
            const capabilities = {
                ...defaultCapabilities,
                ...self.getCCCapabilities(safe_1.CommandClasses["Sound Switch"], frame.payload.endpointIndex),
            };
            const tone = capabilities.tones[frame.payload.toneId - 1];
            if (tone) {
                const cc = new SoundSwitchCC_1.SoundSwitchCCToneInfoReport(self.host, {
                    nodeId: controller.host.ownNodeId,
                    toneId: frame.payload.toneId,
                    ...tone,
                });
                await self.sendToController((0, testing_1.createMockZWaveRequestFrame)(cc, {
                    ackRequested: false,
                }));
                return true;
            }
        }
        return false;
    },
};
exports.behaviors = [
    respondToSoundSwitchConfigurationGet,
    respondToSoundSwitchConfigurationSet,
    respondToSoundSwitchToneNumberGet,
    respondToSoundSwitchToneInfoGet,
];
//# sourceMappingURL=SoundSwitch.js.map