export declare type HealNodeStatus = "pending" | "done" | "failed" | "skipped";
export declare type SDKVersion = `${number}.${number}` | `${number}.${number}.${number}`;
export interface FirmwareUpdateFileInfo {
    target: number;
    url: string;
    integrity: `sha256:${string}`;
}
export interface FirmwareUpdateInfo {
    version: string;
    changelog: string;
    channel: "stable" | "beta";
    files: FirmwareUpdateFileInfo[];
    downgrade: boolean;
    normalizedVersion: string;
}
export interface GetFirmwareUpdatesOptions {
    /** Allows overriding the API key for the firmware update service */
    apiKey?: string;
    /** Allows adding new components to the user agent sent to the firmware update service (existing components cannot be overwritten) */
    additionalUserAgentComponents?: Record<string, string>;
    /** Whether the returned firmware upgrades should include prereleases from the `"beta"` channel. Default: `false`. */
    includePrereleases?: boolean;
}
//# sourceMappingURL=_Types.d.ts.map