/// <reference types="node" />
import { RouteKind, ZWaveDataRate, type MessageOrCCLogEntry } from "@zwave-js/core";
import type { ZWaveHost } from "@zwave-js/host";
import { Message, type MessageBaseOptions, type MessageDeserializationOptions } from "@zwave-js/serial";
export interface GetPriorityRouteRequestOptions extends MessageBaseOptions {
    destinationNodeId: number;
}
export declare class GetPriorityRouteRequest extends Message {
    constructor(host: ZWaveHost, options: MessageDeserializationOptions | GetPriorityRouteRequestOptions);
    destinationNodeId: number;
    serialize(): Buffer;
    toLogEntry(): MessageOrCCLogEntry;
}
export declare class GetPriorityRouteResponse extends Message {
    constructor(host: ZWaveHost, options: MessageDeserializationOptions);
    readonly destinationNodeId: number;
    readonly routeKind: RouteKind;
    readonly repeaters?: number[];
    readonly routeSpeed?: ZWaveDataRate;
    toLogEntry(): MessageOrCCLogEntry;
}
//# sourceMappingURL=GetPriorityRouteMessages.d.ts.map