import { Interpreter, StateMachine } from "xstate";
export interface TransportServiceRXStateSchema {
    states: {
        waitingForSegment: {};
        segmentTimeout: {};
        waitingForRequestedSegment: {};
        segmentsComplete: {};
        success: {};
        failure: {};
    };
}
export interface TransportServiceRXContext {
    receivedBytes: boolean[];
}
export type TransportServiceRXEvent = {
    type: "segment";
    offset: number;
    length: number;
};
export type TransportServiceRXMachine = StateMachine<TransportServiceRXContext, TransportServiceRXStateSchema, TransportServiceRXEvent, any, any, any, any>;
export type TransportServiceRXInterpreter = Interpreter<TransportServiceRXContext, TransportServiceRXStateSchema, TransportServiceRXEvent>;
export type TransportServiceRXMachineParams = {
    datagramSize: number;
    firstSegmentSize: number;
    missingSegmentTimeout: number;
};
export interface TransportServiceRXServiceImplementations {
    requestMissingSegment(offset: number): Promise<void>;
    sendSegmentsComplete(): Promise<void>;
}
export declare function createTransportServiceRXMachine(implementations: TransportServiceRXServiceImplementations, params: TransportServiceRXMachineParams): TransportServiceRXMachine;
//# sourceMappingURL=TransportServiceMachine.d.ts.map