import Device from './model/device';
import Group from './model/group';
export default class Zigbee {
    private herdsman;
    private eventBus;
    private resolvedEntitiesLookup;
    constructor(eventBus: EventBus);
    start(): Promise<'reset' | 'resumed' | 'restored'>;
    private generateNetworkKey;
    private generatePanID;
    getCoordinatorVersion(): Promise<CoordinatorVersion>;
    isStopping(): boolean;
    getNetworkParameters(): Promise<NetworkParameters>;
    reset(type: 'soft' | 'hard'): Promise<void>;
    stop(): Promise<void>;
    getPermitJoin(): boolean;
    getPermitJoinTimeout(): number;
    permitJoin(permit: boolean, device?: Device, time?: number): Promise<void>;
    private addDeviceToResolvedEntitiesLookup;
    private addGroupToResolvedEntitiesLookup;
    resolveEntity(key: ZHDevice | string): Device | Group;
    getClients(): Device[];
    getFirstCoordinatorEndpoint(): ZHEndpoint;
    getGroups(): Group[];
    getDevices(): Device[];
    private acceptJoiningDeviceHandler;
    touchlinkFactoryResetFirst(): Promise<boolean>;
    touchlinkFactoryReset(ieeeAddr: string, channel: number): Promise<boolean>;
    touchlinkIdentify(ieeeAddr: string, channel: number): Promise<void>;
    touchlinkScan(): Promise<{
        ieeeAddr: string;
        channel: number;
    }[]>;
    createGroup(groupID: number): Group;
    deviceByNetworkAddress(networkAddress: number): Device;
    createGroupLegacy(groupID: number): ZHGroup;
    getGroupsLegacy(): ZHGroup[];
    getGroupByIDLegacy(ID: number): ZHGroup;
    getDevicesByTypeLegacy(type: 'Coordinator' | 'Router' | 'EndDevice'): ZHDevice[];
    getClientsLegacy(): ZHDevice[];
    getDevicesLegacy(): ZHDevice[];
    permitJoinLegacy(permit: boolean, resolvedEntity: ResolvedDevice, time?: number): Promise<void>;
    resolveEntityLegacy(key: any): any;
}
//# sourceMappingURL=zigbee.d.ts.map