import { Endpoint } from 'zigbee-herdsman/dist/controller/model';
export declare const endpointNames: string[];
export declare function capitalize(s: string): string;
export declare function getZigbee2MQTTVersionSimple(): Promise<string>;
export declare function getZigbee2MQTTVersion(): Promise<{
    commitHash: string;
    version: string;
}>;
export declare function getDependencyVersion(depend: string): Promise<{
    version: string;
}>;
export declare function formatDate(time: number, type: 'ISO_8601' | 'ISO_8601_local' | 'epoch' | 'relative'): string | number;
export declare function objectHasProperties(object: {
    [s: string]: unknown;
}, properties: string[]): boolean;
export declare function equalsPartial(object: {
    [s: string]: unknown;
}, expected: {
    [s: string]: unknown;
}): boolean;
export declare function getObjectProperty(object: {
    [s: string]: unknown;
}, key: string, defaultValue: unknown): unknown;
export declare function getResponse(request: KeyValue | string, data: KeyValue, error: string): MQTTResponse;
export declare function parseJSON(value: string, failedReturnValue: string): KeyValue | string;
export declare function loadModuleFromText(moduleCode: string): unknown;
export declare function loadModuleFromFile(modulePath: string): unknown;
export declare function getExternalConvertersDefinitions(settings: any): any;
export declare function removeNullPropertiesFromObject(obj: KeyValue): void;
export declare function getKey(object: KeyValue, value: unknown, fallback: unknown, convertTo: (v: unknown) => unknown): unknown;
export declare function toNetworkAddressHex(value: number): string;
export declare function toSnakeCase(value: string | KeyValue): any;
export declare function validateFriendlyName(name: string, throwFirstError?: boolean): string[];
export declare function sleep(seconds: number): Promise<void>;
export declare function sanitizeImageParameter(parameter: string): string;
export declare function isAvailabilityEnabledForDevice(device: Device, settings: Settings): boolean;
export declare function isAvailabilityEnabledForDeviceLegacy(rd: ResolvedDevice, settings: Settings): boolean;
export declare function isXiaomiDevice(device: ZHDevice): boolean;
export declare function isIkeaTradfriDevice(device: ZHDevice): boolean;
export declare function parseEntityID(ID: string): {
    ID: string;
    endpoint: string;
};
export declare function isEndpoint(obj: unknown): obj is Endpoint;
export declare const hours: (hours: number) => number;
export declare const minutes: (minutes: number) => number;
export declare const seconds: (seconds: number) => number;
//# sourceMappingURL=utils.d.ts.map